/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.validation;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.provisional.ValidationFactory;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.validation.DelegatingSourceValidator;

public class DelegatingSourceValidatorForXSD
extends DelegatingSourceValidator {
    private static final String VALIDATOR_CLASS = "org.eclipse.wst.xsd.core.internal.validation.eclipse.XSDDelegatingValidator";

    protected IValidator getDelegateValidator() {
        try {
            return ValidationFactory.instance.getValidator(VALIDATOR_CLASS);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected boolean isDelegateValidatorEnabled(IFile file) {
        boolean enabled = true;
        try {
            ProjectConfiguration configuration = ConfigurationManager.getManager().getProjectConfiguration(file.getProject());
            ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(VALIDATOR_CLASS);
            enabled = configuration.isBuildEnabled(vmd) || configuration.isManualEnabled(vmd);
        }
        catch (InvocationTargetException e) {
            Logger.log((int)202, (String)e.getMessage(), (Throwable)e);
        }
        return enabled;
    }
}

