/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMNamespaceInfoManager;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xsd.ui.internal.common.commands.AddExtensionCommand;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDConcreteComponent;
import org.w3c.dom.Element;

public class AddExtensionAttributeCommand
extends AddExtensionCommand {
    private static DOMNamespaceInfoManager manager = new DOMNamespaceInfoManager();
    private XSDAttributeDeclaration attribute;
    private boolean appInfoAttributeAdded = false;
    private String attributeQName;
    private String namespacePrefix;

    public AddExtensionAttributeCommand(String label, XSDConcreteComponent component, XSDAttributeDeclaration attribute) {
        super(label);
        this.component = component;
        this.attribute = attribute;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        try {
            this.beginRecording(this.component.getElement());
            super.execute();
            this.namespacePrefix = this.handleNamespacePrefices();
            this.attributeQName = String.valueOf(this.namespacePrefix) + ":" + this.attribute.getName();
            String value = this.component.getElement().getAttribute(this.attributeQName);
            if (value == null) {
                this.appInfoAttributeAdded = true;
                this.component.getElement().setAttribute(this.attributeQName, "");
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.endRecording();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.endRecording();
    }

    public void undo() {
        super.undo();
        if (this.appInfoAttributeAdded) {
            this.component.getElement().removeAttribute(this.attributeQName);
        }
    }

    private String handleNamespacePrefices() {
        Element schemaElement = this.component.getSchema().getElement();
        String prefix = null;
        List namespacePrefices = manager.getNamespaceInfoList(schemaElement);
        int i = 0;
        while (i < namespacePrefices.size()) {
            NamespaceInfo info = (NamespaceInfo)namespacePrefices.get(i);
            if (info.uri.equals(this.attribute.getTargetNamespace())) {
                prefix = info.prefix;
            }
            ++i;
        }
        if (prefix == null) {
            prefix = this.createUniquePrefix(this.component);
        }
        NamespaceInfo info = new NamespaceInfo(this.attribute.getTargetNamespace(), prefix, "");
        ArrayList<NamespaceInfo> infoList = new ArrayList<NamespaceInfo>(1);
        infoList.add(info);
        manager.addNamespaceInfo(schemaElement, infoList, false);
        return prefix;
    }

    protected String createUniquePrefix(XSDConcreteComponent component) {
        String prefix = "p";
        Map prefMapper = component.getSchema().getQNamePrefixToNamespaceMap();
        if (prefMapper.get(prefix) != null) {
            int i = 1;
            while (prefMapper.get(String.valueOf(prefix) + i) != null) {
                ++i;
            }
            prefix = String.valueOf(prefix) + i;
        }
        return prefix;
    }
}

