/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.util.ArrayList;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.HttpAuthenticator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Authenticator {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$Authenticator == null ? (class$org$apache$commons$httpclient$Authenticator = Authenticator.class$("org.apache.commons.httpclient.Authenticator")) : class$org$apache$commons$httpclient$Authenticator));
    public static final String WWW_AUTH = "WWW-Authenticate";
    public static final String WWW_AUTH_RESP = "Authorization";
    public static final String PROXY_AUTH = "Proxy-Authenticate";
    public static final String PROXY_AUTH_RESP = "Proxy-Authorization";
    static /* synthetic */ Class class$org$apache$commons$httpclient$Authenticator;

    public static boolean authenticate(HttpMethod method, HttpState state) throws HttpException, UnsupportedOperationException {
        LOG.trace((Object)"enter Authenticator.authenticate(HttpMethod, HttpState)");
        return Authenticator.authenticate(method, state, false);
    }

    public static boolean authenticateProxy(HttpMethod method, HttpState state) throws HttpException, UnsupportedOperationException {
        LOG.trace((Object)"enter Authenticator.authenticateProxy(HttpMethod, HttpState)");
        return Authenticator.authenticate(method, state, true);
    }

    private static boolean authenticate(HttpMethod method, HttpState state, boolean proxy) throws HttpException, UnsupportedOperationException {
        LOG.trace((Object)"enter Authenticator.authenticate(HttpMethod, HttpState, Header, String)");
        return Authenticator.authenticate(method, null, state, proxy);
    }

    private static boolean authenticate(HttpMethod method, HttpConnection conn, HttpState state, boolean proxy) throws HttpException, UnsupportedOperationException {
        String challengeheader = proxy ? PROXY_AUTH : WWW_AUTH;
        Header[] headers = method.getResponseHeaders();
        ArrayList<Header> headerlist = new ArrayList<Header>();
        int i = 0;
        while (i < headers.length) {
            Header header = headers[i];
            if (header.getName().equalsIgnoreCase(challengeheader)) {
                headerlist.add(header);
            }
            ++i;
        }
        headers = headerlist.toArray(new Header[headerlist.size()]);
        headerlist = null;
        if (headers.length == 0) {
            if (state.isAuthenticationPreemptive()) {
                LOG.debug((Object)"Preemptively sending default basic credentials");
                if (proxy) {
                    return HttpAuthenticator.authenticateProxyDefault(method, conn, state);
                }
                return HttpAuthenticator.authenticateDefault(method, conn, state);
            }
            return false;
        }
        AuthScheme authscheme = HttpAuthenticator.selectAuthScheme(headers);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using " + authscheme.getSchemeName() + " authentication scheme"));
        }
        if (proxy) {
            return HttpAuthenticator.authenticateProxy(authscheme, method, conn, state);
        }
        return HttpAuthenticator.authenticate(authscheme, method, conn, state);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

