/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.MessageReference;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;

public class NameUtil {
    public static String buildUniqueFaultName(Operation operation) {
        return NameUtil.buildUniqueFaultName(operation, "NewFault");
    }

    public static String buildUniqueFaultName(Operation operation, String baseName) {
        if (baseName == null) {
            baseName = "NewFault";
        }
        List names = NameUtil.getUsedFaultNames(operation);
        return NameUtil.getUniqueNameHelper(baseName, names);
    }

    public static String buildUniqueInputName(PortType portType, String operationName, String ending) {
        String name = null;
        String candidate = String.valueOf(operationName) + ending;
        int i = 0;
        while (name == null) {
            boolean unique = true;
            Iterator it = portType.getEOperations().iterator();
            while (it.hasNext() && unique) {
                Operation current = (Operation)it.next();
                if (current.getEInput() == null || current.getEInput().getName() == null || !current.getEInput().getName().equals(candidate)) continue;
                unique = false;
            }
            if (unique) {
                name = candidate;
            } else {
                candidate = String.valueOf(operationName) + ending + i;
            }
            ++i;
        }
        return name;
    }

    public static String buildUniqueMessageName(Definition definition, String baseName) {
        if (baseName == null) {
            baseName = "NewMessage";
        }
        List names = NameUtil.getUsedMessageNames(definition);
        return NameUtil.getUniqueNameHelper(baseName, names);
    }

    public static String buildUniqueOperationName(PortType portType) {
        return NameUtil.buildUniqueOperationName(portType, "NewOperation");
    }

    public static String buildUniqueOperationName(PortType portType, String baseName) {
        if (baseName == null) {
            baseName = "NewOperation";
        }
        List names = NameUtil.getUsedOperationNames(portType);
        return NameUtil.getUniqueNameHelper(baseName, names);
    }

    public static String buildUniqueOutputName(PortType portType, String operationName, String ending) {
        String name = null;
        String candidate = String.valueOf(operationName) + ending;
        int i = 0;
        while (name == null) {
            boolean unique = true;
            Iterator it = portType.getEOperations().iterator();
            while (it.hasNext() && unique) {
                Operation current = (Operation)it.next();
                if (current.getEOutput() == null || current.getEOutput().getName() == null || !current.getEOutput().getName().equals(candidate)) continue;
                unique = false;
            }
            if (unique) {
                name = candidate;
            } else {
                candidate = String.valueOf(operationName) + ending + i;
            }
            ++i;
        }
        return name;
    }

    public static String buildUniquePartName(Message message) {
        List names = NameUtil.getUsedPartNames(message);
        return NameUtil.getUniqueNameHelper("NewPart", names);
    }

    public static String buildUniquePartName(Message message, String baseName) {
        if (baseName == null) {
            baseName = "NewPart";
        }
        List names = NameUtil.getUsedPartNames(message);
        return NameUtil.getUniqueNameHelper(baseName, names);
    }

    public static String buildUniquePortTypeName(Definition definition, String baseName) {
        if (baseName == null) {
            baseName = "NewPortType";
        }
        List names = NameUtil.getUsedPortTypeNames(definition);
        return NameUtil.getUniqueNameHelper(baseName, names);
    }

    public static String getUniqueNameHelper(String baseName, List names) {
        int i = 0;
        String name = baseName;
        while (names.contains(name)) {
            name = String.valueOf(baseName) + ++i;
        }
        return name;
    }

    public static String buildUniqueServiceName(Definition definition) {
        List names = NameUtil.getUsedServiceNames(definition);
        return NameUtil.getUniqueNameHelper("NewService", names);
    }

    public static String buildUniqueBindingName(Definition definition, String baseName) {
        if (baseName == null) {
            baseName = "NewBinding";
        }
        List names = NameUtil.getUsedBindingNames(definition);
        return NameUtil.getUniqueNameHelper(baseName, names);
    }

    public static String buildUniquePrefix(Definition definition, String basePrefix) {
        String prefix = basePrefix;
        int i = 1;
        while (definition.getNamespace(prefix) != null) {
            prefix = String.valueOf(basePrefix) + i;
            ++i;
        }
        return prefix;
    }

    public static String buildUniquePortName(Service service, String baseName) {
        if (baseName == null) {
            baseName = "NewPort";
        }
        List names = NameUtil.getUsedPortNames(service);
        return NameUtil.getUniqueNameHelper(baseName, names);
    }

    public static String buildUniqueMessageName(Definition definition, MessageReference messRef) {
        String name = null;
        if (messRef instanceof Input) {
            name = NameUtil.createOperationName(messRef, "Request");
        } else if (messRef instanceof Output) {
            name = NameUtil.createOperationName(messRef, "Response");
        } else if (messRef instanceof Fault) {
            String faultName = ((Fault)messRef).getName();
            if (faultName == null || faultName.length() == 0) {
                faultName = "Fault";
            }
            name = NameUtil.createOperationName(messRef, faultName);
        }
        return NameUtil.buildUniqueMessageName(definition, name);
    }

    public static List getUsedFaultNames(Operation operation) {
        ArrayList<String> names = new ArrayList<String>();
        Iterator i = operation.getEFaults().iterator();
        while (i.hasNext()) {
            Fault fault = (Fault)i.next();
            names.add(fault.getName());
        }
        return names;
    }

    public static List getUsedOperationNames(PortType portType) {
        ArrayList<String> names = new ArrayList<String>();
        Iterator i = portType.getEOperations().iterator();
        while (i.hasNext()) {
            Operation op = (Operation)i.next();
            names.add(op.getName());
        }
        return names;
    }

    public static List getUsedPartNames(Message message) {
        ArrayList<String> names = new ArrayList<String>();
        Iterator i = message.getEParts().iterator();
        while (i.hasNext()) {
            Part part = (Part)i.next();
            names.add(part.getName());
        }
        return names;
    }

    public static List getUsedPortTypeNames(Definition definition) {
        ArrayList<String> names = new ArrayList<String>();
        Iterator i = definition.getEPortTypes().iterator();
        while (i.hasNext()) {
            PortType portType = (PortType)i.next();
            if (portType.getQName() == null) continue;
            names.add(portType.getQName().getLocalPart());
        }
        return names;
    }

    public static List getUsedServiceNames(Definition definition) {
        ArrayList<String> names = new ArrayList<String>();
        Iterator i = definition.getEServices().iterator();
        while (i.hasNext()) {
            Service service = (Service)i.next();
            if (service.getQName() == null) continue;
            names.add(service.getQName().getLocalPart());
        }
        return names;
    }

    public static List getUsedMessageNames(Definition definition) {
        ArrayList<String> names = new ArrayList<String>();
        Iterator i = definition.getEMessages().iterator();
        while (i.hasNext()) {
            Message msg = (Message)i.next();
            if (msg.getQName() == null) continue;
            names.add(msg.getQName().getLocalPart());
        }
        return names;
    }

    public static List getUsedBindingNames(Definition definition) {
        ArrayList<String> names = new ArrayList<String>();
        Iterator i = definition.getEBindings().iterator();
        while (i.hasNext()) {
            Binding binding = (Binding)i.next();
            if (binding.getQName() == null) continue;
            names.add(binding.getQName().getLocalPart());
        }
        return names;
    }

    public static List getUsedPortNames(Service service) {
        ArrayList<String> names = new ArrayList<String>();
        Iterator i = service.getEPorts().iterator();
        while (i.hasNext()) {
            Port port = (Port)i.next();
            if (port.getName() == null) continue;
            names.add(port.getName());
        }
        return names;
    }

    private static String createOperationName(Object object, String suffix) {
        EObject parent;
        String result = null;
        if (object instanceof EObject && (parent = ((EObject)object).eContainer()) instanceof Operation) {
            result = ((Operation)parent).getName();
        }
        if (result != null) {
            result = String.valueOf(result) + suffix;
        }
        return result;
    }

    public static String getMessageName(MessageReference messageRef) {
        String messageName = "NewMessage";
        ArrayList<String> messageNames = new ArrayList<String>();
        Operation operation = (Operation)messageRef.getContainer();
        Iterator messageIt = operation.getEnclosingDefinition().getEMessages().iterator();
        while (messageIt.hasNext()) {
            messageNames.add(((Message)messageIt.next()).getQName().getLocalPart());
        }
        String requestResponseString = NameUtil.getRequestOrResponse(messageRef);
        messageName = NameUtil.getUniqueNameHelper(String.valueOf(operation.getName()) + requestResponseString, messageNames);
        return messageName;
    }

    public static String getPartName(MessageReference messageRef) {
        String partName = "NewPart";
        Message message = messageRef.getEMessage();
        Operation operation = (Operation)messageRef.getContainer();
        String operationName = operation.getName();
        String appendString = "";
        if (messageRef instanceof Input) {
            appendString = "Request";
        } else if (messageRef instanceof Output) {
            appendString = "Response";
        } else if (messageRef instanceof Fault) {
            appendString = "_Fault";
        }
        partName = String.valueOf(operationName) + appendString;
        ArrayList<String> usedPartNames = new ArrayList<String>();
        if (message != null) {
            partName = message.getQName().getLocalPart();
            Iterator partIt = message.getEParts().iterator();
            while (partIt.hasNext()) {
                usedPartNames.add(((Part)partIt.next()).getName());
            }
        }
        partName = NameUtil.getUniqueNameHelper(partName, usedPartNames);
        return partName;
    }

    public static String getOperationName(PortType portType) {
        String operationName = "NewOperation";
        Iterator operationIt = portType.getEOperations().iterator();
        ArrayList<String> usedNames = new ArrayList<String>();
        while (operationIt.hasNext()) {
            usedNames.add(((Operation)operationIt.next()).getName());
        }
        operationName = NameUtil.getUniqueNameHelper("NewOperation", usedNames);
        return operationName;
    }

    public static String getRequestOrResponse(MessageReference messageRef) {
        if (messageRef instanceof Input) {
            return "Request";
        }
        if (messageRef instanceof Output) {
            return "Response";
        }
        if (messageRef instanceof Fault) {
            return "_Fault";
        }
        return "";
    }

    public static String getFaultName(Operation operation) {
        String faultName = "fault";
        ArrayList<String> nameList = new ArrayList<String>();
        Iterator faultIt = operation.getEFaults().iterator();
        while (faultIt.hasNext()) {
            nameList.add(((Fault)faultIt.next()).getName());
        }
        faultName = NameUtil.getUniqueNameHelper(faultName, nameList);
        return faultName;
    }

    public static String getXSDElementName(String baseName, Object parent) {
        String elementName = "";
        if (parent instanceof XSDSchema) {
            elementName = NameUtil.getUniqueNameHelper(baseName, NameUtil.getUsedElementNames((XSDSchema)parent));
        } else if (parent instanceof XSDModelGroup) {
            ArrayList<String> existingNames = new ArrayList<String>();
            XSDModelGroup modelGroup = (XSDModelGroup)parent;
            Iterator modelGroupIt = modelGroup.getContents().iterator();
            while (modelGroupIt.hasNext()) {
                XSDParticle existingParticle;
                Object item = modelGroupIt.next();
                if (!(item instanceof XSDParticle) || !((existingParticle = (XSDParticle)item).getContent() instanceof XSDElementDeclaration)) continue;
                existingNames.add(((XSDElementDeclaration)existingParticle.getContent()).getName());
            }
            elementName = NameUtil.getUniqueNameHelper(baseName, existingNames);
        }
        return elementName;
    }

    public static String getXSDComplexTypeName(String baseName, XSDSchema schema) {
        String typeName = "";
        ArrayList<String> existingNames = new ArrayList<String>();
        Iterator it = schema.getTypeDefinitions().iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (!(item instanceof XSDComplexTypeDefinition)) continue;
            existingNames.add(((XSDComplexTypeDefinition)item).getName());
        }
        typeName = NameUtil.getUniqueNameHelper(baseName, existingNames);
        return typeName;
    }

    private static List getUsedElementNames(XSDSchema xsdSchema) {
        ArrayList<String> usedNames = new ArrayList<String>();
        Iterator schemaIt = xsdSchema.getContents().iterator();
        while (schemaIt.hasNext()) {
            Object item = schemaIt.next();
            if (!(item instanceof XSDElementDeclaration)) continue;
            usedNames.add(((XSDElementDeclaration)item).getName());
        }
        return usedNames;
    }
}

