/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.testunit.views;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.testunit.ITestRunListener;
import org.rubypeople.rdt.testunit.TestunitPlugin;
import org.rubypeople.rdt.testunit.views.CounterPanel;
import org.rubypeople.rdt.testunit.views.FailureTrace;
import org.rubypeople.rdt.testunit.views.ITestRunListener3;
import org.rubypeople.rdt.testunit.views.RemoteTestRunnerClient;
import org.rubypeople.rdt.testunit.views.ScrollLockAction;
import org.rubypeople.rdt.testunit.views.TabFolderLayout;
import org.rubypeople.rdt.testunit.views.TestRunInfo;
import org.rubypeople.rdt.testunit.views.TestRunTab;
import org.rubypeople.rdt.testunit.views.TestUnitMessages;
import org.rubypeople.rdt.testunit.views.TestUnitProgressBar;

public class TestUnitView
extends ViewPart
implements ITestRunListener3 {
    public static final String NAME = "org.rubypeople.rdt.testunit.views.TestUnitView";
    static final int REFRESH_INTERVAL = 200;
    public static final String ID_EXTENSION_POINT_TESTRUN_TABS = "org.rubypeople.rdt.testunit.internalTestRunTabs";
    static final int VIEW_ORIENTATION_VERTICAL = 0;
    static final int VIEW_ORIENTATION_HORIZONTAL = 1;
    static final int VIEW_ORIENTATION_AUTOMATIC = 2;
    final Image fStackViewIcon = TestUnitView.createImage("eview16/stackframe.gif");
    private TestRunTab fActiveRunTab;
    protected Vector fTestRunTabs = new Vector();
    private Map fTestInfos = new HashMap();
    private boolean fIsDisposed = false;
    private RemoteTestRunnerClient fTestRunnerClient;
    private String fLaunchMode;
    private ILaunch fLastLaunch;
    private Action fRerunLastTestAction;
    protected volatile int fExecutedTests;
    protected volatile int fErrorCount;
    protected volatile int fFailureCount;
    protected volatile int fTestCount;
    private List fFailures = new ArrayList();
    protected boolean fShowOnErrorOnly = false;
    private CounterPanel fCounterPanel;
    private TestUnitProgressBar fProgressBar;
    private int fCurrentOrientation;
    private Composite fCounterComposite;
    private SashForm fSashForm;
    private CTabFolder fTabFolder;
    private FailureTrace fFailureTrace;
    private Clipboard fClipboard;
    protected volatile String fStatus;
    private UpdateUIJob fUpdateJob;
    private boolean fAutoScroll = true;
    private ScrollLockAction fScrollLockAction;
    private IRubyProject fTestProject;

    public static Image createImage(String string) {
        try {
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)TestunitPlugin.makeIconFileURL(string));
            return imageDescriptor.createImage();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public void createPartControl(Composite composite) {
        this.fClipboard = new Clipboard(composite.getDisplay());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        this.configureToolBar();
        this.fCounterComposite = this.createProgressCountPanel(composite);
        this.fCounterComposite.setLayoutData((Object)new GridData(768));
        SashForm sashForm = this.createSashForm(composite);
        sashForm.setLayoutData((Object)new GridData(1808));
    }

    private void configureToolBar() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        this.fRerunLastTestAction = new RerunLastAction();
        this.fScrollLockAction = new ScrollLockAction(this);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.fRerunLastTestAction);
        iToolBarManager.add((IAction)this.fScrollLockAction);
        this.fScrollLockAction.setChecked(!this.fAutoScroll);
        iActionBars.updateActionBars();
    }

    private SashForm createSashForm(Composite composite) {
        this.fSashForm = new SashForm(composite, 512);
        ViewForm viewForm = new ViewForm((Composite)this.fSashForm, 0);
        this.fTabFolder = this.createTestRunTabs((Composite)viewForm);
        this.fTabFolder.setLayoutData((Object)new TabFolderLayout());
        viewForm.setContent((Control)this.fTabFolder);
        ViewForm viewForm2 = new ViewForm((Composite)this.fSashForm, 0);
        CLabel cLabel = new CLabel((Composite)viewForm2, 0);
        cLabel.setText(TestUnitMessages.getString("TestRunnerViewPart.label.failure"));
        cLabel.setImage(this.fStackViewIcon);
        viewForm2.setTopLeft((Control)cLabel);
        ToolBar toolBar = new ToolBar((Composite)viewForm2, 0x800040);
        viewForm2.setTopCenter((Control)toolBar);
        this.fFailureTrace = new FailureTrace((Composite)viewForm2, this.fClipboard, this, toolBar);
        viewForm2.setContent((Control)this.fFailureTrace.getComposite());
        this.fSashForm.setWeights(new int[]{50, 50});
        return this.fSashForm;
    }

    protected CTabFolder createTestRunTabs(Composite composite) {
        CTabFolder cTabFolder = new CTabFolder(composite, 128);
        cTabFolder.setLayoutData((Object)new GridData(1808));
        this.loadTestRunTabs(cTabFolder);
        cTabFolder.setSelection(0);
        this.fActiveRunTab = (TestRunTab)this.fTestRunTabs.firstElement();
        cTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TestUnitView.this.testTabChanged(selectionEvent);
            }
        });
        return cTabFolder;
    }

    private void testTabChanged(SelectionEvent selectionEvent) {
        Enumeration enumeration = this.fTestRunTabs.elements();
        while (enumeration.hasMoreElements()) {
            TestRunTab testRunTab = (TestRunTab)enumeration.nextElement();
            if (((CTabFolder)selectionEvent.widget).getSelection().getText() != testRunTab.getName()) continue;
            testRunTab.setSelectedTest(this.fActiveRunTab.getSelectedTestId());
            this.fActiveRunTab = testRunTab;
            this.fActiveRunTab.activate();
        }
    }

    private void loadTestRunTabs(CTabFolder cTabFolder) {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ID_EXTENSION_POINT_TESTRUN_TABS);
        if (iExtensionPoint == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        MultiStatus multiStatus = new MultiStatus("org.rubypeople.rdt.testunit", 0, "Could not load some testRunTabs extension points", null);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            try {
                TestRunTab testRunTab = (TestRunTab)iConfigurationElementArray[n].createExecutableExtension("class");
                testRunTab.createTabControl(cTabFolder, this.fClipboard, this);
                this.fTestRunTabs.addElement(testRunTab);
            }
            catch (CoreException coreException) {
                multiStatus.add(coreException.getStatus());
            }
            ++n;
        }
        if (!multiStatus.isOK()) {
            TestunitPlugin.log((IStatus)multiStatus);
        }
    }

    protected Composite createProgressCountPanel(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        this.setCounterColumns(gridLayout);
        this.fCounterPanel = new CounterPanel(composite2);
        this.fCounterPanel.setLayoutData(new GridData(768));
        this.fProgressBar = new TestUnitProgressBar(composite2);
        this.fProgressBar.setLayoutData(new GridData(768));
        return composite2;
    }

    private void setCounterColumns(GridLayout gridLayout) {
        gridLayout.numColumns = this.fCurrentOrientation == 1 ? 2 : 1;
    }

    public void setFocus() {
        if (this.fActiveRunTab != null) {
            this.fActiveRunTab.setFocus();
        }
    }

    public void showTest(TestRunInfo testRunInfo) {
        this.fActiveRunTab.setSelectedTest(testRunInfo.getTestId());
        this.handleTestSelected(testRunInfo.getTestId());
    }

    public void handleTestSelected(String string) {
        TestRunInfo testRunInfo = this.getTestInfo(string);
        if (testRunInfo == null) {
            this.showFailure(null);
        } else {
            this.showFailure(testRunInfo);
        }
    }

    public TestRunInfo getTestInfo(String string) {
        if (string == null) {
            return null;
        }
        return (TestRunInfo)this.fTestInfos.get(string);
    }

    private void showFailure(final TestRunInfo testRunInfo) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (!TestUnitView.this.isDisposed()) {
                    TestUnitView.this.fFailureTrace.showFailure(testRunInfo);
                }
            }
        });
    }

    private void postSyncRunnable(Runnable runnable) {
        if (!this.isDisposed()) {
            this.getDisplay().syncExec(runnable);
        }
    }

    private boolean isDisposed() {
        return this.fIsDisposed || this.fCounterPanel.isDisposed();
    }

    private Display getDisplay() {
        return this.getViewSite().getShell().getDisplay();
    }

    public synchronized void dispose() {
        this.fIsDisposed = true;
        this.stopTest();
        this.fStackViewIcon.dispose();
        if (this.fClipboard != null) {
            this.fClipboard.dispose();
        }
    }

    public void rerunTest(String string, String string2, String string3, String string4) {
        DebugUITools.saveAndBuildBeforeLaunch();
        if (this.lastLaunchIsKeptAlive()) {
            this.fTestRunnerClient.rerunTest(string, string2, string3);
        } else if (this.fLastLaunch != null) {
            ILaunchConfiguration iLaunchConfiguration = this.fLastLaunch.getLaunchConfiguration();
            if (iLaunchConfiguration != null) {
                try {
                    String string5 = string2;
                    if (string3 != null) {
                        string5 = String.valueOf(string5) + "." + string3;
                    }
                    String string6 = TestUnitMessages.getFormattedString("TestRunnerViewPart.configName", string5);
                    ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfiguration.copy(string6);
                    iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.testunit.TESTTYPE", string2);
                    if (string3 != null) {
                        iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.testunit.TESTNAME", string3);
                    }
                    iLaunchConfigurationWorkingCopy.launch(string4, null);
                    return;
                }
                catch (CoreException coreException) {
                    ErrorDialog.openError((Shell)this.getSite().getShell(), (String)TestUnitMessages.getString("TestRunnerViewPart.error.cannotrerun"), (String)coreException.getMessage(), (IStatus)coreException.getStatus());
                }
            }
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)TestUnitMessages.getString("TestRunnerViewPart.cannotrerun.title"), (String)TestUnitMessages.getString("TestRunnerViewPart.cannotrerurn.message"));
        }
    }

    public boolean lastLaunchIsKeptAlive() {
        return this.fTestRunnerClient != null && this.fTestRunnerClient.isRunning() && "debug".equals(this.fLaunchMode);
    }

    public void startTestRunListening(int n, IType iType, ILaunch iLaunch) {
        if (iType != null) {
            this.fTestProject = iType.getRubyProject();
        }
        this.fLaunchMode = iLaunch.getLaunchMode();
        this.aboutToLaunch();
        if (this.fTestRunnerClient != null) {
            this.stopTest();
        }
        this.fTestRunnerClient = new RemoteTestRunnerClient();
        ITestRunListener[] iTestRunListenerArray = new ITestRunListener[]{this};
        this.fTestRunnerClient.startListening(iTestRunListenerArray, n);
        this.fLastLaunch = iLaunch;
    }

    protected void aboutToLaunch() {
        String string = TestUnitMessages.getString("TestRunnerViewPart.message.launching");
        this.showInformation(string);
        this.setInfoMessage(string);
        this.firePropertyChange(1);
    }

    protected void showInformation(final String string) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (!TestUnitView.this.isDisposed()) {
                    TestUnitView.this.fFailureTrace.setInformation(string);
                }
            }
        });
    }

    protected void setInfoMessage(String string) {
        this.fStatus = string;
    }

    public void stopTest() {
        if (this.fTestRunnerClient != null) {
            this.fTestRunnerClient.stopTest();
        }
        this.stopUpdateJob();
    }

    private void stopUpdateJob() {
        if (this.fUpdateJob != null) {
            this.fUpdateJob.stop();
            this.fUpdateJob = null;
        }
    }

    public void setAutoScroll(boolean bl) {
        this.fAutoScroll = bl;
    }

    public boolean isAutoScroll() {
        return this.fAutoScroll;
    }

    public boolean isCreated() {
        return this.fCounterPanel != null;
    }

    public void reset() {
        this.reset(0);
        this.setViewPartTitle(null);
        this.clearStatus();
        this.resetViewIcon();
    }

    private void clearStatus() {
        this.getStatusLine().setMessage(null);
        this.getStatusLine().setErrorMessage(null);
    }

    private IStatusLineManager getStatusLine() {
        IEditorPart iEditorPart;
        IEditorActionBarContributor iEditorActionBarContributor;
        IViewSite iViewSite = this.getViewSite();
        IWorkbenchPage iWorkbenchPage = iViewSite.getPage();
        IWorkbenchPart iWorkbenchPart = iWorkbenchPage.getActivePart();
        if (iWorkbenchPart instanceof IViewPart) {
            IViewPart iViewPart = (IViewPart)iWorkbenchPart;
            IViewSite iViewSite2 = iViewPart.getViewSite();
            return iViewSite2.getActionBars().getStatusLineManager();
        }
        if (iWorkbenchPart instanceof IEditorPart && (iEditorActionBarContributor = (iEditorPart = (IEditorPart)iWorkbenchPart).getEditorSite().getActionBarContributor()) instanceof EditorActionBarContributor) {
            return ((EditorActionBarContributor)iEditorActionBarContributor).getActionBars().getStatusLineManager();
        }
        return this.getViewSite().getActionBars().getStatusLineManager();
    }

    private void resetViewIcon() {
        this.firePropertyChange(1);
    }

    private void setViewPartTitle(IRubyElement iRubyElement) {
        String string = iRubyElement == null ? " " : iRubyElement.toString();
        this.setContentDescription(string);
    }

    private void reset(final int n) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestUnitView.this.isDisposed()) {
                    return;
                }
                TestUnitView.this.fCounterPanel.reset();
                TestUnitView.this.fFailureTrace.clear();
                TestUnitView.this.fProgressBar.reset();
                TestUnitView.this.clearStatus();
                TestUnitView.this.start(n);
            }
        });
        this.fExecutedTests = 0;
        this.fFailureCount = 0;
        this.fErrorCount = 0;
        this.fTestCount = n;
        this.aboutToStart();
        this.fTestInfos.clear();
        this.fFailures = new ArrayList();
    }

    protected void start(int n) {
        this.resetProgressBar(n);
        this.fCounterPanel.setTotal(n);
        this.fCounterPanel.setRunValue(0);
    }

    private void resetProgressBar(int n) {
        this.fProgressBar.reset();
        this.fProgressBar.setMaximum(n);
    }

    private void aboutToStart() {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (!TestUnitView.this.isDisposed()) {
                    Enumeration enumeration = TestUnitView.this.fTestRunTabs.elements();
                    while (enumeration.hasMoreElements()) {
                        TestRunTab testRunTab = (TestRunTab)enumeration.nextElement();
                        testRunTab.aboutToStart();
                    }
                }
            }
        });
    }

    public void testEnded(String string, String string2) {
        this.postEndTest(string, string2);
        ++this.fExecutedTests;
    }

    public void testFailed(int n, String string, String string2, String string3) {
        this.testFailed(n, string, string2, string3, null, null);
    }

    public void testFailed(int n, String string, String string2, String string3, String string4, String string5) {
        TestRunInfo testRunInfo = this.getTestInfo(string);
        if (testRunInfo == null) {
            testRunInfo = new TestRunInfo(string, string2);
            this.fTestInfos.put(string2, testRunInfo);
        }
        testRunInfo.setTrace(string3);
        testRunInfo.setStatus(n);
        if (string4 != null) {
            testRunInfo.setExpected(string4.substring(0, string4.length() - 1));
        }
        if (string5 != null) {
            testRunInfo.setActual(string5.substring(0, string5.length() - 1));
        }
        if (n == 1) {
            ++this.fErrorCount;
        } else {
            ++this.fFailureCount;
        }
        this.fFailures.add(testRunInfo);
        if (this.fShowOnErrorOnly && this.fErrorCount + this.fFailureCount == 1) {
            this.postShowTestResultsView();
        }
    }

    protected void postShowTestResultsView() {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestUnitView.this.isDisposed()) {
                    return;
                }
                TestUnitView.this.showTestResultsView();
            }
        });
    }

    public void showTestResultsView() {
        IWorkbenchWindow iWorkbenchWindow = this.getSite().getWorkbenchWindow();
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        TestUnitView testUnitView = null;
        if (iWorkbenchPage != null) {
            try {
                testUnitView = (TestUnitView)iWorkbenchPage.findView(NAME);
                if (testUnitView == null) {
                    IWorkbenchPart iWorkbenchPart = iWorkbenchPage.getActivePart();
                    testUnitView = (TestUnitView)iWorkbenchPage.showView(NAME);
                    iWorkbenchPage.activate(iWorkbenchPart);
                } else {
                    iWorkbenchPage.bringToTop((IWorkbenchPart)testUnitView);
                }
            }
            catch (PartInitException partInitException) {
                TestunitPlugin.log(partInitException);
            }
        }
    }

    public void testReran(String string, String string2, String string3, int n, String string4) {
        Object object;
        if (n == 1) {
            object = TestUnitMessages.getFormattedString("TestRunnerViewPart.message.error", new String[]{string3, string2});
            this.postError((String)object);
        } else if (n == 2) {
            object = TestUnitMessages.getFormattedString("TestRunnerViewPart.message.failure", new String[]{string3, string2});
            this.postError((String)object);
        } else {
            object = TestUnitMessages.getFormattedString("TestRunnerViewPart.message.success", new String[]{string3, string2});
            this.setInfoMessage((String)object);
        }
        object = this.getTestInfo(string);
        this.updateTest((TestRunInfo)object, n);
        if (((TestRunInfo)object).getTrace() == null || !((TestRunInfo)object).getTrace().equals(string4)) {
            ((TestRunInfo)object).setTrace(string4);
            this.showFailure((TestRunInfo)object);
        }
    }

    protected void postError(String string) {
        this.fStatus = string;
    }

    private void updateTest(TestRunInfo testRunInfo, int n) {
        if (n == testRunInfo.getStatus()) {
            return;
        }
        if (testRunInfo.getStatus() == 0) {
            if (n == 2) {
                ++this.fFailureCount;
            } else if (n == 1) {
                ++this.fErrorCount;
            }
        } else if (testRunInfo.getStatus() == 1) {
            if (n == 0) {
                --this.fErrorCount;
            } else if (n == 2) {
                --this.fErrorCount;
                ++this.fFailureCount;
            }
        } else if (testRunInfo.getStatus() == 2) {
            if (n == 0) {
                --this.fFailureCount;
            } else if (n == 1) {
                --this.fFailureCount;
                ++this.fErrorCount;
            }
        }
        testRunInfo.setStatus(n);
        final TestRunInfo testRunInfo2 = testRunInfo;
        this.postSyncRunnable(new Runnable(){

            public void run() {
                Enumeration enumeration = TestUnitView.this.fTestRunTabs.elements();
                while (enumeration.hasMoreElements()) {
                    TestRunTab testRunTab = (TestRunTab)enumeration.nextElement();
                    testRunTab.testStatusChanged(testRunInfo2);
                }
            }
        });
    }

    public void testReran(String string, String string2, String string3, int n, String string4, String string5, String string6) {
        this.testReran(string, string2, string3, n, string4);
        TestRunInfo testRunInfo = this.getTestInfo(string);
        testRunInfo.setActual(string6);
        testRunInfo.setExpected(string5);
        this.fFailureTrace.updateEnablement(testRunInfo);
    }

    private void postEndTest(final String string, String string2) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestUnitView.this.isDisposed()) {
                    return;
                }
                TestUnitView.this.handleEndTest();
                Enumeration enumeration = TestUnitView.this.fTestRunTabs.elements();
                while (enumeration.hasMoreElements()) {
                    TestRunTab testRunTab = (TestRunTab)enumeration.nextElement();
                    testRunTab.endTest(string);
                }
                int cfr_ignored_0 = TestUnitView.this.fFailureCount;
                int cfr_ignored_1 = TestUnitView.this.fErrorCount;
            }
        });
    }

    private void handleEndTest() {
        this.fProgressBar.step(this.fFailureCount + this.fErrorCount);
        if (this.fShowOnErrorOnly) {
            this.firePropertyChange(1);
        }
    }

    public void testStarted(String string, String string2) {
        TestRunInfo testRunInfo;
        this.postStartTest(string, string2);
        if (!this.fShowOnErrorOnly && this.fExecutedTests == 1) {
            this.postShowTestResultsView();
        }
        if ((testRunInfo = this.getTestInfo(string)) == null) {
            testRunInfo = new TestRunInfo(string, string2);
            this.fTestInfos.put(string, testRunInfo);
        }
        String string3 = testRunInfo.getClassName();
        String string4 = testRunInfo.getTestMethodName();
        String string5 = TestUnitMessages.getFormattedString("TestRunnerViewPart.message.started", new String[]{string3, string4});
        this.setInfoMessage(string5);
    }

    private void postStartTest(final String string, String string2) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestUnitView.this.isDisposed()) {
                    return;
                }
                Enumeration enumeration = TestUnitView.this.fTestRunTabs.elements();
                while (enumeration.hasMoreElements()) {
                    TestRunTab testRunTab = (TestRunTab)enumeration.nextElement();
                    testRunTab.startTest(string);
                }
            }
        });
    }

    public void testRunStopped(long l) {
        String string = TestUnitMessages.getString("TestRunnerViewPart.message.stopped");
        this.setInfoMessage(string);
        this.handleStopped();
    }

    private void handleStopped() {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestUnitView.this.isDisposed()) {
                    return;
                }
                TestUnitView.this.resetViewIcon();
                TestUnitView.this.fProgressBar.stopped();
            }
        });
        this.stopUpdateJob();
    }

    public void testRunEnded(long l) {
        --this.fExecutedTests;
        Object[] objectArray = new String[]{this.elapsedTimeAsString(l)};
        String string = TestUnitMessages.getFormattedString("TestRunnerViewPart.message.finish", objectArray);
        if (this.hasErrorsOrFailures()) {
            this.postError(string);
        } else {
            this.setInfoMessage(string);
        }
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestUnitView.this.isDisposed()) {
                    return;
                }
                if (TestUnitView.this.fFailures.size() > 0) {
                    TestUnitView.this.selectFirstFailure();
                }
                Enumeration enumeration = TestUnitView.this.fTestRunTabs.elements();
                while (enumeration.hasMoreElements()) {
                    TestRunTab testRunTab = (TestRunTab)enumeration.nextElement();
                    testRunTab.aboutToEnd();
                }
            }
        });
        this.stopUpdateJob();
    }

    private String elapsedTimeAsString(long l) {
        return NumberFormat.getInstance().format((double)l / 1000.0);
    }

    private boolean hasErrorsOrFailures() {
        return this.fErrorCount + this.fFailureCount > 0;
    }

    protected void selectFirstFailure() {
        TestRunInfo testRunInfo = (TestRunInfo)this.fFailures.get(0);
        if (testRunInfo != null && this.fAutoScroll) {
            this.fActiveRunTab.setSelectedTest(testRunInfo.getTestId());
            this.handleTestSelected(testRunInfo.getTestId());
        }
    }

    public void testRunTerminated() {
        String string = TestUnitMessages.getString("TestRunnerViewPart.message.terminated");
        this.showMessage(string);
        this.handleStopped();
    }

    private void showMessage(String string) {
        this.postError(string);
    }

    public void testRunStarted(int n) {
        this.reset(n);
        ++this.fExecutedTests;
        this.stopUpdateJob();
        this.fUpdateJob = new UpdateUIJob(TestUnitMessages.getString("TestRunnerViewPart.jobName"));
        this.fUpdateJob.schedule(200L);
    }

    private void refreshCounters() {
        this.fCounterPanel.setErrorValue(this.fErrorCount);
        this.fCounterPanel.setFailureValue(this.fFailureCount);
        this.fCounterPanel.setRunValue(this.fExecutedTests);
        this.fProgressBar.refresh(this.fErrorCount + this.fFailureCount > 0);
    }

    protected void doShowStatus() {
        this.setContentDescription(this.fStatus);
    }

    public void testTreeEntry(final String string) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestUnitView.this.isDisposed()) {
                    return;
                }
                Enumeration enumeration = TestUnitView.this.fTestRunTabs.elements();
                while (enumeration.hasMoreElements()) {
                    TestRunTab testRunTab = (TestRunTab)enumeration.nextElement();
                    testRunTab.newTreeEntry(string);
                }
            }
        });
    }

    public void rerunTestRun() {
        if (this.lastLaunchIsKeptAlive() && MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)TestUnitMessages.getString("TestRunnerViewPart.terminate.title"), (String)TestUnitMessages.getString("TestRunnerViewPart.terminate.message")) && this.fTestRunnerClient != null) {
            this.fTestRunnerClient.stopTest();
        }
        if (this.fLastLaunch != null && this.fLastLaunch.getLaunchConfiguration() != null) {
            DebugUITools.launch((ILaunchConfiguration)this.fLastLaunch.getLaunchConfiguration(), (String)this.fLastLaunch.getLaunchMode());
        }
    }

    public IRubyProject getLaunchedProject() {
        return this.fTestProject;
    }

    public ILaunch getLastLaunch() {
        return this.fLastLaunch;
    }

    class UpdateUIJob
    extends UIJob {
        private boolean fRunning;

        public UpdateUIJob(String string) {
            super(string);
            this.fRunning = true;
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            if (!TestUnitView.this.isDisposed()) {
                TestUnitView.this.doShowStatus();
                TestUnitView.this.refreshCounters();
            }
            this.schedule(200L);
            return Status.OK_STATUS;
        }

        public void stop() {
            this.fRunning = false;
        }

        public boolean shouldSchedule() {
            return this.fRunning;
        }
    }

    private class RerunLastAction
    extends Action {
        public RerunLastAction() {
            this.setText(TestUnitMessages.getString("TestRunnerViewPart.rerunaction.label"));
            this.setToolTipText(TestUnitMessages.getString("TestRunnerViewPart.rerunaction.tooltip"));
            this.setDisabledImageDescriptor(TestunitPlugin.getImageDescriptor("dlcl16/relaunch.gif"));
            this.setHoverImageDescriptor(TestunitPlugin.getImageDescriptor("elcl16/relaunch.gif"));
            this.setImageDescriptor(TestunitPlugin.getImageDescriptor("elcl16/relaunch.gif"));
        }

        public void run() {
            TestUnitView.this.rerunTestRun();
        }
    }
}

