/*
 * Decompiled with CFR 0.152.
 */
package org.jayasoft.ivyde.eclipse.cpcontainer.fragmentinfo;

import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.jayasoft.ivyde.eclipse.cpcontainer.fragmentinfo.IPackageFragmentExtraInfo;

public class PreferenceStoreInfo
implements IPackageFragmentExtraInfo {
    private static final String SRC_SUFFIX = "-src";
    private static final String SRCROOT_SUFFIX = "-srcroot";
    private static final String DOC_SUFFIX = "-doc";
    private IPreferenceStore _preferenceStore;

    public PreferenceStoreInfo(IPreferenceStore preferenceStore) {
        this._preferenceStore = preferenceStore;
    }

    public IPath getSourceAttachment(Path path) {
        String srcPath = this._preferenceStore.getString(String.valueOf(path.toPortableString()) + SRC_SUFFIX);
        if (!"".equals(srcPath)) {
            return new Path(srcPath);
        }
        return null;
    }

    public IPath getSourceAttachmentRoot(Path path) {
        String srcPath = this._preferenceStore.getString(String.valueOf(path.toPortableString()) + SRCROOT_SUFFIX);
        if (!"".equals(srcPath)) {
            return new Path(srcPath);
        }
        return null;
    }

    public IPath getDocAttachment(Path path) {
        String srcPath = this._preferenceStore.getString(String.valueOf(path.toPortableString()) + DOC_SUFFIX);
        if (!"".equals(srcPath)) {
            return Path.fromPortableString((String)srcPath);
        }
        return null;
    }

    public void setSourceAttachmentPath(IPath containerPath, String entryPath, IPath sourcePath) {
        this._preferenceStore.setValue(String.valueOf(entryPath) + SRC_SUFFIX, sourcePath == null ? "" : sourcePath.toPortableString());
    }

    public void setSourceAttachmentRootPath(IPath containerPath, String entryPath, IPath rootPath) {
        this._preferenceStore.setValue(String.valueOf(entryPath) + SRCROOT_SUFFIX, rootPath == null ? "" : rootPath.toPortableString());
    }

    public void setJavaDocLocation(IPath containerPath, String entryPath, URL libraryJavadocLocation) {
        this._preferenceStore.setValue(String.valueOf(entryPath) + DOC_SUFFIX, libraryJavadocLocation == null ? "" : libraryJavadocLocation.toString());
    }
}

