/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.builder;

import de.tobject.findbugs.builder.AbstractFilesCollector;
import de.tobject.findbugs.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDeltaFilesCollector
extends AbstractFilesCollector {
    private IResourceDelta resourceDelta;

    public ResourceDeltaFilesCollector(IResourceDelta resourceDelta) {
        this.resourceDelta = resourceDelta;
    }

    @Override
    public Collection getFiles() {
        return this.collectFiles(this.resourceDelta);
    }

    private Collection<IResource> collectFiles(IResourceDelta delta) {
        ArrayList<IResource> files = new ArrayList<IResource>(0);
        ArrayList<IResourceDelta> folders = new ArrayList<IResourceDelta>(0);
        IResourceDelta[] affectedChildren = delta.getAffectedChildren();
        for (int i = 0; i < affectedChildren.length; ++i) {
            IResourceDelta childDelta = affectedChildren[i];
            IResource child = childDelta.getResource();
            int childType = child.getType();
            if (childType == 1) {
                int deltaKind;
                if (DEBUG) {
                    System.out.println(new StringBuffer().append("Delta file: ").append(child.getFullPath().toOSString()).toString());
                }
                if ((deltaKind = childDelta.getKind()) != 1 && deltaKind != 4 || !Util.isJavaArtifact(child)) continue;
                files.add(child);
                continue;
            }
            if (childType != 2) continue;
            folders.add(childDelta);
        }
        for (IResourceDelta resourceDelta2 : folders) {
            files.addAll(this.collectFiles(resourceDelta2));
        }
        return files;
    }
}

