/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.filter.NameMatch;

public class ClassMatcher
implements Matcher {
    private static final boolean DEBUG = SystemProperties.getBoolean("filter.debug");
    private NameMatch className;

    public String toString() {
        return "class=\"" + this.className.getValue() + "\"";
    }

    public ClassMatcher(String className) {
        this.className = new NameMatch(className);
    }

    public boolean match(BugInstance bugInstance) {
        ClassAnnotation primaryClassAnnotation = bugInstance.getPrimaryClass();
        String bugClassName = primaryClassAnnotation.getClassName();
        if (DEBUG) {
            System.out.println("Matching " + bugClassName + " with " + this.className);
        }
        return this.className.match(bugClassName);
    }
}

