/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.db.DatabaseEntry;

public class LongBinding
extends TupleBinding {
    private static final int LONG_SIZE = 8;

    public Object entryToObject(TupleInput tupleInput) {
        return new Long(tupleInput.readLong());
    }

    public void objectToEntry(Object object, TupleOutput tupleOutput) {
        tupleOutput.writeLong(((Number)object).longValue());
    }

    protected TupleOutput getTupleOutput(Object object) {
        return LongBinding.sizedOutput();
    }

    public static long entryToLong(DatabaseEntry databaseEntry) {
        return LongBinding.entryToInput(databaseEntry).readLong();
    }

    public static void longToEntry(long l, DatabaseEntry databaseEntry) {
        LongBinding.outputToEntry(LongBinding.sizedOutput().writeLong(l), databaseEntry);
    }

    private static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[8]);
    }
}

