import logging
from zope.interface import implementedBy
from AccessControl import ClassSecurityInfo
from Globals import InitializeClass
from Products.LDAPMultiPlugins.ActiveDirectoryMultiPlugin\
        import ActiveDirectoryMultiPlugin
from Products.PluggableAuthService.interfaces.plugins import \
     IUserEnumerationPlugin, IGroupsPlugin, IGroupEnumerationPlugin, \
     IRoleEnumerationPlugin
from Products.PluggableAuthService.utils import classImplements
from Products.PloneLDAP.plugins.base import PloneLDAPPluginBaseMixin
from Products.PloneLDAP.mixins import UserPropertiesMixin

from Products.PloneLDAP.mixins import GroupIntrospectionMixin

logger = logging.getLogger("PloneLDAP")

class PloneActiveDirectoryMultiPlugin(PloneLDAPPluginBaseMixin,
        UserPropertiesMixin, GroupIntrospectionMixin,
        ActiveDirectoryMultiPlugin):
    """Plone Active Directory plugin.
    """
    security = ClassSecurityInfo()
    meta_type = "Plone Active Directory plugin"


    security.declarePrivate('enumerateGroups')
    def enumerateGroups( self
                       , id=None
                       , exact_match=False
                       , sort_by=None
                       , max_results=None
                       , **kw
                       ):
        """Group enumeration.

        This method adds a workaround to enforce LDAPUserFolder to return a
        list of all groups. This is desirable for LDAP environments where only
        a few groups are present. In Plone we know this in advance thanks to
        the 'many groups' setting.
        """
        if not id and not kw:
            kw["cn"]=""
        return ActiveDirectoryMultiPlugin.enumerateGroups(self, id,
                exact_match, sort_by, max_results, **kw)


classImplements(PloneActiveDirectoryMultiPlugin
               , IUserEnumerationPlugin
               , IGroupsPlugin
               , IGroupEnumerationPlugin
               , IRoleEnumerationPlugin
               , *implementedBy(ActiveDirectoryMultiPlugin)
               )
 
InitializeClass(PloneActiveDirectoryMultiPlugin)

