;;; leim-list.el -- list of LEIM (Library of Emacs Input Method)
;;
;; This file contains a list of LEIM (Library of Emacs Input Method)
;; methods in the same directory as this file.  Loading this file
;; registers all the input methods in Emacs.
;;
;; Each entry has the form:
;;   (register-input-method
;;    INPUT-METHOD LANGUAGE-NAME ACTIVATE-FUNC
;;    TITLE DESCRIPTION
;;    ARG ...)
;; See the function `register-input-method' for the meanings of the arguments.
;;
;; If this directory is included in load-path, Emacs automatically
;; loads this file at startup time.

(register-input-method
 "chinese-ctlaub" "Chinese-BIG5" 'quail-use-package
 "��" "������������"
 "quail/CTLau-b5")
(register-input-method
 "chinese-ctlau" "Chinese-CNS" 'quail-use-package
 "��" "������������"
 "quail/CTLau")
(register-input-method
 "chinese-b5-quick" "Chinese-BIG5" 'quail-use-package
 "�B" "��������BIG5"
 "quail/quick-b5")
(register-input-method
 "chinese-b5-tsangchi" "Chinese-BIG5" 'quail-use-package
 "�B" "��������BIG5"
 "quail/tsang-b5")
(register-input-method
 "chinese-cns-quick" "Chinese-CNS" 'quail-use-package
 "�C" "��������CNS"
 "quail/quick-cns")
(register-input-method
 "chinese-cns-tsangchi" "Chinese-CNS" 'quail-use-package
 "�C" "��������CNS"
 "quail/tsang-cns")
(register-input-method
 "chinese-py" "Chinese-CNS" 'quail-use-package
 "�G" "��������"
 "quail/PY")
(register-input-method
 "chinese-ziranma" "Chinese-CNS" 'quail-use-package
 "��" "����������"
 "quail/ZIRANMA")
(register-input-method
 "chinese-zozy" "Chinese-BIG5" 'quail-use-package
 "��" "����������"
 "quail/ZOZY")
(register-input-method
 "chinese-tonepy" "Chinese-GB" 'quail-use-package
 "��" "����������"
 "quail/TONEPY")
(register-input-method
 "chinese-sw" "Chinese-GB" 'quail-use-package
 "��" "��������"
 "quail/SW")
(register-input-method
 "chinese-qj" "Chinese-GB" 'quail-use-package
 "�G" "��������"
 "quail/QJ")
(register-input-method
 "chinese-qj-b5" "Chinese-BIG5" 'quail-use-package
 "�B" "��������"
 "quail/QJ-b5")
(register-input-method
 "chinese-punct" "Chinese-GB" 'quail-use-package
 "�G" "����������"
 "quail/Punct")
(register-input-method
 "chinese-punct-b5" "Chinese-BIG5" 'quail-use-package
 "�B" "����������"
 "quail/Punct-b5")
(register-input-method
 "chinese-py-b5" "Chinese-BIG5" 'quail-use-package
 "�B" "��������"
 "quail/PY-b5")
(register-input-method
 "chinese-etzy" "Chinese-BIG5" 'quail-use-package
 "��" "����������"
 "quail/ETZY")
(register-input-method
 "chinese-ecdict" "Chinese-BIG5" 'quail-use-package
 "��" "����������"
 "quail/ECDICT")
(register-input-method
 "chinese-ccdospy" "Chinese-GB" 'quail-use-package
 "��" "����������"
 "quail/CCDOSPY")
(register-input-method
 "chinese-array30" "Chinese-BIG5" 'quail-use-package
 "��" "��������"
 "quail/ARRAY30")
(register-input-method
 "chinese-4corner" "Chinese-BIG5" 'quail-use-package
 "��" "����::"
 "quail/4Corner")
(register-input-method
 "vietnamese-viqr" "Vietnamese" 'quail-use-package
 "VQ" "Vietnamese input method with VIQR mnemonic system"
 "quail/viqr")
(register-input-method
 "tibetan-wylie" "Tibetan" 'quail-use-package
 "TIBw" "Tibetan character input by Extended Wylie key assignment."
 "quail/tibetan")
(register-input-method
 "tibetan-tibkey" "Tibetan" 'quail-use-package
 "TIBt" "Tibetan character input by TibKey key assignment."
 "quail/tibetan")
(register-input-method
 "thai-kesmanee" "Thai" 'quail-use-package
 "กก>" "Thai Kesmanee input method with TIS620 keyboard layout"
 "quail/thai")
(register-input-method
 "thai-pattachote" "Thai" 'quail-use-package
 "กป>" "Thai Pattachote input method with TIS620 keyboard layout"
 "quail/thai")
(register-input-method
 "korean-symbol" "Korean" 'quail-use-package
 "��" "�������:"
 "quail/symbol-ksc")
(register-input-method
 "slovak" "Slovak" 'quail-use-package
 "SK" "Standard Slovak keyboard."
 "quail/slovak")
(register-input-method
 "slovak-prog-1" "Slovak" 'quail-use-package
 "SK" "Slovak (non-standard) keyboard for programmers #1."
 "quail/slovak")
(register-input-method
 "slovak-prog-2" "Slovak" 'quail-use-package
 "SK" "Slovak (non-standard) keyboard for programmers #2."
 "quail/slovak")
(register-input-method
 "slovak-prog-3" "Slovak" 'quail-use-package
 "SK" "Slovak (non-standard) keyboard for programmers #3."
 "quail/slovak")
(register-input-method
 "chinese-py-punct-b5" "Chinese-BIG5" 'quail-use-package
 "��" "�������� and `v' for ������"
 "quail/pypunct-b5")
(register-input-method
 "chinese-py-punct" "Chinese-GB" 'quail-use-package
 "��" "���� ���� and `v' for ������"
 "quail/py-punct")
(register-input-method
 "chinese-tonepy-punct" "Chinese-GB" 'quail-use-package
 "��" "���� ������ and `v' for ������"
 "quail/py-punct")
(register-input-method
 "lao-lrt" "Lao" 'quail-use-package
 "ລR" "Lao input method using LRT (Lao Roman Transcription)."
 "quail/lrt")
(register-input-method
 "latin-1-prefix" "Latin-1" 'quail-use-package
 "1>" "Latin-1 characters input method with prefix modifiers"
 "quail/latin-pre")
(register-input-method
 "catalan-prefix" "Latin-1" 'quail-use-package
 "CA>" "Catalan and Spanish input method with prefix modifiers"
 "quail/latin-pre")
(register-input-method
 "esperanto-prefix" "Latin-3" 'quail-use-package
 "EO>" "Esperanto input method with prefix modifiers"
 "quail/latin-pre")
(register-input-method
 "french-prefix" "Latin-1" 'quail-use-package
 "FR>" "French (Français) input method with prefix modifiers"
 "quail/latin-pre")
(register-input-method
 "romanian-prefix" "Romanian" 'quail-use-package
 "RO>" "Romanian (româneşte) input method with prefix modifiers"
 "quail/latin-pre")
(register-input-method
 "romanian-alt-prefix" "Romanian" 'quail-use-package
 "RO>" "Alternative Romanian (româneşte) input method with prefix modifiers"
 "quail/latin-pre")
(register-input-method
 "german-prefix" "Latin-1" 'quail-use-package
 "DE>" "German (Deutsch) input method with prefix modifiers"
 "quail/latin-pre")
(register-input-method
 "irish-prefix" "Latin-1" 'quail-use-package
 "GA>" "Irish input method with prefix modifiers"
 "quail/latin-pre")
(register-input-method
 "portuguese-prefix" "Latin-1" 'quail-use-package
 "PT>" "Portuguese input method with prefix modifiers"
 "quail/latin-pre")
(register-input-method
 "spanish-prefix" "Latin-1" 'quail-use-package
 "ES>" "Spanish (Español) input method with prefix modifiers"
 "quail/latin-pre")
(register-input-method
 "latin-2-prefix" "Latin-2" 'quail-use-package
 "2>" "Latin-2 characters input method with prefix modifiers"
 "quail/latin-pre")
(register-input-method
 "latin-3-prefix" "Latin-3" 'quail-use-package
 "3>" "Latin-3 characters input method with prefix modifiers"
 "quail/latin-pre")
(register-input-method
 "polish-slash" "Polish" 'quail-use-package
 "PL>" "Polish diacritics in Latin-2 encoding are input as `/[acelnosxzACELNOSXZ]'."
 "quail/latin-pre")
(register-input-method
 "latin-9-prefix" "Latin-9" 'quail-use-package
 "0>" "Latin-9 characters input method with prefix modifiers"
 "quail/latin-pre")
(register-input-method
 "latin-8-prefix" "Latin-8" 'quail-use-package
 "8>" "Latin-8 characters input method with prefix modifiers"
 "quail/latin-pre")
(register-input-method
 "latin-1-postfix" "Latin-1" 'quail-use-package
 "1<" "Latin-1 character input method with postfix modifiers"
 "quail/latin-post")
(register-input-method
 "latin-2-postfix" "Latin-2" 'quail-use-package
 "2<" "Latin-2 character input method with postfix modifiers"
 "quail/latin-post")
(register-input-method
 "latin-3-postfix" "Latin-3" 'quail-use-package
 "3<" "Latin-3 character input method with postfix modifiers"
 "quail/latin-post")
(register-input-method
 "latin-4-postfix" "Latin-4" 'quail-use-package
 "4<" "Latin-4 characters input method with postfix modifiers"
 "quail/latin-post")
(register-input-method
 "latin-5-postfix" "Latin-5" 'quail-use-package
 "5<" "Latin-5 characters input method with postfix modifiers"
 "quail/latin-post")
(register-input-method
 "danish-postfix" "Latin-1" 'quail-use-package
 "DA<" "Danish input method (rule: AE -> Æ, OE -> Ø, AA -> Å, E' -> É)"
 "quail/latin-post")
(register-input-method
 "esperanto-postfix" "Latin-3" 'quail-use-package
 "EO<" "Esperanto input method with postfix modifiers"
 "quail/latin-post")
(register-input-method
 "finnish-postfix" "Latin-1" 'quail-use-package
 "FI<" "Finnish (Suomi) input method"
 "quail/latin-post")
(register-input-method
 "french-postfix" "Latin-1" 'quail-use-package
 "FR<" "French (Français) input method with postfix modifiers"
 "quail/latin-post")
(register-input-method
 "german-postfix" "Latin-1" 'quail-use-package
 "DE<" "German (Deutsch) input method"
 "quail/latin-post")
(register-input-method
 "icelandic-postfix" "Latin-1" 'quail-use-package
 "IS<" "Icelandic (Íslenska) input method with postfix modifiers"
 "quail/latin-post")
(register-input-method
 "italian-postfix" "Latin-1" 'quail-use-package
 "IT<" "Italian (Italiano) input method with postfix modifiers"
 "quail/latin-post")
(register-input-method
 "norwegian-postfix" "Latin-1" 'quail-use-package
 "NO<" "Norwegian (Norsk) input method (rule: AE->Æ   OE->Ø   AA->Å   E'->É)"
 "quail/latin-post")
(register-input-method
 "scandinavian-postfix" "Latin-1" 'quail-use-package
 "SC<" "Scandinavian input method with postfix modifiers"
 "quail/latin-post")
(register-input-method
 "spanish-postfix" "Latin-1" 'quail-use-package
 "ES<" "Spanish (Español) input method with postfix modifiers"
 "quail/latin-post")
(register-input-method
 "swedish-postfix" "Latin-1" 'quail-use-package
 "SV<" "Swedish (Svenska) input method (rule: AA -> Å   AE -> Ä   OE -> Ö   E' -> É)"
 "quail/latin-post")
(register-input-method
 "turkish-latin-3-postfix" "Latin-3" 'quail-use-package
 "TR3<" "Turkish (Türkçe) input method with postfix modifiers."
 "quail/latin-post")
(register-input-method
 "turkish-postfix" "Latin-5" 'quail-use-package
 "TR<" "Turkish (Türkçe) input method with postfix modifiers."
 "quail/latin-post")
(register-input-method
 "british" "Latin-1" 'quail-use-package
 "£@" "British English input method with Latin-1 character £ (# -> £)"
 "quail/latin-post")
(register-input-method
 "french-keyboard" "Latin-1" 'quail-use-package
 "FR@" "French (Français) input method simulating some French keyboard"
 "quail/latin-post")
(register-input-method
 "french-azerty" "Latin-1" 'quail-use-package
 "AZ@" "French (Français) input method simulating Azerty keyboard"
 "quail/latin-post")
(register-input-method
 "icelandic-keyboard" "Latin-1" 'quail-use-package
 "IS@" "Icelandic (Íslenska) input method simulating some Icelandic keyboard"
 "quail/latin-post")
(register-input-method
 "danish-keyboard" "Latin-1" 'quail-use-package
 "DA@" "Danish input method simulating SUN Danish keyboard"
 "quail/latin-post")
(register-input-method
 "norwegian-keyboard" "Latin-1" 'quail-use-package
 "NO@" "Norwegian (Norsk) input method simulating SUN Norwegian keyboard"
 "quail/latin-post")
(register-input-method
 "swedish-keyboard" "Latin-1" 'quail-use-package
 "SV@" "Swedish (Svenska) input method simulating SUN Swedish/Finnish keyboard"
 "quail/latin-post")
(register-input-method
 "finnish-keyboard" "Latin-1" 'quail-use-package
 "FI@" "Finnish input method simulating SUN Finnish/Swedish keyboard"
 "quail/latin-post")
(register-input-method
 "german" "Latin-1" 'quail-use-package
 "DE@" "German (Deutsch) input method simulating SUN German keyboard"
 "quail/latin-post")
(register-input-method
 "italian-keyboard" "Latin-1" 'quail-use-package
 "IT@" "Italian (Italiano) input method simulating SUN Italian keyboard"
 "quail/latin-post")
(register-input-method
 "spanish-keyboard" "Latin-1" 'quail-use-package
 "ES@" "Spanish (Español) input method simulating SUN Spanish keyboard"
 "quail/latin-post")
(register-input-method
 "english-dvorak" "English" 'quail-use-package
 "DV@" "English (ASCII) input method simulating Dvorak keyboard"
 "quail/latin-post")
(register-input-method
 "TeX" "UTF-8" 'quail-use-package
 "\\" "LaTeX-like input method for many characters."
 "quail/latin-ltx")
(register-input-method
 "latin-1-alt-postfix" "Latin-1" 'quail-use-package
 "1<" "Latin-1 character input method with postfix modifiers"
 "quail/latin-alt")
(register-input-method
 "latin-2-alt-postfix" "Latin-2" 'quail-use-package
 "2<" "Latin-2 character input method with postfix modifiers"
 "quail/latin-alt")
(register-input-method
 "latin-3-alt-postfix" "Latin-3" 'quail-use-package
 "3<" "Latin-3 character input method with postfix modifiers"
 "quail/latin-alt")
(register-input-method
 "latin-4-alt-postfix" "Latin-4" 'quail-use-package
 "4<" "Latin-4 characters input method with postfix modifiers"
 "quail/latin-alt")
(register-input-method
 "latin-5-alt-postfix" "Latin-5" 'quail-use-package
 "5<" "Latin-5 characters input method with postfix modifiers"
 "quail/latin-alt")
(register-input-method
 "danish-alt-postfix" "Latin-1" 'quail-use-package
 "DA<" "Danish input method (rule: AE -> Æ, OE -> Ø, AA -> Å, E' -> É)"
 "quail/latin-alt")
(register-input-method
 "esperanto-alt-postfix" "Latin-3" 'quail-use-package
 "EO<" "Esperanto input method with postfix modifiers"
 "quail/latin-alt")
(register-input-method
 "finnish-alt-postfix" "Latin-1" 'quail-use-package
 "FI<" "Finnish (Suomi) input method"
 "quail/latin-alt")
(register-input-method
 "french-alt-postfix" "Latin-1" 'quail-use-package
 "FR<" "French (Français) input method with postfix modifiers"
 "quail/latin-alt")
(register-input-method
 "german-alt-postfix" "Latin-1" 'quail-use-package
 "DE<" "German (Deutsch) input method"
 "quail/latin-alt")
(register-input-method
 "icelandic-alt-postfix" "Latin-1" 'quail-use-package
 "IS<" "Icelandic (Íslenska) input method with postfix modifiers"
 "quail/latin-alt")
(register-input-method
 "italian-alt-postfix" "Latin-1" 'quail-use-package
 "IT<" "Italian (Italiano) input method with postfix modifiers"
 "quail/latin-alt")
(register-input-method
 "norwegian-alt-postfix" "Latin-1" 'quail-use-package
 "NO<" "Norwegian (Norsk) input method (rule: AE->Æ, OE->Ø, AA->Å, E'->É)"
 "quail/latin-alt")
(register-input-method
 "scandinavian-alt-postfix" "Latin-1" 'quail-use-package
 "SC<" "Scandinavian input method with postfix modifiers"
 "quail/latin-alt")
(register-input-method
 "spanish-alt-postfix" "Latin-1" 'quail-use-package
 "ES<" "Spanish (Español) input method with postfix modifiers"
 "quail/latin-alt")
(register-input-method
 "swedish-alt-postfix" "Latin-1" 'quail-use-package
 "SV<" "Swedish (Svenska) input method (rule: AA -> Å, AE -> Ä, OE -> Ö, E' -> É)"
 "quail/latin-alt")
(register-input-method
 "turkish-latin-3-alt-postfix" "Latin-3" 'quail-use-package
 "TR3<<" "Turkish (Türkçe) input method with postfix modifiers."
 "quail/latin-alt")
(register-input-method
 "turkish-alt-postfix" "Latin-5" 'quail-use-package
 "TR«" "Turkish (Türkçe) input method with postfix modifiers."
 "quail/latin-alt")
(register-input-method
 "lao" "Lao" 'quail-use-package
 "ລ" "Lao input method simulating Lao keyboard layout based on Thai TIS620"
 "quail/lao")
(register-input-method
 "japanese" "Japanese" 'quail-use-package
 "A�" "Japanese input method by Roman transliteration and Kana-Kanji conversion."
 "quail/japanese")
(register-input-method
 "japanese-ascii" "Japanese" 'quail-use-package
 "Aa" "Temporary ASCII input mode used within the input method `japanese'."
 "quail/japanese")
(register-input-method
 "japanese-zenkaku" "Japanese" 'quail-use-package
 "�" "Japanese zenkaku alpha numeric character input method."
 "quail/japanese")
(register-input-method
 "japanese-hankaku-kana" "Japanese" 'quail-use-package
 "ｱ" "Japanese hankaku katakana input method by Roman transliteration."
 "quail/japanese")
(register-input-method
 "japanese-hiragana" "Japanese" 'quail-use-package
 "�" "Japanese hiragana input method by Roman transliteration."
 "quail/japanese")
(register-input-method
 "japanese-katakana" "Japanese" 'quail-use-package
 "�" "Japanese katakana input method by Roman transliteration."
 "quail/japanese")
(register-input-method
 "ipa" "IPA" 'quail-use-package
 "IPA" "International Phonetic Alphabet for English, French, German and Italian"
 "quail/ipa")
(register-input-method
 "hebrew" "Hebrew" 'quail-use-package
 "ע" "Hebrew (ISO 8859-8) input method."
 "quail/hebrew")
(register-input-method
 "korean-hanja3" "Korean" 'quail-use-package
 "�3" "3��KSC��: ���� ��� �� ��3���� ���� ��"
 "quail/hanja3")
(register-input-method
 "korean-hanja" "Korean" 'quail-use-package
 "�2" "2��KSC��: ���� ��� �� ��2���� ���� ��"
 "quail/hanja")
(register-input-method
 "korean-hanja-jis" "Korean" 'quail-use-package
 "�2" "2��JIS��: ���� ��� �� ��2���� ���� ��"
 "quail/hanja-jis")
(register-input-method
 "korean-hangul3" "Korean" 'quail-use-package
 "�3" "�� 3��: Hangul input method"
 "quail/hangul3")
(register-input-method
 "korean-hangul" "Korean" 'quail-use-package
 "�2" "�� 2��: Hangul input method with Hangul keyboard layout (KSC5601)"
 "quail/hangul")
(register-input-method
 "greek-jis" "Greek" 'quail-use-package
 "�" "��������: Greek keyboard layout (JIS X0208.1983)"
 "quail/greek")
(register-input-method
 "greek-mizuochi" "Greek" 'quail-use-package
 "CG" ""
 "quail/greek")
(register-input-method
 "greek-babel" "Greek" 'quail-use-package
 "BG" "The TeX Babel input method for Classical Greek using mule-unicode-0100-24ff."
 "quail/greek")
(register-input-method
 "greek-ibycus4" "Greek" 'quail-use-package
 "IB" "The Ibycus4 input method for Classical Greek using mule-unicode-0100-24ff."
 "quail/greek")
(register-input-method
 "greek" "Greek" 'quail-use-package
 "Ω" "Ελληνικά: Greek keyboard layout (ISO 8859-7)"
 "quail/greek")
(register-input-method
 "ethiopic" "Ethiopic" 'quail-use-package
 (quote ("ፊደል " (ethio-prefer-ascii-space "_" "፡") (ethio-prefer-ascii-punctuation "." "።"))) "  Quail package for Ethiopic (Tigrigna and Amharic)"
 "quail/ethiopic")
(register-input-method
 "devanagari-keyboard-a" "Devanagari" 'quail-use-package
 "DevK" "Devanagari input method with ISCII format"
 "quail/devanagari")
(register-input-method
 "devanagari-transliteration" "Devanagari" 'quail-use-package
 "DEVt" "Devanagari input method by transliteration"
 "quail/devanagari")
(register-input-method
 "devanagari-itrans" "Devanagari" 'quail-use-package
 "DEVi" "Devanagari input method by ITRANS"
 "quail/devanagari")
(register-input-method
 "devanagari-hindi-transliteration" "Hindi" 'quail-use-package
 "HINt" "Devanagari-Hindi input method by transliteration"
 "quail/devanagari")
(register-input-method
 "czech" "Czech" 'quail-use-package
 "CZ" "\"Standard\" Czech keyboard in the Windoze NT 105 keys version."
 "quail/czech")
(register-input-method
 "czech-qwerty" "Czech" 'quail-use-package
 "CZ" "\"Standard\" Czech keyboard in the Windoze NT 105 keys version, QWERTY layout."
 "quail/czech")
(register-input-method
 "czech-prog-1" "Czech" 'quail-use-package
 "CZ" "Czech (non-standard) keyboard for programmers #1."
 "quail/czech")
(register-input-method
 "czech-prog-2" "Czech" 'quail-use-package
 "CZ" "Czech (non-standard) keyboard for programmers #2."
 "quail/czech")
(register-input-method
 "czech-prog-3" "Czech" 'quail-use-package
 "CZ" "Czech (non-standard) keyboard for programmers compatible with the default"
 "quail/czech")
(register-input-method
 "cyrillic-jcuken" "Cyrillic" 'quail-use-package
 "ЖЙ" "ЙЦУКЕН keyboard layout widely used in Russia (ISO 8859-5 encoding)"
 "quail/cyrillic")
(register-input-method
 "cyrillic-macedonian" "Cyrillic" 'quail-use-package
 "ЖM" "ЉЊЕРТЗ-ЃЌ keyboard layout based on JUS.I.K1.004 (ISO 8859-5 encoding)"
 "quail/cyrillic")
(register-input-method
 "cyrillic-serbian" "Cyrillic" 'quail-use-package
 "ЖS" "ЉЊЕРТЗ-ЂЋ keyboard layout based on JUS.I.K1.005 (ISO 8859-5 encoding)"
 "quail/cyrillic")
(register-input-method
 "cyrillic-beylorussian" "Cyrillic" 'quail-use-package
 "ЖB" "ЉЊЕРТЗ-ІЎ BEYLORUSSIAN (ISO 8859-5 encoding)"
 "quail/cyrillic")
(register-input-method
 "cyrillic-ukrainian" "Cyrillic" 'quail-use-package
 "ЖU" "ЄЇЕРТЗ-ІЎ UKRAINIAN (ISO 8859-5 encoding)"
 "quail/cyrillic")
(register-input-method
 "cyrillic-yawerty" "Cyrillic" 'quail-use-package
 "ЖЯ" "ЯВЕРТЫ Roman transcription (ISO 8859-5 encoding)"
 "quail/cyrillic")
(register-input-method
 "cyrillic-translit" "Cyrillic" 'quail-use-package
 "Жt" "Intuitively transliterated keyboard layout."
 "quail/cyrillic")
(register-input-method
 "cyrillic-translit-bulgarian" "Cyrillic" 'quail-use-package
 "Жtb" "Intuitively transliterated keyboard layout optimized for Bulgarian."
 "quail/cyrillic")
(register-input-method
 "cyrillic-jis-russian" "Cyrillic" 'quail-use-package
 "��" "������ keyboard layout same as JCUKEN (JIS X0208.1983 encoding)"
 "quail/cyril-jis")
