require '_h2ph_pre.ph';

no warnings qw(redefine misc);

require 'sys/selinfo.ph';
require 'sys/queue.ph';
if(1) {
}
unless(defined(&SB_MAX)) {
    sub SB_MAX () {	(256*1024);}
}
unless(defined(&SB_LOCK)) {
    sub SB_LOCK () {	0x1;}
}
unless(defined(&SB_WANT)) {
    sub SB_WANT () {	0x2;}
}
unless(defined(&SB_WAIT)) {
    sub SB_WAIT () {	0x4;}
}
unless(defined(&SB_SEL)) {
    sub SB_SEL () {	0x8;}
}
unless(defined(&SB_ASYNC)) {
    sub SB_ASYNC () {	0x10;}
}
unless(defined(&SB_NOINTR)) {
    sub SB_NOINTR () {	0x40;}
}
unless(defined(&SB_KNOTE)) {
    sub SB_KNOTE () {	0x80;}
}
unless(defined(&SB_SPLICE)) {
    sub SB_SPLICE () {	0x100;}
}
unless(defined(&SB_EMPTY_FIXUP)) {
    sub SB_EMPTY_FIXUP {
	my($sb) = @_;
	eval q( &do {  &if (($sb)-> &sb_mb ==  &NULL) { ($sb)-> &sb_mbtail =  &NULL; ($sb)-> &sb_lastrecord =  &NULL; } }  &while ( 0));
    }
}
unless(defined(&SS_NOFDREF)) {
    sub SS_NOFDREF () {	0x1;}
}
unless(defined(&SS_ISCONNECTED)) {
    sub SS_ISCONNECTED () {	0x2;}
}
unless(defined(&SS_ISCONNECTING)) {
    sub SS_ISCONNECTING () {	0x4;}
}
unless(defined(&SS_ISDISCONNECTING)) {
    sub SS_ISDISCONNECTING () {	0x8;}
}
unless(defined(&SS_CANTSENDMORE)) {
    sub SS_CANTSENDMORE () {	0x10;}
}
unless(defined(&SS_CANTRCVMORE)) {
    sub SS_CANTRCVMORE () {	0x20;}
}
unless(defined(&SS_RCVATMARK)) {
    sub SS_RCVATMARK () {	0x40;}
}
unless(defined(&SS_ISDISCONNECTED)) {
    sub SS_ISDISCONNECTED () {	0x800;}
}
unless(defined(&SS_PRIV)) {
    sub SS_PRIV () {	0x80;}
}
unless(defined(&SS_NBIO)) {
    sub SS_NBIO () {	0x100;}
}
unless(defined(&SS_ASYNC)) {
    sub SS_ASYNC () {	0x200;}
}
unless(defined(&SS_ISCONFIRMING)) {
    sub SS_ISCONFIRMING () {	0x400;}
}
unless(defined(&SS_CONNECTOUT)) {
    sub SS_CONNECTOUT () {	0x1000;}
}
unless(defined(&SS_ISSENDING)) {
    sub SS_ISSENDING () {	0x2000;}
}
unless(defined(&sb_notify)) {
    sub sb_notify {
	my($sb) = @_;
	eval q(((($sb)-> &sb_flags & ( &SB_WAIT| &SB_SEL| &SB_ASYNC|  &SB_KNOTE| &SB_SPLICE)) != 0));
    }
}
unless(defined(&sbspace)) {
    sub sbspace {
	my($sb) = @_;
	eval q( &lmin(($sb)-> &sb_hiwat - ($sb)-> &sb_cc, ($sb)-> &sb_mbmax - ($sb)-> &sb_mbcnt));
    }
}
unless(defined(&sosendallatonce)) {
    sub sosendallatonce {
	my($so) = @_;
	eval q((($so)-> ($so_proto->{pr_flags}) &  &PR_ATOMIC));
    }
}
unless(defined(&soissending)) {
    sub soissending {
	my($so) = @_;
	eval q((($so)-> &so_state &  &SS_ISSENDING));
    }
}
unless(defined(&_soreadable)) {
    sub _soreadable {
	my($so) = @_;
	eval q((($so)-> ($so_rcv->{sb_cc}) >= ($so)-> ($so_rcv->{sb_lowat}) || (($so)-> &so_state &  &SS_CANTRCVMORE) || ($so)-> &so_qlen || ($so)-> &so_error));
    }
}
unless(defined(&sowriteable)) {
    sub sowriteable {
	my($so) = @_;
	eval q((( &sbspace(($so)-> &so_snd) >= ($so)-> ($so_snd->{sb_lowat})  && ((($so)-> &so_state &  &SS_ISCONNECTED) || (($so)-> ($so_proto->{pr_flags}) &  &PR_CONNREQUIRED)==0)) || (($so)-> &so_state &  &SS_CANTSENDMORE) || ($so)-> &so_error));
    }
}
unless(defined(&sballoc)) {
    sub sballoc {
	my($sb, $m) = @_;
	eval q( &do { ($sb)-> &sb_cc += ($m)-> &m_len;  &if (($m)-> &m_type !=  &MT_CONTROL  && ($m)-> &m_type !=  &MT_SONAME) ($sb)-> &sb_datacc += ($m)-> &m_len; ($sb)-> &sb_mbcnt +=  &MSIZE;  &if (($m)-> &m_flags &  &M_EXT) ($sb)-> &sb_mbcnt += ($m)-> ($m_ext->{ext_size}); }  &while ( 0));
    }
}
unless(defined(&sbfree)) {
    sub sbfree {
	my($sb, $m) = @_;
	eval q( &do { ($sb)-> &sb_cc -= ($m)-> &m_len;  &if (($m)-> &m_type !=  &MT_CONTROL  && ($m)-> &m_type !=  &MT_SONAME) ($sb)-> &sb_datacc -= ($m)-> &m_len; ($sb)-> &sb_mbcnt -=  &MSIZE;  &if (($m)-> &m_flags &  &M_EXT) ($sb)-> &sb_mbcnt -= ($m)-> ($m_ext->{ext_size}); }  &while ( 0));
    }
}
unless(defined(&sblock)) {
    sub sblock {
	my($sb, $wf) = @_;
	eval q((($sb)-> &sb_flags &  &SB_LOCK ? ((($wf) ==  &M_WAITOK) ?  &sb_lock($sb) :  &EWOULDBLOCK) : (($sb)-> &sb_flags |=  &SB_LOCK, 0)));
    }
}
unless(defined(&sbunlock)) {
    sub sbunlock {
	my($sb) = @_;
	eval q( &do { ($sb)-> &sb_flags &= ~ &SB_LOCK;  &if (($sb)-> &sb_flags &  &SB_WANT) { ($sb)-> &sb_flags &= ~ &SB_WANT;  &wakeup(($sb)-> &sb_flags); } }  &while ( 0));
    }
}
unless(defined(&_sorwakeup)) {
    sub _sorwakeup {
	my($so) = @_;
	eval q( &do {  &sowakeup(($so), ($so)-> &so_rcv);  &if (($so)-> &so_upcall) (*(($so)-> &so_upcall))(($so), ($so)-> &so_upcallarg,  &M_DONTWAIT); }  &while ( 0));
    }
}
unless(defined(&_sowwakeup)) {
    sub _sowwakeup {
	my($so) = @_;
	eval q( &sowakeup(($so), ($so)-> &so_snd));
    }
}
if(defined(&SOCKET_SPLICE)) {
    eval 'sub soreadable {
        my($so) = @_;
	    eval q((($so)-> &so_splice ==  &NULL  &&  &_soreadable($so)));
    }' unless defined(&soreadable);
} else {
    eval 'sub soreadable {
        my($so) = @_;
	    eval q( &_soreadable($so));
    }' unless defined(&soreadable);
    eval 'sub sorwakeup {
        my($so) = @_;
	    eval q( &_sorwakeup($so));
    }' unless defined(&sorwakeup);
    eval 'sub sowwakeup {
        my($so) = @_;
	    eval q( &_sowwakeup($so));
    }' unless defined(&sowwakeup);
}
if(defined(&_KERNEL)) {
    if(defined(&SOCKBUF_DEBUG)) {
	eval 'sub SBLASTRECORDCHK {
	    my($sb, $where) = @_;
    	    eval q( &sblastrecordchk(($sb), ($where)));
	}' unless defined(&SBLASTRECORDCHK);
	eval 'sub SBLASTMBUFCHK {
	    my($sb, $where) = @_;
    	    eval q( &sblastmbufchk(($sb), ($where)));
	}' unless defined(&SBLASTMBUFCHK);
    } else {
	eval 'sub SBLASTRECORDCHK {
	    my($sb, $where) = @_;
    	    eval q();
	}' unless defined(&SBLASTRECORDCHK);
	eval 'sub SBLASTMBUFCHK {
	    my($sb, $where) = @_;
    	    eval q();
	}' unless defined(&SBLASTMBUFCHK);
    }
}
1;
