# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Olivier Tilloy <olivier@fluendo.com>

"""
The final screen of the configuration wizard.
"""

from elisa.core.utils import defer
from elisa.core.utils.i18n import install_translation

from elisa.plugins.poblesec.configuration.list import ListScreen, ChoiceModel


_ = install_translation('poblesec')


class FinalScreen(ListScreen):

    """
    The final screen of the configuration wizard.
    """

    actions = ['done', 'prev']

    def setup(self):
        self.title = _('Start Using Moovida!')
        self.summary = _('Your setup is now complete. Remember you can change '
                         'the settings you entered at any time via the '
                         'Preferences menu.')

        start_option = ChoiceModel()
        start_option.label = _('Start Moovida')
        start_option.action = 'done'
        self.set_model([start_option])

        return defer.succeed(self)

    def save(self):
        # We don't actually want to save anything.
        pass
