/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.validation;

import gnu.xml.validation.relaxng.RELAXNGSchemaFactory;
import gnu.xml.validation.xmlschema.XMLSchemaSchemaFactory;
import java.io.File;
import java.net.URL;
import javax.xml.XMLConstants;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public abstract class SchemaFactory {
    protected SchemaFactory() {
    }

    public static final SchemaFactory newInstance(String string) {
        if (XMLConstants.W3C_XML_SCHEMA_NS_URI.equals(string)) {
            return new XMLSchemaSchemaFactory();
        }
        if (XMLConstants.RELAXNG_NS_URI.equals(string)) {
            return new RELAXNGSchemaFactory();
        }
        throw new IllegalArgumentException(string);
    }

    public abstract boolean isSchemaLanguageSupported(String var1);

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string);
    }

    public abstract ErrorHandler getErrorHandler();

    public abstract void setErrorHandler(ErrorHandler var1);

    public abstract LSResourceResolver getResourceResolver();

    public abstract void setResourceResolver(LSResourceResolver var1);

    public Schema newSchema(Source source) throws SAXException {
        return this.newSchema(new Source[]{source});
    }

    public Schema newSchema(File file) throws SAXException {
        return this.newSchema(new StreamSource(file));
    }

    public Schema newSchema(URL uRL) throws SAXException {
        return this.newSchema(new StreamSource(uRL.toString()));
    }

    public abstract Schema newSchema(Source[] var1) throws SAXException;

    public abstract Schema newSchema() throws SAXException;
}

