/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class TableView
extends BoxView {
    int[] columnOffsets;
    int[] columnSpans;
    SizeRequirements[] columnRequirements;

    private /* synthetic */ void finit$() {
        this.columnRequirements = new SizeRequirements[0];
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public TableView(Element element) {
        super(element, 1);
        this.finit$();
    }

    public void replace(int n, int n2, View[] viewArray) {
        super.replace(n, n2, viewArray);
        this.layoutChanged(1);
    }

    protected TableRow createTableRow(Element element) {
        return new TableRow(this, element);
    }

    protected TableCell createTableCell(Element element) {
        return new TableCell(this, element);
    }

    protected void forwardUpdate(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
    }

    protected void layoutColumns(int n, int[] nArray, int[] nArray2, SizeRequirements[] sizeRequirementsArray) {
        this.updateColumnRequirements();
        SizeRequirements sizeRequirements = this.calculateMinorAxisRequirements(0, null);
        SizeRequirements.calculateTiledPositions(n, sizeRequirements, this.columnRequirements, nArray, nArray2);
    }

    protected void layoutMinorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        this.layoutColumns(n, this.columnOffsets, this.columnSpans, this.columnRequirements);
        super.layoutMinorAxis(n, n2, nArray, nArray2);
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        SizeRequirements sizeRequirements2 = sizeRequirements;
        if (sizeRequirements2 == null) {
            sizeRequirements2 = new SizeRequirements();
        } else {
            sizeRequirements2.alignment = 0.5f;
            sizeRequirements2.maximum = 0;
            sizeRequirements2.minimum = 0;
            sizeRequirements2.preferred = 0;
        }
        for (int i = 0; i < this.columnRequirements.length; ++i) {
            sizeRequirements2.minimum += this.columnRequirements[i].minimum;
            sizeRequirements2.preferred += this.columnRequirements[i].preferred;
            sizeRequirements2.maximum += this.columnRequirements[i].maximum;
        }
        return sizeRequirements2;
    }

    protected View getViewAtPosition(int n, Rectangle rectangle) {
        return super.getViewAtPosition(n, rectangle);
    }

    private void updateColumnRequirements() {
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            TableRow tableRow = (TableRow)this.getView(i);
            int n2 = tableRow.getViewCount();
            for (int j = 0; j < n2; ++j) {
                View view = tableRow.getView(j);
                SizeRequirements sizeRequirements = this.columnRequirements[j];
                sizeRequirements.minimum = Math.max(sizeRequirements.minimum, (int)view.getMinimumSpan(0));
                sizeRequirements.preferred = Math.max(sizeRequirements.preferred, (int)view.getPreferredSpan(0));
                sizeRequirements.maximum = Math.max(sizeRequirements.maximum, (int)view.getMaximumSpan(0));
            }
        }
    }

    public class TableCell
    extends BoxView {
        private /* synthetic */ TableView this$0;
        private int row;
        private int column;

        public TableCell(TableView tableView, Element element) {
            this.this$0 = tableView;
            super(element, 0);
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return 1;
        }

        public void setGridLocation(int n, int n2) {
            this.row = n;
            this.column = n2;
        }

        public int getGridRow() {
            return this.row;
        }

        public int getGridColumn() {
            return this.column;
        }
    }

    public class TableRow
    extends BoxView {
        private /* synthetic */ TableView this$0;
        private static final /* synthetic */ boolean $assertionsDisabled;

        public TableRow(TableView tableView, Element element) {
            this.this$0 = tableView;
            super(element, 0);
        }

        public void replace(int n, int n2, View[] viewArray) {
            super.replace(n, n2, viewArray);
            int n3 = this.getViewCount();
            if (this.this$0.columnRequirements == null || n3 > this.this$0.columnRequirements.length) {
                this.this$0.columnRequirements = new SizeRequirements[n3];
                for (int i = 0; i < this.this$0.columnRequirements.length; ++i) {
                    this.this$0.columnRequirements[i] = new SizeRequirements();
                }
            }
            if (this.this$0.columnOffsets == null || this.this$0.columnOffsets.length < n3) {
                this.this$0.columnOffsets = new int[n3];
            }
            if (this.this$0.columnSpans == null || this.this$0.columnSpans.length < n3) {
                this.this$0.columnSpans = new int[n3];
            }
            this.layoutChanged(0);
        }

        protected void layoutMajorAxis(int n, int n2, int[] nArray, int[] nArray2) {
            if (!$assertionsDisabled && nArray.length != this.this$0.columnOffsets.length) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && nArray2.length != this.this$0.columnSpans.length) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && nArray.length != nArray2.length) {
                throw new AssertionError();
            }
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = this.this$0.columnOffsets[i];
                nArray2[i] = this.this$0.columnSpans[i];
            }
        }

        protected void layoutMinorAxis(int n, int n2, int[] nArray, int[] nArray2) {
            super.layoutMinorAxis(n, n2, nArray, nArray2);
        }

        public int getResizeWeight(int n) {
            return 0;
        }

        protected View getViewAtPosition(int n, Rectangle rectangle) {
            return super.getViewAtPosition(n, rectangle);
        }

        static {
            $assertionsDisabled = TableView.class$("javax.swing.text.TableView$TableRow").desiredAssertionStatus() ^ true;
        }
    }
}

