/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import gnu.java.lang.reflect.MethodSignatureParser;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public final class Method
extends AccessibleObject
implements Member,
GenericDeclaration {
    private static final int METHOD_MODIFIERS = 3391;
    private Class declaringClass;
    private Class[] exception_types;
    private String name;
    private Class[] parameter_types;
    private Class return_type;
    private int offset;

    private Method() {
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public native String getName();

    private native int getModifiersInternal();

    public int getModifiers() {
        return this.getModifiersInternal() & 0xD3F;
    }

    public boolean isBridge() {
        return (this.getModifiersInternal() & 0x40) != 0;
    }

    public boolean isSynthetic() {
        return (this.getModifiersInternal() & 0x1000) != 0;
    }

    public boolean isVarArgs() {
        return (this.getModifiersInternal() & 0x80) != 0;
    }

    public Class getReturnType() {
        if (this.return_type == null) {
            this.getType();
        }
        return this.return_type;
    }

    public Class[] getParameterTypes() {
        if (this.parameter_types == null) {
            this.getType();
        }
        return (Class[])this.parameter_types.clone();
    }

    public Class[] getExceptionTypes() {
        if (this.exception_types == null) {
            this.getType();
        }
        return (Class[])this.exception_types.clone();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Method)) {
            return false;
        }
        Method method = (Method)object;
        return this.declaringClass == method.declaringClass && this.offset == method.offset;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        int n;
        if (this.parameter_types == null) {
            this.getType();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.getModifiers();
        if (n2 != 0) {
            Modifier.toString(n2, stringBuffer);
            stringBuffer.append(" ");
        }
        Method.appendClassName(stringBuffer, this.return_type);
        stringBuffer.append(" ");
        Method.appendClassName(stringBuffer, this.declaringClass);
        stringBuffer.append(".");
        stringBuffer.append(this.getName());
        stringBuffer.append("(");
        for (n = 0; n < this.parameter_types.length; ++n) {
            Method.appendClassName(stringBuffer, this.parameter_types[n]);
            if (n >= this.parameter_types.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        if (this.exception_types.length > 0) {
            stringBuffer.append(" throws ");
            for (n = 0; n < this.exception_types.length; ++n) {
                Method.appendClassName(stringBuffer, this.exception_types[n]);
                if (n >= this.exception_types.length - 1) continue;
                stringBuffer.append(",");
            }
        }
        return stringBuffer.toString();
    }

    public String toGenericString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder(128);
        Modifier.toString(this.getModifiers(), stringBuilder).append(' ');
        Constructor.addTypeParameters(stringBuilder, this.getTypeParameters());
        stringBuilder.append(this.getGenericReturnType()).append(' ');
        stringBuilder.append(this.getDeclaringClass().getName()).append('.');
        stringBuilder.append(this.getName()).append('(');
        Type[] typeArray = this.getGenericParameterTypes();
        if (typeArray.length > 0) {
            stringBuilder.append(typeArray[0]);
            for (n = 1; n < typeArray.length; ++n) {
                stringBuilder.append(',').append(typeArray[n]);
            }
        }
        stringBuilder.append(')');
        typeArray = this.getGenericExceptionTypes();
        if (typeArray.length > 0) {
            stringBuilder.append(" throws ").append(typeArray[0]);
            for (n = 1; n < typeArray.length; ++n) {
                stringBuilder.append(',').append(typeArray[n]);
            }
        }
        return stringBuilder.toString();
    }

    public native Object invoke(Object var1, Object[] var2) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

    public TypeVariable[] getTypeParameters() {
        String string = this.getSignature();
        if (string == null) {
            return new TypeVariable[0];
        }
        MethodSignatureParser methodSignatureParser = new MethodSignatureParser(this, string);
        return methodSignatureParser.getTypeParameters();
    }

    private String getSignature() {
        return null;
    }

    public Type[] getGenericExceptionTypes() {
        String string = this.getSignature();
        if (string == null) {
            return this.getExceptionTypes();
        }
        MethodSignatureParser methodSignatureParser = new MethodSignatureParser(this, string);
        return methodSignatureParser.getGenericExceptionTypes();
    }

    public Type[] getGenericParameterTypes() {
        String string = this.getSignature();
        if (string == null) {
            return this.getParameterTypes();
        }
        MethodSignatureParser methodSignatureParser = new MethodSignatureParser(this, string);
        return methodSignatureParser.getGenericParameterTypes();
    }

    public Type getGenericReturnType() {
        String string = this.getSignature();
        if (string == null) {
            return this.getReturnType();
        }
        MethodSignatureParser methodSignatureParser = new MethodSignatureParser(this, string);
        return methodSignatureParser.getGenericReturnType();
    }

    private native void getType();

    static void appendClassName(StringBuffer stringBuffer, Class clazz) {
        if (clazz.isArray()) {
            Method.appendClassName(stringBuffer, clazz.getComponentType());
            stringBuffer.append("[]");
        } else {
            stringBuffer.append(clazz.getName());
        }
    }
}

