/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import gnu.java.lang.management.MemoryMXBeanImpl;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.SimpleType;

public class MemoryNotificationInfo {
    public static final String MEMORY_THRESHOLD_EXCEEDED = "java.management.memory.threshold.exceeded";
    public static final String MEMORY_COLLECTION_THRESHOLD_EXCEEDED = "java.management.memory.collection.threshold.exceeded";
    private String poolName;
    private MemoryUsage usage;
    private long count;

    public MemoryNotificationInfo(String string, MemoryUsage memoryUsage, long l) {
        this.poolName = string;
        this.usage = memoryUsage;
        this.count = l;
    }

    public static MemoryNotificationInfo from(CompositeData compositeData) {
        if (compositeData == null) {
            return null;
        }
        CompositeType compositeType = compositeData.getCompositeType();
        ThreadInfo.checkAttribute(compositeType, "poolName", SimpleType.STRING);
        ThreadInfo.checkAttribute(compositeType, "usage", MemoryMXBeanImpl.usageType);
        ThreadInfo.checkAttribute(compositeType, "count", SimpleType.LONG);
        MemoryUsage memoryUsage = MemoryUsage.from((CompositeData)compositeData.get("usage"));
        return new MemoryNotificationInfo((String)compositeData.get("poolName"), memoryUsage, (Long)compositeData.get("count"));
    }

    public long getCount() {
        return this.count;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public MemoryUsage getUsage() {
        return this.usage;
    }
}

