/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image.renderable;

import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.util.ArrayList;
import java.util.Iterator;

public class RenderableImageProducer
implements ImageProducer,
Runnable {
    private RenderableImage image;
    private RenderContext context;
    private ArrayList consumers;

    private /* synthetic */ void finit$() {
        this.consumers = new ArrayList();
    }

    public RenderableImageProducer(RenderableImage renderableImage, RenderContext renderContext) {
        this.finit$();
        this.image = renderableImage;
        this.context = renderContext;
    }

    public void setRenderContext(RenderContext renderContext) {
        this.context = renderContext;
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        ArrayList arrayList = this.consumers;
        synchronized (arrayList) {
            block3: {
                try {
                    if (this.consumers.contains(imageConsumer)) break block3;
                    this.consumers.add(imageConsumer);
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
            Object var3_3 = null;
        }
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        ArrayList arrayList = this.consumers;
        synchronized (arrayList) {
            try {
                boolean bl = this.consumers.contains(imageConsumer);
                Object var4_4 = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                throw throwable;
            }
        }
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        ArrayList arrayList = this.consumers;
        synchronized (arrayList) {
            try {
                this.consumers.remove(imageConsumer);
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
        Thread thread = new Thread(this, "RenderableImageProducerWorker");
        thread.start();
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    public void run() {
        ArrayList arrayList = this.consumers;
        synchronized (arrayList) {
            try {
                Object object;
                RenderedImage renderedImage = this.context == null ? this.image.createDefaultRendering() : this.image.createRendering(this.context);
                Raster raster = renderedImage.getData();
                ColorModel colorModel = renderedImage.getColorModel();
                if (colorModel == null) {
                    colorModel = ColorModel.getRGBdefault();
                }
                SampleModel sampleModel = raster.getSampleModel();
                DataBuffer dataBuffer = raster.getDataBuffer();
                int n = raster.getWidth();
                int n2 = raster.getHeight();
                Iterator iterator = this.consumers.iterator();
                while (iterator.hasNext()) {
                    object = (ImageConsumer)iterator.next();
                    object.setHints(30);
                    object.setDimensions(n, n2);
                }
                object = new int[n];
                int[] nArray = new int[sampleModel.getNumBands()];
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n; ++j) {
                        sampleModel.getPixel(j, i, nArray, dataBuffer);
                        object[j] = colorModel.getDataElement(nArray, 0);
                    }
                    iterator = this.consumers.iterator();
                    while (iterator.hasNext()) {
                        ImageConsumer imageConsumer = (ImageConsumer)iterator.next();
                        imageConsumer.setPixels(0, i, n, 1, colorModel, (int[])object, 0, n);
                    }
                }
                iterator = this.consumers.iterator();
                while (iterator.hasNext()) {
                    ImageConsumer imageConsumer = (ImageConsumer)iterator.next();
                    imageConsumer.imageComplete(3);
                }
                renderedImage = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                throw throwable;
            }
        }
    }
}

