/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.activation;

import gnu.java.rmi.activation.BidiTable;
import gnu.java.rmi.activation.DefaultActivationSystem;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationInstantiator;
import java.rmi.activation.ActivationMonitor;
import java.rmi.activation.ActivationSystem;
import java.rmi.activation.Activator;
import java.rmi.activation.UnknownGroupException;
import java.rmi.activation.UnknownObjectException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class ActivationSystemTransient
extends DefaultActivationSystem
implements ActivationSystem,
ActivationMonitor,
Activator {
    protected final BidiTable groupDescs;
    protected final BidiTable descriptions;
    protected final transient Map groupInstantiators;
    protected final transient Map activatedObjects;
    static long groupIncarnations = 0L;
    static ActivationSystem singleton;
    public static boolean debug;

    private /* synthetic */ void finit$() {
        this.groupInstantiators = new Hashtable();
        this.activatedObjects = new HashMap();
    }

    protected ActivationSystemTransient(BidiTable bidiTable, BidiTable bidiTable2) {
        this.finit$();
        this.descriptions = bidiTable;
        this.groupDescs = bidiTable2;
    }

    protected ActivationSystemTransient() {
        this(new BidiTable(), new BidiTable());
    }

    public static ActivationSystem getInstance() {
        if (singleton == null) {
            singleton = new ActivationSystemTransient();
        }
        return singleton;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public MarshalledObject activate(ActivationID activationID, boolean bl) throws ActivationException, UnknownObjectException, RemoteException {
        MarshalledObject marshalledObject;
        ActivationDesc activationDesc;
        if (!bl) {
            Map map = this.activatedObjects;
            // MONITORENTER : map
            try {
                MarshalledObject marshalledObject2 = (MarshalledObject)this.activatedObjects.get(activationID);
                if (marshalledObject2 != null) {
                    MarshalledObject marshalledObject3 = marshalledObject2;
                    Object var6_7 = null;
                    // MONITOREXIT : map
                    return marshalledObject3;
                }
                activationDesc = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                // MONITOREXIT : map
                throw throwable;
            }
        }
        if ((activationDesc = (ActivationDesc)this.descriptions.get(activationID)) == null) {
            String string;
            if ("Activating unknown object  " + activationID == null) {
                string = "null";
                throw new UnknownObjectException(string);
            }
            string = activationID.toString();
            throw new UnknownObjectException(string);
        }
        ActivationInstantiator activationInstantiator = (ActivationInstantiator)this.groupInstantiators.get(activationDesc.getGroupID());
        if (activationInstantiator == null) {
            ActivationGroupID activationGroupID = activationDesc.getGroupID();
            ActivationGroupDesc activationGroupDesc = (ActivationGroupDesc)this.groupDescs.get(activationGroupID);
            if (activationGroupDesc == null) {
                throw new UnknownGroupException("Activating unknown group " + activationGroupID + " for " + activationID + " this " + this);
            }
            Class clazz = ActivationSystemTransient.class$("gnu.java.rmi.activation.ActivationSystemTransient");
            // MONITORENTER : clazz
            try {
                // empty try
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                // MONITOREXIT : clazz
                throw throwable;
            }
            marshalledObject = null;
            // MONITOREXIT : clazz
            activationInstantiator = ActivationGroup.createGroup(activationGroupID, activationGroupDesc, ++groupIncarnations);
            this.activeGroup(activationGroupID, activationInstantiator, groupIncarnations);
        }
        marshalledObject = activationInstantiator.newInstance(activationID, activationDesc);
        Map map = this.activatedObjects;
        // MONITORENTER : map
        try {
            this.activatedObjects.put(activationID, marshalledObject);
        }
        catch (Throwable throwable) {
            Object var13_20 = null;
            // MONITOREXIT : map
            throw throwable;
        }
        Object var13_19 = null;
        // MONITOREXIT : map
        return marshalledObject;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ActivationMonitor activeGroup(ActivationGroupID activationGroupID, ActivationInstantiator activationInstantiator, long l) throws UnknownGroupException, ActivationException, RemoteException {
        this.groupInstantiators.put(activationGroupID, activationInstantiator);
        return this;
    }

    public ActivationDesc getActivationDesc(ActivationID activationID) throws ActivationException, UnknownObjectException, RemoteException {
        ActivationDesc activationDesc = (ActivationDesc)this.descriptions.get(activationID);
        if (activationDesc == null) {
            throw new UnknownObjectException("No desc for " + activationID == null ? "null" : activationID.toString());
        }
        return activationDesc;
    }

    public ActivationGroupDesc getActivationGroupDesc(ActivationGroupID activationGroupID) throws ActivationException, UnknownGroupException, RemoteException {
        ActivationGroupDesc activationGroupDesc = (ActivationGroupDesc)this.groupDescs.get(activationGroupID);
        if (activationGroupDesc == null) {
            throw new UnknownGroupException(activationGroupID == null ? "null" : activationGroupID.toString());
        }
        return activationGroupDesc;
    }

    public ActivationGroupID registerGroup(ActivationGroupDesc activationGroupDesc) throws ActivationException, RemoteException {
        ActivationGroupID activationGroupID = (ActivationGroupID)this.groupDescs.getKey(activationGroupDesc);
        if (activationGroupID == null) {
            activationGroupID = new ActivationGroupID(this);
            this.groupDescs.put(activationGroupID, activationGroupDesc);
        }
        if (debug) {
            System.out.println("Register group " + activationGroupID + ":" + activationGroupDesc + " this " + this);
        }
        return activationGroupID;
    }

    public ActivationID registerObject(ActivationDesc activationDesc) throws ActivationException, UnknownGroupException, RemoteException {
        ActivationID activationID = (ActivationID)this.descriptions.getKey(activationDesc);
        if (activationID == null) {
            activationID = new ActivationID(this);
            this.descriptions.put(activationID, activationDesc);
        }
        if (debug) {
            System.out.println("Register object " + activationID + ":" + activationDesc + " this " + this);
        }
        return activationID;
    }

    public ActivationDesc setActivationDesc(ActivationID activationID, ActivationDesc activationDesc) throws ActivationException, UnknownObjectException, UnknownGroupException, RemoteException {
        ActivationDesc activationDesc2 = this.getActivationDesc(activationID);
        this.descriptions.put(activationID, activationDesc);
        return activationDesc2;
    }

    public ActivationGroupDesc setActivationGroupDesc(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc) throws ActivationException, UnknownGroupException, RemoteException {
        ActivationGroupDesc activationGroupDesc2 = this.getActivationGroupDesc(activationGroupID);
        this.groupDescs.put(activationGroupID, activationGroupDesc);
        return activationGroupDesc2;
    }

    public void shutdown() throws RemoteException {
        this.descriptions.shutdown();
        this.groupDescs.shutdown();
    }

    public void unregisterGroup(ActivationGroupID activationGroupID) throws ActivationException, UnknownGroupException, RemoteException {
        if (!this.groupDescs.containsKey(activationGroupID)) {
            throw new UnknownGroupException("Unknown group " + activationGroupID);
        }
        this.groupDescs.removeKey(activationGroupID);
        this.groupInstantiators.remove(activationGroupID);
    }

    public void unregisterObject(ActivationID activationID) throws ActivationException, UnknownObjectException, RemoteException {
        if (!this.descriptions.containsKey(activationID)) {
            throw new UnknownObjectException("Unregistering unknown object");
        }
        this.descriptions.removeKey(activationID);
        Map map = this.activatedObjects;
        synchronized (map) {
            try {
                this.activatedObjects.remove(activationID);
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }

    public void activeObject(ActivationID activationID, MarshalledObject marshalledObject) throws UnknownObjectException, RemoteException {
        if (!this.descriptions.containsKey(activationID)) {
            throw new UnknownObjectException("Activating unknown object " + activationID + " this " + this);
        }
        try {
            Map map = this.activatedObjects;
            synchronized (map) {
                try {
                    this.activatedObjects.put(activationID, marshalledObject.get());
                }
                finally {
                    Object var4_4 = null;
                }
            }
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            UnknownObjectException unknownObjectException = new UnknownObjectException("Cannot get Remote for MarshalledObject of " + activationID);
            unknownObjectException.detail = exception;
            throw unknownObjectException;
        }
        {
            return;
        }
    }

    public void inactiveGroup(ActivationGroupID activationGroupID, long l) throws UnknownGroupException, RemoteException {
        if (!this.groupInstantiators.containsKey(activationGroupID)) {
            throw new UnknownGroupException("Inactivating unkwnon group");
        }
        this.groupInstantiators.remove(activationGroupID);
        Map map = this.activatedObjects;
        synchronized (map) {
            try {
                Iterator iterator = this.activatedObjects.keySet().iterator();
                while (iterator.hasNext()) {
                    ActivationID activationID = (ActivationID)iterator.next();
                    ActivationDesc activationDesc = (ActivationDesc)this.descriptions.get(activationID);
                    if (!activationDesc.getGroupID().equals(activationGroupID)) continue;
                    this.activatedObjects.remove(activationID);
                }
                iterator = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public void inactiveObject(ActivationID activationID) throws UnknownObjectException, RemoteException {
        if (!this.descriptions.containsKey(activationID)) {
            throw new UnknownObjectException("Inactivating unknown object");
        }
        Map map = this.activatedObjects;
        synchronized (map) {
            try {
                this.activatedObjects.remove(activationID);
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }

    static {
        debug = false;
    }
}

