/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp;

import gnu.classpath.jdwp.Jdwp;
import gnu.classpath.jdwp.VMFrame;
import gnu.classpath.jdwp.VMMethod;
import gnu.classpath.jdwp.event.EventRequest;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.util.MethodResult;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class VMVirtualMachine {
    private static Hashtable _jdwp_suspend_counts;

    public static native void initialize();

    public static native void suspendThread(Thread var0) throws JdwpException;

    public static void suspendAllThreads() throws JdwpException {
        ThreadGroup threadGroup;
        Thread thread = Thread.currentThread();
        ThreadGroup threadGroup2 = threadGroup = Jdwp.getDefault().getJdwpThreadGroup();
        ThreadGroup threadGroup3 = threadGroup2.getParent();
        while (threadGroup3 != null) {
            threadGroup2 = threadGroup3;
            threadGroup3 = threadGroup2.getParent();
        }
        int n = threadGroup2.activeCount();
        Thread[] threadArray = new Thread[n];
        threadGroup2.enumerate(threadArray);
        for (int i = 0; i < n; ++i) {
            Thread thread2 = threadArray[i];
            if (thread2 == null || thread2.getThreadGroup() == threadGroup || thread2 == thread) continue;
            VMVirtualMachine.suspendThread(thread2);
        }
        if (thread.getThreadGroup() != threadGroup) {
            VMVirtualMachine.suspendThread(thread);
        }
    }

    public static native void resumeThread(Thread var0) throws JdwpException;

    public static void resumeAllThreads() throws JdwpException {
        ThreadGroup threadGroup;
        Thread thread = Thread.currentThread();
        ThreadGroup threadGroup2 = threadGroup = thread.getThreadGroup();
        ThreadGroup threadGroup3 = threadGroup2.getParent();
        while (threadGroup3 != null) {
            threadGroup2 = threadGroup3;
            threadGroup3 = threadGroup2.getParent();
        }
        int n = threadGroup2.activeCount();
        Thread[] threadArray = new Thread[n];
        threadGroup2.enumerate(threadArray);
        for (int i = 0; i < n; ++i) {
            Thread thread2 = threadArray[i];
            if (thread2 == null || thread2.getThreadGroup() == threadGroup || thread2 == thread) continue;
            VMVirtualMachine.resumeThread(thread2);
        }
    }

    public static native int getSuspendCount(Thread var0) throws JdwpException;

    public static native int getAllLoadedClassesCount() throws JdwpException;

    public static native Iterator getAllLoadedClasses() throws JdwpException;

    public static native int getClassStatus(Class var0) throws JdwpException;

    public static native VMMethod[] getAllClassMethods(Class var0) throws JdwpException;

    public static native VMMethod getClassMethod(Class var0, long var1) throws JdwpException;

    public static native ArrayList getFrames(Thread var0, int var1, int var2) throws JdwpException;

    public static native VMFrame getFrame(Thread var0, ByteBuffer var1) throws JdwpException;

    public static native int getFrameCount(Thread var0) throws JdwpException;

    public static native int getThreadStatus(Thread var0) throws JdwpException;

    public static native ArrayList getLoadRequests(ClassLoader var0) throws JdwpException;

    public static native MethodResult executeMethod(Object var0, Thread var1, Class var2, Method var3, Object[] var4, boolean var5) throws JdwpException;

    public static native String getSourceFile(Class var0) throws JdwpException;

    public static native void registerEvent(EventRequest var0) throws JdwpException;

    public static native void unregisterEvent(EventRequest var0) throws JdwpException;

    public static native void clearEvents(byte var0) throws JdwpException;
}

