/*
 *  Copyright (C) 2005  Andreas Volz
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 *  File: VertexGroup.h
 *  Andreas Volz <linux@brachttal.net>
 *   
 */

#ifndef VERTEXGROUP_H
#define VERTEXGROUP_H 1

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#include <map>
#include <string>
#include <iostream>
#include <fstream>
#include "FileReader.h"

namespace Animorph {

typedef std::map <int, float> VGroupData;

/*!
The format of VertexGroup file:
\verbatim
<string>:
<int>,<float>
<int>,<float>
...
{<newline>
<vgroup>}
\endverbatim
*/
class VertexGroup : public std::map <std::string, VGroupData>
{
private:
  void fromStream (std::ifstream &in_stream);

public:
  bool load (const std::string& filename);
};

}

#endif	// VERTEXGROUP_H
