/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.spec;

import com.sun.jdi.ReferenceType;
import java.util.StringTokenizer;
import jde.debugger.JDEException;
import jde.debugger.spec.ReferenceTypeSpec;

public class PatternReferenceTypeSpec
implements ReferenceTypeSpec {
    final String classPattern;
    final boolean isWild;

    public PatternReferenceTypeSpec(String classPattern) {
        this.isWild = classPattern.startsWith("*.");
        this.classPattern = this.isWild ? classPattern.substring(1) : classPattern;
    }

    public String getClassPattern() {
        return this.classPattern;
    }

    public boolean matches(ReferenceType refType) {
        if (this.isWild) {
            return refType.name().endsWith(this.classPattern);
        }
        return refType.name().equals(this.classPattern);
    }

    private void checkClassName(String className) throws JDEException {
        StringTokenizer tokenizer = new StringTokenizer(className, ".");
        boolean first = true;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!(this.isJavaIdentifier(token) || first && token.equals("*"))) {
                throw new JDEException("(Class Pattern Resolution Error) Invalid pattern '" + className + "'");
            }
            first = false;
        }
    }

    private boolean isJavaIdentifier(String s) {
        if (s.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < s.length()) {
            if (!Character.isJavaIdentifierPart(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return this.isWild ? "*." + this.classPattern : this.classPattern;
    }
}

