'\"
'\" Copyright (c) 2004 Joe English
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: ttk_intro.n,v 1.10.2.2 2010/08/26 02:06:09 hobbs Exp $
'\" 
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\" RCS: @(#) $Id: man.macros,v 1.9 2008/01/29 15:32:33 dkf Exp $
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.TH ttk::intro n 8.5 Tk "Tk Themed Widget"
.BS
.SH NAME
ttk::intro \- Introduction to the Tk theme engine
.BE
.SH "OVERVIEW"
.PP
The Tk themed widget set is based on a revised and enhanced version
of TIP #48 (http://tip.tcl.tk/48) specified style engine.
The main concepts are described below.
The basic idea is to separate, to the extent possible,
the code implementing a widget's behavior from
the code implementing its appearance.
Widget class bindings are primarily responsible for
maintaining the widget state and invoking callbacks;
all aspects of the widget's appearance are controlled by the style of
the widget (i.e. the style of the elements of the widget).
.SH "THEMES"
.PP
A \fItheme\fR is a collection of elements and styles 
that determine the look and feel of the widget set.
Themes can be used to:
.IP \(bu
isolate platform differences (X11 vs. classic Windows vs. XP vs. Aqua ...)
.IP \(bu
adapt to display limitations (low-color, grayscale, monochrome, tiny screens)
.IP \(bu
accessibility (high contrast, large type)
.IP \(bu
application suite branding
.IP \(bu
blend in with the rest of the desktop (Gnome, KDE, Java)
.IP \(bu
and, of course: eye candy.
.SH "ELEMENTS"
.PP
An \fIelement\fR displays an individual part of a widget.
For example, a vertical scrollbar widget contains \fBuparrow\fR,
\fBdownarrow\fR, \fBtrough\fR and \fBslider\fR elements.
.PP
Element names use a recursive dotted notation.
For example, \fBuparrow\fR identifies a generic arrow element,
and \fBScrollbar.uparrow\fR and \fBCombobox.uparrow\fR identify 
widget-specific elements.
When looking for an element, the style engine looks for
the specific name first, and if an element of that name is
not found it looks for generic elements by stripping off
successive leading components of the element name.
.PP
Like widgets, elements have \fIoptions\fR which
specify what to display and how to display it.
For example, the \fBtext\fR element 
(which displays a text string) has
\fB\-text\fR, \fB\-font\fR, \fB\-foreground\fR, \fB\-background\fR, 
\fB\-underline\fR, and \fB\-width\fR options.
The value of an element option is taken from:
.IP \(bu
an option of the same name and type in the widget containing the element;
.IP \(bu
a dynamic setting specified by \fBstyle map\fR and the current state;
.IP \(bu
the default setting specified by \fBstyle configure\fR; or
.IP \(bu
the element's built-in default value for the option.
.SH "LAYOUTS"
.PP
A \fIlayout\fR specifies which elements make up a widget
and how they are arranged.
The layout engine uses a simplified version of the \fBpack\fR
algorithm: starting with an initial cavity equal to the size
of the widget, elements are allocated a parcel within the cavity along
the side specified by the \fB\-side\fR option,
and placed within the parcel according to the \fB\-sticky\fR
option.
For example, the layout for a horizontal scrollbar is:
.PP
.CS
ttk::\fBstyle layout\fR Horizontal.TScrollbar {
    Scrollbar.trough \-children {
	Scrollbar.leftarrow \-side left \-sticky w
	Scrollbar.rightarrow \-side right \-sticky e
	Scrollbar.thumb \-side left \-expand true \-sticky ew
    }
}
.CE
.PP
By default, the layout for a widget is the same as its class name.
Some widgets may override this (for example, the \fBttk::scrollbar\fR
widget chooses different layouts based on the \fB\-orient\fR option).
.SH "STATES"
.PP
In standard Tk, many widgets have a \fB\-state\fR option
which (in most cases) is either \fBnormal\fR or \fBdisabled\fR.
Some widgets support additional states, such
as the \fBentry\fR widget which has a \fBreadonly\fR state
and the various flavors of buttons which have \fBactive\fR state.
.PP
The themed Tk widgets generalizes this idea:
every widget has a bitmap of independent state flags.
Widget state flags include \fBactive\fR, \fBdisabled\fR,
\fBpressed\fR, \fBfocus\fR, etc., 
(see \fIttk::widget(n)\fR for the full list of state flags).
.PP
Instead of a \fB\-state\fR option, every widget now has 
a \fBstate\fR widget command which is used to set or query
the state.
A \fIstate specification\fR is a list of symbolic state names
indicating which bits are set, each optionally prefixed with an 
exclamation point indicating that the bit is cleared instead.
.PP
For example, the class bindings for the \fBttk::button\fR
widget are:
.PP
.CS
bind TButton <Enter>		{ %W state active }
bind TButton <Leave>		{ %W state !active }
bind TButton <ButtonPress-1>	{ %W state pressed }
bind TButton <Button1-Leave>	{ %W state !pressed }
bind TButton <Button1-Enter>	{ %W state pressed }
bind TButton <ButtonRelease-1>	\e
    { %W instate {pressed} { %W state !pressed ; %W invoke } }
.CE
.PP
This specifies that the widget becomes \fBactive\fR when
the pointer enters the widget, and inactive when it leaves.
Similarly it becomes \fBpressed\fR when the mouse button is pressed,
and \fB!pressed\fR on the ButtonRelease event.
In addition, the button unpresses if 
pointer is dragged outside the widget while Button-1 is held down,
and represses if it's dragged back in.
Finally, when the mouse button is released, the widget's
\fB\-command\fR is invoked, but only if the button is currently
in the \fBpressed\fR state.
(The actual bindings are a little more complicated than the above,
but not by much).
'\" Note to self: rewrite that paragraph.  It's horrible.
.SH "STYLES"
.PP
Each widget is associated with a \fIstyle\fR, 
which specifies values for element options.
Style names use a recursive dotted notation like layouts and elements;
by default, widgets use the class name to look up a style in the current theme.
For example:
.PP
.CS
ttk::\fBstyle configure\fR TButton \e
	\-background #d9d9d9 \e
	\-foreground black \e
	\-relief raised \e
	;
.CE
.PP
Many elements are displayed differently depending on the widget state.  
For example, buttons have a different background when they are active,
a different foreground when disabled, and a different relief when pressed.
The \fBstyle map\fR command specifies dynamic option settings
for a particular style:
.PP
.CS
ttk::\fBstyle map\fR TButton \e
	\-background [list disabled #d9d9d9  active #ececec] \e
	\-foreground [list disabled #a3a3a3] \e
	\-relief [list {pressed !disabled} sunken] \e
	;
.CE
.SH "SEE ALSO"
ttk::widget(n), ttk::style(n)
'\" Local Variables:
'\" mode: nroff
'\" End:
