<?php
/*
 * Copyright 2005 - 2009  Zarafa B.V.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 *  
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 * 
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Zarafa" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Zarafa" or "Zarafa Server", you may only do so if you
 * have a written permission by Zarafa B.V. (to acquire a permission
 * please contact Zarafa at trademark@zarafa.com).
 * 
 * The interactive user interface of the software displays an attribution
 * notice containing the term "Zarafa" and/or the logo of Zarafa.
 * Interactive user interfaces of unmodified and modified versions must
 * display Appropriate Legal Notices according to sec. 5 of the GNU
 * Affero General Public License, version 3, when you propagate
 * unmodified or modified versions of the Program. In accordance with
 * sec. 7 b) of the GNU Affero General Public License, version 3, these
 * Appropriate Legal Notices must retain the logo of Zarafa or display
 * the words "Initial Development by Zarafa" if the display of the logo
 * is not reasonably feasible for technical reasons. The use of the logo
 * of Zarafa in Legal Notices is allowed for unmodified and modified
 * versions of the software.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

?>
<?php
	/**
	 * MultiUserCalendar Module
	*/
	
	class MultiUserCalendarModule extends ListModule 
	{
		/**
		 * Constructor
		 * @param int $id unique id.
		 * @param array $data list of all actions.
		 */
		function MultiUserCalendarModule($id, $data)
		{
			$this->properties = Array();
			$this->startdate = false;
			$this->enddate = false;

			$this->sort = array();

			parent::ListModule($id, $data, array(OBJECT_SAVE, TABLE_SAVE, TABLE_DELETE));
		}

		/**
		 * Executes all the actions in the $data variable.
		 * @return boolean true on success of false on fialure.
		 */
		function execute()
		{
			$result = false;
			
			if(!mapi_zarafa_check_license($GLOBALS['mapisession']->getDefaultMessageStore(), "WA-ADVANCED-CALENDAR")) {
				// return error
				$data = array();
				$data["attributes"] = array("type" => "error");
				$data["error"] = array();
				$data["error"]["hresult"] = MAPI_E_NO_ACCESS;
				$data["error"]["hresult_name"] = get_mapi_error_name(MAPI_E_NO_ACCESS);
				$data["error"]["message"] = _("Multi-user calendar is not available with your license");
				
				array_push($this->responseData["action"], $data);
				$GLOBALS["bus"]->addData($this->responseData);
				return true;
			}
			
			foreach($this->data as $action)
			{
				if(isset($action["attributes"]) && isset($action["attributes"]["type"])) {
					$store = $this->getActionStore($action);
					$parententryid = $this->getActionParentEntryID($action);
					$entryid = $this->getActionEntryID($action);
				
					switch($action["attributes"]["type"])
					{
						case "getaddressbookusers":
							$result = $this->GABUsers($action);
							break;
						case "getgroups":
							$result = $this->getGroups($action);
							break;
						case "savegroup":
							$result = $this->saveGroup($action);
							break;
						case "getgroupusers":
							$result = $this->getGroupUsers($action);
							break;
						case "getusers":
							$result = $this->getUsers($action);
							break;
					}
				}
			}

			return $result;
		}

		function getGroups($action){
			$restriction = Array(
				RES_AND,
				Array(
					Array(	// Check for PR_MESSAGE_CLASS == IPM.appointment
						RES_CONTENT,
						Array(
							FUZZYLEVEL => FL_FULLSTRING,
							ULPROPTAG => PR_MESSAGE_CLASS,
							VALUE => Array(
								PR_MESSAGE_CLASS => 'IPM.Appointment'
							)
						)
					),
					Array(	// Check if subject starts with "{B911D251-1842-4720-A131-F164B6C99078} - "
						RES_CONTENT,
						Array(
							FUZZYLEVEL => FL_PREFIX,
							ULPROPTAG => PR_SUBJECT,
							VALUE => Array(
								PR_SUBJECT => '{B911D251-1842-4720-A131-F164B6C99078} - '
							)
						)
					)
				)
			);

			$root = mapi_msgstore_openentry($GLOBALS['mapisession']->getDefaultMessageStore(),  null);
			$rootProps = mapi_getProps($root, Array(PR_IPM_APPOINTMENT_ENTRYID));

			$folder = mapi_msgstore_openentry($GLOBALS['mapisession']->getDefaultMessageStore(), $rootProps[PR_IPM_APPOINTMENT_ENTRYID]);
			$table = mapi_folder_getcontentstable($folder, MAPI_ASSOCIATED);
			$calendaritems = mapi_table_queryallrows($table, Array(PR_ENTRYID, PR_SUBJECT), $restriction);

			$items = Array();
			for($i=0;$i<count($calendaritems);$i++){
				$items[] = Array(
					'type' => 'usergroup',
					'entryid' => bin2hex($calendaritems[$i][PR_ENTRYID]),
					'subject' => str_replace('{B911D251-1842-4720-A131-F164B6C99078} - ', '', $calendaritems[$i][PR_SUBJECT])
				);
			}


			$data = array();
			$data["attributes"] = array("type" => "list");
			$data = array_merge($data, array("item"=>$items));

			array_push($this->responseData["action"], $data);
			$GLOBALS["bus"]->addData($this->responseData);
			return true;
		}

		function getGroupUsers($action){
			$recipientRestriction = Array(
				// Check for PR_ADDRTYPE == ZARAFA
				RES_CONTENT,
				Array(
					FUZZYLEVEL => FL_FULLSTRING,
					ULPROPTAG => PR_ADDRTYPE,
					VALUE => Array(
						PR_ADDRTYPE => 'ZARAFA'
					)
				)
			);

			$items = Array();

			$message = mapi_msgstore_openentry($GLOBALS['mapisession']->getDefaultMessageStore(), hex2bin($action['group_entry_id']));

			$msgRecipientsTable = mapi_message_getrecipienttable($message);

			$msgRecipientsTableItems = mapi_table_queryallrows($msgRecipientsTable, Array(PR_DISPLAY_NAME, PR_ADDRTYPE, PR_ENTRYID, PR_EMAIL_ADDRESS), $recipientRestriction);

			for($i=0;$i<count($msgRecipientsTableItems);$i++){
				$item = Array(
					'type' => 'user',
					'userentryid' => bin2hex($msgRecipientsTableItems[$i][PR_ENTRYID]),
					'display_name' => $msgRecipientsTableItems[$i][PR_DISPLAY_NAME],
					'username' => $msgRecipientsTableItems[$i][PR_EMAIL_ADDRESS]
				);

				// Get StoreEntryID by username  (this => $GLOBALS['mapisession'])   [check hresult==0]
				$user_store_entryid = mapi_msgstore_createentryid($GLOBALS['mapisession']->getDefaultMessageStore(), $item['username']);

				// Open store (this => $GLOBALS['mapisession'])
				$userStore = $GLOBALS['mapisession']->openMessageStore($user_store_entryid);

				// Open root folder
				$userRoot = mapi_msgstore_openentry($userStore, null);

				// Get calendar entryID
				$userRootProps = mapi_getprops($userRoot, array(PR_STORE_ENTRYID, PR_IPM_APPOINTMENT_ENTRYID));

				// Open Calendar folder   [check hresult==0]
				$calFolder = mapi_msgstore_openentry($userStore, $userRootProps[PR_IPM_APPOINTMENT_ENTRYID]);

				if($calFolder){
					$calFolderProps = mapi_getProps($calFolder, Array(PR_ACCESS));
					$item['access'] = $calFolderProps[PR_ACCESS];

					$item["storeid"] = bin2hex($userRootProps[PR_STORE_ENTRYID]);
					$item["calentryid"] = bin2hex($userRootProps[PR_IPM_APPOINTMENT_ENTRYID]);

				}else{
					$item['access'] = 0;
				}

				$items[] = $item;
			}

			$data = array();
			$data["attributes"] = array("type" => "list");
			$data = array_merge($data, array("item"=>$items));

			array_push($this->responseData["action"], $data);
			$GLOBALS["bus"]->addData($this->responseData);
			return true;
		}

		function getUsers($action){
			if(!$action["users"])
				return false;

			$items = Array();

			foreach($action["users"] as $key => $user){
				$item = Array();
				// Handle the weird behaviour of the XML Reader
				if(!isset($user["username"]) && isset($user["user"])){
					$user = $user["user"];
				}

				if($user['username']){
					// Get StoreEntryID by username  (this => $GLOBALS['mapisession'])   [check hresult==0]
					$user_store_entryid = mapi_msgstore_createentryid($GLOBALS['mapisession']->getDefaultMessageStore(), $user['username']);

					// Open store (this => $GLOBALS['mapisession'])
					$userStore = $GLOBALS['mapisession']->openMessageStore($user_store_entryid);

					// Open root folder
					$userRoot = mapi_msgstore_openentry($userStore, null);

					// Get calendar entryID
					$userRootProps = mapi_getprops($userRoot, array(PR_STORE_ENTRYID, PR_IPM_APPOINTMENT_ENTRYID));

					// Check to see if this user has an entryID for the calendar
					if($userRootProps[PR_IPM_APPOINTMENT_ENTRYID]){
						// Open Calendar folder   [check hresult==0]
						$calFolder = mapi_msgstore_openentry($userStore, $userRootProps[PR_IPM_APPOINTMENT_ENTRYID]);
						if($calFolder){
							$calFolderProps = mapi_getProps($calFolder, Array(PR_ACCESS));
							$item['access'] = $calFolderProps[PR_ACCESS];

							$item["storeid"] = bin2hex($userRootProps[PR_STORE_ENTRYID]);
							$item["calentryid"] = bin2hex($userRootProps[PR_IPM_APPOINTMENT_ENTRYID]);

						// Could not open calendar
						}else{
							$item['access'] = 0;
						}
					// No Calendar entryID
					}else{
						$item['access'] = 0;
					}

					$ab = $GLOBALS["mapisession"]->getAddressbook();
					$userData = array( array( PR_DISPLAY_NAME => u2w($user['username']) ) );
					$userData = mapi_ab_resolvename($ab, $userData, EMS_AB_ADDRESS_LOOKUP);
					if(is_array($userData) && count($userData) > 0){
						$item["display_name"] = windows1252_to_utf8($userData[0][PR_DISPLAY_NAME]);
						$item["username"] = $user['username'];
					}else{
						$item['unknown_user'] = 1;
						$item["username"] = $user['username'];
					}
					$items[] = $item;
				}

			}

			$data = array();
			$data["attributes"] = array("type" => "list");
			$data = array_merge($data, array("item"=>$items));

			array_push($this->responseData["action"], $data);
			$GLOBALS["bus"]->addData($this->responseData);
			return true;
		}

	}
	
?>
