/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.crypto.cipher.CipherFactory;
import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.mac.IMac;
import gnu.javax.crypto.mac.MacFactory;
import gnu.javax.crypto.mode.IMode;
import gnu.javax.crypto.mode.ModeFactory;
import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.SSLHMac;
import gnu.javax.net.ssl.provider.Util;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;

final class CipherSuite
implements Constructed {
    private static final List tlsSuiteNames = new LinkedList();
    private static final HashMap namesToSuites = new HashMap();
    static final CipherSuite SSL_NULL_WITH_NULL_NULL = new CipherSuite("null", "null", "null", "null", 0, 0, 0, "SSL_NULL_WITH_NULL_NULL", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_RSA_WITH_NULL_MD5 = new CipherSuite("null", "RSA", "RSA", "SSLMAC-MD5", 0, 0, 1, "SSL_RSA_WITH_NULL_MD5", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_RSA_WITH_NULL_SHA = new CipherSuite("null", "RSA", "RSA", "SSLMAC-SHA", 0, 0, 2, "SSL_RSA_WITH_NULL_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_RSA_EXPORT_WITH_RC4_40_MD5 = new CipherSuite("RC4", "RSA", "RSA", "SSLMAC-MD5", 5, 0, 3, "SSL_RSA_EXPORT_WITH_RC4_40_MD5", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_RSA_WITH_RC4_128_MD5 = new CipherSuite("RC4", "RSA", "RSA", "SSLMAC-MD5", 16, 0, 4, "SSL_RSA_WITH_RC4_128_MD5", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_RSA_WITH_RC4_128_SHA = new CipherSuite("RC4", "RSA", "RSA", "SSLMAC-SHA", 16, 0, 5, "SSL_RSA_WITH_RC4_128_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_RSA_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("DES", "RSA", "RSA", "SSLMAC-SHA", 5, 0, 8, "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_RSA_WITH_DES_CBC_SHA = new CipherSuite("DES", "RSA", "RSA", "SSLMAC-SHA", 8, 0, 9, "SSL_RSA_WITH_DES_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_RSA_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TripleDES", "RSA", "RSA", "SSLMAC-SHA", 24, 0, 10, "SSL_RSA_WITH_3DES_EDE_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DH_DSS_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("DES", "DH", "DSS", "SSLMAC-SHA", 5, 0, 11, "SSL_DH_DSS_EXPORT_WITH_DES40_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DH_DSS_WITH_DES_CBC_SHA = new CipherSuite("DES", "DH", "DSS", "SSLMAC-SHA", 8, 0, 12, "SSL_DH_DSS_WITH_DES_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DH_DSS_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TripleDES", "DH", "DSS", "SSLMAC-SHA", 24, 0, 13, "SSL_DH_DSS_WITH_3DES_EDE_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DH_RSA_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("DES", "DH", "RSA", "SSLMAC-SHA", 5, 0, 14, "SSL_DH_RSA_EXPORT_WITH_DES40_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DH_RSA_WITH_DES_CBC_SHA = new CipherSuite("DES", "DH", "RSA", "SSLMAC-SHA", 8, 0, 15, "SSL_DH_RSA_WITH_DES_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DH_RSA_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TripleDES", "DH", "RSA", "SSLMAC-SHA", 24, 0, 16, "SSL_DH_RSA_WITH_3DES_EDE_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("DES", "DHE", "DSS", "SSLMAC-SHA", 5, 0, 17, "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DHE_DSS_WITH_DES_CBC_SHA = new CipherSuite("DES", "DHE", "DSS", "SSLMAC-SHA", 8, 0, 18, "SSL_DHE_DSS_WITH_DES_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TripleDES", "DHE", "DSS", "SSLMAC-SHA", 24, 0, 19, "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("DES", "DHE", "RSA", "SSLMAC-SHA", 5, 0, 20, "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DHE_RSA_WITH_DES_CBC_SHA = new CipherSuite("DES", "DHE", "RSA", "SSLMAC-SHA", 8, 0, 21, "SSL_DHE_RSA_WITH_DES_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TripleDES", "DHE", "RSA", "SSLMAC-SHA", 24, 0, 22, "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_RSA_WITH_AES_128_CBC_SHA = new CipherSuite("AES", "RSA", "RSA", "SSLMAC-SHA", 16, 0, 47, "SSL_RSA_WITH_AES_128_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DH_DSS_WITH_AES_128_CBC_SHA = new CipherSuite("AES", "DH", "DSS", "SSLMAC-SHA", 16, 0, 48, "SSL_DH_DSS_WITH_AES_128_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DH_RSA_WITH_AES_128_CBC_SHA = new CipherSuite("AES", "DH", "RSA", "SSLMAC-SHA", 16, 0, 49, "SSL_DH_RSA_WITH_AES_128_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DHE_DSS_WITH_AES_128_CBC_SHA = new CipherSuite("AES", "DHE", "DSS", "SSLMAC-SHA", 16, 0, 50, "SSL_DHE_DSS_WITH_AES_128_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DHE_RSA_WITH_AES_128_CBC_SHA = new CipherSuite("AES", "DHE", "RSA", "SSLMAC-SHA", 16, 0, 51, "SSL_DHE_RSA_WITH_AES_128_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_RSA_WITH_AES_256_CBC_SHA = new CipherSuite("AES", "RSA", "RSA", "SSLMAC-SHA", 32, 0, 53, "SSL_RSA_WITH_AES_256_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DH_DSS_WITH_AES_256_CBC_SHA = new CipherSuite("AES", "DH", "DSS", "SSLMAC-SHA", 32, 0, 54, "SSL_DH_DSS_WITH_AES_256_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DH_RSA_WITH_AES_256_CBC_SHA = new CipherSuite("AES", "DH", "RSA", "SSLMAC-SHA", 32, 0, 55, "SSL_DH_RSA_WITH_AES_256_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DHE_DSS_WITH_AES_256_CBC_SHA = new CipherSuite("AES", "DHE", "DSS", "SSLMAC-SHA", 32, 0, 56, "SSL_DHE_DSS_WITH_AES_256_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DHE_RSA_WITH_AES_256_CBC_SHA = new CipherSuite("AES", "DHE", "RSA", "SSLMAC-SHA", 32, 0, 57, "SSL_DHE_RSA_WITH_AES_256_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DHE_DSS_WITH_CAST_128_CBC_SHA = new CipherSuite("CAST5", "DHE", "DSS", "HMAC-SHA", 16, 0, 112, "SSL_DHE_DSS_WITH_CAST_128_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DHE_DSS_WITH_CAST_128_CBC_RMD = new CipherSuite("CAST5", "DHE", "DSS", "HMAC-RIPEMD-160", 16, 0, 113, "SSL_DHE_DSS_WITH_CAST_128_CBC_RMD", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DHE_DSS_WITH_3DES_EDE_CBC_RMD = new CipherSuite("TripleDES", "DHE", "DSS", "HMAC-RIPEMD-160", 24, 0, 114, "SSL_DHE_DSS_WITH_3DES_EDE_CBC_RMD", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DHE_DSS_WITH_AES_128_CBC_RMD = new CipherSuite("AES", "DHE", "DSS", "HMAC-RIPEMD-160", 16, 0, 115, "SSL_DHE_DSS_WITH_AES_128_CBC_RMD", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DHE_DSS_WITH_AES_256_CBC_RMD = new CipherSuite("AES", "DHE", "DSS", "HMAC-RIPEMD-160", 32, 0, 116, "SSL_DHE_DSS_WITH_AES_256_CBC_RMD", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DHE_RSA_WITH_CAST_128_CBC_SHA = new CipherSuite("CAST5", "DHE", "RSA", "HMAC-SHA", 16, 0, 117, "SSL_DHE_RSA_WITH_CAST_128_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DHE_RSA_WITH_CAST_128_CBC_RMD = new CipherSuite("CAST5", "DHE", "RSA", "HMAC-RIPEMD-160", 16, 0, 118, "SSL_DHE_RSA_WITH_CAST_128_CBC_RMD", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DHE_RSA_WITH_3DES_EDE_CBC_RMD = new CipherSuite("TripleDES", "DHE", "RSA", "HMAC-RIPEMD-160", 24, 0, 119, "SSL_DHE_RSA_WITH_3DES_EDE_CBC_RMD", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DHE_RSA_WITH_AES_128_CBC_RMD = new CipherSuite("AES", "DHE", "RSA", "HMAC-RIPEMD-160", 16, 0, 120, "SSL_DHE_RSA_WITH_AES_128_CBC_RMD", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_DHE_RSA_WITH_AES_256_CBC_RMD = new CipherSuite("AES", "DHE", "RSA", "HMAC-RIPEMD-160", 32, 0, 121, "SSL_DHE_RSA_WITH_AES_256_CBC_RMD", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_RSA_WITH_CAST_128_CBC_SHA = new CipherSuite("CAST5", "RSA", "RSA", "HMAC-SHA", 16, 0, 122, "SSL_RSA_WITH_CAST_128_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_RSA_WITH_CAST_128_CBC_RMD = new CipherSuite("CAST5", "RSA", "RSA", "HMAC-RIPEMD-160", 16, 0, 123, "SSL_RSA_WITH_CAST_128_CBC_RMD", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_RSA_WITH_3DES_EDE_CBC_RMD = new CipherSuite("TripleDES", "RSA", "RSA", "HMAC-RIPEMD-160", 24, 0, 124, "SSL_RSA_WITH_3DES_EDE_CBC_RMD", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_RSA_WITH_AES_128_CBC_RMD = new CipherSuite("AES", "RSA", "RSA", "HMAC-RIPEMD-160", 16, 0, 125, "SSL_RSA_WITH_AES_128_CBC_RMD", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_RSA_WITH_AES_256_CBC_RMD = new CipherSuite("AES", "RSA", "RSA", "HMAC-RIPEMD-160", 32, 0, 126, "SSL_RSA_WITH_AES_256_CBC_RMD", ProtocolVersion.SSL_3);
    static final CipherSuite TLS_NULL_WITH_NULL_NULL = new CipherSuite("null", "null", "null", "null", 0, 0, 0, "TLS_NULL_WITH_NULL_NULL", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_RSA_WITH_NULL_MD5 = new CipherSuite("null", "RSA", "RSA", "HMAC-MD5", 0, 0, 1, "TLS_RSA_WITH_NULL_MD5", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_RSA_WITH_NULL_SHA = new CipherSuite("null", "RSA", "RSA", "HMAC-SHA", 0, 0, 2, "TLS_RSA_WITH_NULL_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_RSA_EXPORT_WITH_RC4_40_MD5 = new CipherSuite("RC4", "RSA", "RSA", "HMAC-MD5", 5, 0, 3, "TLS_RSA_EXPORT_WITH_RC4_40_MD5", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_RSA_WITH_RC4_128_MD5 = new CipherSuite("RC4", "RSA", "RSA", "HMAC-MD5", 16, 0, 4, "TLS_RSA_WITH_RC4_128_MD5", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_RSA_WITH_RC4_128_SHA = new CipherSuite("RC4", "RSA", "RSA", "HMAC-SHA", 16, 0, 5, "TLS_RSA_WITH_RC4_128_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_RSA_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("DES", "RSA", "RSA", "HMAC-SHA", 5, 0, 8, "TLS_RSA_EXPORT_WITH_DES40_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_RSA_WITH_DES_CBC_SHA = new CipherSuite("DES", "RSA", "RSA", "HMAC-SHA", 8, 0, 9, "TLS_RSA_WITH_DES_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_RSA_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TripleDES", "RSA", "RSA", "HMAC-SHA", 24, 0, 10, "TLS_RSA_WITH_3DES_EDE_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("DES", "DH", "DSS", "HMAC-SHA", 5, 0, 11, "TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DH_DSS_WITH_DES_CBC_SHA = new CipherSuite("DES", "DH", "DSS", "HMAC-SHA", 8, 0, 12, "TLS_DH_DSS_WITH_DES_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TripleDES", "DH", "DSS", "HMAC-SHA", 24, 0, 13, "TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("DES", "DH", "RSA", "HMAC-SHA", 5, 0, 14, "TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DH_RSA_WITH_DES_CBC_SHA = new CipherSuite("DES", "DH", "RSA", "HMAC-SHA", 8, 0, 15, "TLS_DH_RSA_WITH_DES_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TripleDES", "DH", "RSA", "HMAC-SHA", 24, 0, 16, "TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("DES", "DHE", "DSS", "HMAC-SHA", 5, 0, 17, "TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DHE_DSS_WITH_DES_CBC_SHA = new CipherSuite("DES", "DHE", "DSS", "HMAC-SHA", 8, 0, 18, "TLS_DHE_DSS_WITH_DES_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TripleDES", "DHE", "DSS", "HMAC-SHA", 24, 0, 19, "TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("DES", "DHE", "RSA", "HMAC-SHA", 5, 0, 20, "TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DHE_RSA_WITH_DES_CBC_SHA = new CipherSuite("DES", "DHE", "RSA", "HMAC-SHA", 8, 0, 21, "TLS_DHE_RSA_WITH_DES_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TripleDES", "DHE", "RSA", "HMAC-SHA", 24, 0, 22, "TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_RSA_WITH_AES_128_CBC_SHA = new CipherSuite("AES", "RSA", "RSA", "HMAC-SHA", 16, 0, 47, "TLS_RSA_WITH_AES_128_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DH_DSS_WITH_AES_128_CBC_SHA = new CipherSuite("AES", "DH", "DSS", "HMAC-SHA", 16, 0, 48, "TLS_DH_DSS_WITH_AES_128_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DH_RSA_WITH_AES_128_CBC_SHA = new CipherSuite("AES", "DH", "RSA", "HMAC-SHA", 16, 0, 49, "TLS_DH_RSA_WITH_AES_128_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DHE_DSS_WITH_AES_128_CBC_SHA = new CipherSuite("AES", "DHE", "DSS", "HMAC-SHA", 16, 0, 50, "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DHE_RSA_WITH_AES_128_CBC_SHA = new CipherSuite("AES", "DHE", "RSA", "HMAC-SHA", 16, 0, 51, "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_RSA_WITH_AES_256_CBC_SHA = new CipherSuite("AES", "RSA", "RSA", "HMAC-SHA", 32, 0, 53, "TLS_RSA_WITH_AES_256_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DH_DSS_WITH_AES_256_CBC_SHA = new CipherSuite("AES", "DH", "DSS", "HMAC-SHA", 32, 0, 54, "TLS_DH_DSS_WITH_AES_256_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DH_RSA_WITH_AES_256_CBC_SHA = new CipherSuite("AES", "DH", "RSA", "HMAC-SHA", 32, 0, 55, "TLS_DH_RSA_WITH_AES_256_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DHE_DSS_WITH_AES_256_CBC_SHA = new CipherSuite("AES", "DHE", "DSS", "HMAC-SHA", 32, 0, 56, "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DHE_RSA_WITH_AES_256_CBC_SHA = new CipherSuite("AES", "DHE", "RSA", "HMAC-SHA", 32, 0, 57, "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TripleDES", "SRP", "anon", "HMAC-SHA", 24, 0, 80, "TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TripleDES", "SRP", "RSA", "HMAC-SHA", 24, 0, 81, "TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TripleDES", "SRP", "DSS", "HMAC-SHA", 24, 0, 82, "TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_SRP_SHA_WITH_AES_128_CBC_SHA = new CipherSuite("AES", "SRP", "anon", "HMAC-SHA", 16, 0, 83, "TLS_SRP_SHA_WITH_AES_128_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA = new CipherSuite("AES", "SRP", "RSA", "HMAC-SHA", 16, 0, 84, "TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA = new CipherSuite("AES", "SRP", "DSS", "HMAC-SHA", 16, 0, 85, "TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_SRP_SHA_WITH_AES_256_CBC_SHA = new CipherSuite("AES", "SRP", "anon", "HMAC-SHA", 32, 0, 86, "TLS_SRP_SHA_WITH_AES_256_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA = new CipherSuite("AES", "SRP", "RSA", "HMAC-SHA", 32, 0, 87, "TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA = new CipherSuite("AES", "SRP", "DSS", "HMAC-SHA", 32, 0, 88, "TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DHE_DSS_WITH_CAST_128_CBC_SHA = new CipherSuite("CAST5", "DHE", "DSS", "HMAC-SHA", 16, 0, 112, "TLS_DHE_DSS_WITH_CAST_128_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DHE_DSS_WITH_CAST_128_CBC_RMD = new CipherSuite("CAST5", "DHE", "DSS", "HMAC-RIPEMD-160", 16, 0, 113, "TLS_DHE_DSS_WITH_CAST_128_CBC_RMD", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DHE_DSS_WITH_3DES_EDE_CBC_RMD = new CipherSuite("TripleDES", "DHE", "DSS", "HMAC-RIPEMD-160", 24, 0, 114, "TLS_DHE_DSS_WITH_3DES_EDE_CBC_RMD", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DHE_DSS_WITH_AES_128_CBC_RMD = new CipherSuite("AES", "DHE", "DSS", "HMAC-RIPEMD-160", 16, 0, 115, "TLS_DHE_DSS_WITH_AES_128_CBC_RMD", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DHE_DSS_WITH_AES_256_CBC_RMD = new CipherSuite("AES", "DHE", "DSS", "HMAC-RIPEMD-160", 32, 0, 116, "TLS_DHE_DSS_WITH_AES_256_CBC_RMD", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DHE_RSA_WITH_CAST_128_CBC_SHA = new CipherSuite("CAST5", "DHE", "RSA", "HMAC-SHA", 16, 0, 117, "TLS_DHE_RSA_WITH_CAST_128_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DHE_RSA_WITH_CAST_128_CBC_RMD = new CipherSuite("CAST5", "DHE", "RSA", "HMAC-RIPEMD-160", 16, 0, 118, "TLS_DHE_RSA_WITH_CAST_128_CBC_RMD", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DHE_RSA_WITH_3DES_EDE_CBC_RMD = new CipherSuite("TripleDES", "DHE", "RSA", "HMAC-RIPEMD-160", 24, 0, 119, "TLS_DHE_RSA_WITH_3DES_EDE_CBC_RMD", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DHE_RSA_WITH_AES_128_CBC_RMD = new CipherSuite("AES", "DHE", "RSA", "HMAC-RIPEMD-160", 16, 0, 120, "TLS_DHE_RSA_WITH_AES_128_CBC_RMD", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_DHE_RSA_WITH_AES_256_CBC_RMD = new CipherSuite("AES", "DHE", "RSA", "HMAC-RIPEMD-160", 32, 0, 121, "TLS_DHE_RSA_WITH_AES_256_CBC_RMD", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_RSA_WITH_CAST_128_CBC_SHA = new CipherSuite("CAST5", "RSA", "RSA", "HMAC-SHA", 16, 0, 122, "TLS_RSA_WITH_CAST_128_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_RSA_WITH_CAST_128_CBC_RMD = new CipherSuite("CAST5", "RSA", "RSA", "HMAC-RIPEMD-160", 16, 0, 123, "TLS_RSA_WITH_CAST_128_CBC_RMD", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_RSA_WITH_3DES_EDE_CBC_RMD = new CipherSuite("TripleDES", "RSA", "RSA", "HMAC-RIPEMD-160", 24, 0, 124, "TLS_RSA_WITH_3DES_EDE_CBC_RMD", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_RSA_WITH_AES_128_CBC_RMD = new CipherSuite("AES", "RSA", "RSA", "HMAC-RIPEMD-160", 16, 0, 125, "TLS_RSA_WITH_AES_128_CBC_RMD", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_RSA_WITH_AES_256_CBC_RMD = new CipherSuite("AES", "RSA", "RSA", "HMAC-RIPEMD-160", 32, 0, 126, "TLS_RSA_WITH_AES_256_CBC_RMD", ProtocolVersion.TLS_1);
    private final String cipherName;
    private final String kexName;
    private final String sigName;
    private final String macName;
    private final boolean exportable;
    private final boolean isStream;
    private final int keyLength;
    private final byte[] id;
    private final String name;
    private final ProtocolVersion version;

    static final CipherSuite forName(String string) {
        return (CipherSuite)namesToSuites.get(string);
    }

    static final List availableSuiteNames() {
        return tlsSuiteNames;
    }

    static final CipherSuite read(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[2];
        dataInputStream.readFully(byArray);
        return new CipherSuite(byArray);
    }

    static final IMode getCipher(String string) {
        IBlockCipher iBlockCipher = CipherFactory.getInstance(string);
        if (iBlockCipher == null) {
            return null;
        }
        return ModeFactory.getInstance("CBC", iBlockCipher, iBlockCipher.defaultBlockSize());
    }

    static final Cipher getJCECipher(String string) throws NoSuchAlgorithmException, NoSuchPaddingException {
        String string2 = Util.getSecurityProperty("jessie.with.jce.provider");
        if (string.equals("RC4")) {
            if (string2 != null) {
                try {
                    return Cipher.getInstance(string, string2);
                }
                catch (NoSuchProviderException noSuchProviderException) {}
            }
            return Cipher.getInstance(string);
        }
        if (string2 != null) {
            try {
                return Cipher.getInstance(string + "/CBC/SSL3Padding", string2);
            }
            catch (NoSuchProviderException noSuchProviderException) {}
        }
        return Cipher.getInstance(string + "/CBC/SSL3Padding");
    }

    static final IMac getMac(String string) {
        if (string.startsWith("SSLMAC-")) {
            return new SSLHMac(string.substring(7));
        }
        return MacFactory.getInstance(string);
    }

    static final Mac getJCEMac(String string) throws NoSuchAlgorithmException {
        String string2 = Util.getSecurityProperty("jessie.with.jce.provider");
        if (string2 != null) {
            try {
                return Mac.getInstance(string, string2);
            }
            catch (NoSuchProviderException noSuchProviderException) {}
        }
        return Mac.getInstance(string);
    }

    public final void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.id);
    }

    final CipherSuite resolve(ProtocolVersion protocolVersion) {
        if (protocolVersion == ProtocolVersion.SSL_3) {
            if (this.id[0] == 0) {
                switch (this.id[1]) {
                    case 0: {
                        return SSL_NULL_WITH_NULL_NULL;
                    }
                    case 1: {
                        return SSL_RSA_WITH_NULL_MD5;
                    }
                    case 2: {
                        return SSL_RSA_WITH_NULL_SHA;
                    }
                    case 3: {
                        return SSL_RSA_EXPORT_WITH_RC4_40_MD5;
                    }
                    case 4: {
                        return SSL_RSA_WITH_RC4_128_MD5;
                    }
                    case 5: {
                        return SSL_RSA_WITH_RC4_128_SHA;
                    }
                    case 8: {
                        return SSL_RSA_EXPORT_WITH_DES40_CBC_SHA;
                    }
                    case 9: {
                        return SSL_RSA_WITH_DES_CBC_SHA;
                    }
                    case 10: {
                        return SSL_RSA_WITH_3DES_EDE_CBC_SHA;
                    }
                    case 11: {
                        return SSL_DH_DSS_EXPORT_WITH_DES40_CBC_SHA;
                    }
                    case 12: {
                        return SSL_DH_DSS_WITH_DES_CBC_SHA;
                    }
                    case 13: {
                        return SSL_DH_DSS_WITH_3DES_EDE_CBC_SHA;
                    }
                    case 14: {
                        return SSL_DH_RSA_EXPORT_WITH_DES40_CBC_SHA;
                    }
                    case 15: {
                        return SSL_DH_RSA_WITH_DES_CBC_SHA;
                    }
                    case 16: {
                        return SSL_DH_RSA_WITH_3DES_EDE_CBC_SHA;
                    }
                    case 17: {
                        return SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA;
                    }
                    case 18: {
                        return SSL_DHE_DSS_WITH_DES_CBC_SHA;
                    }
                    case 19: {
                        return SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA;
                    }
                    case 20: {
                        return SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA;
                    }
                    case 21: {
                        return SSL_DHE_RSA_WITH_DES_CBC_SHA;
                    }
                    case 22: {
                        return SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA;
                    }
                    case 47: {
                        return SSL_RSA_WITH_AES_128_CBC_SHA;
                    }
                    case 48: {
                        return SSL_DH_DSS_WITH_AES_128_CBC_SHA;
                    }
                    case 49: {
                        return SSL_DH_RSA_WITH_AES_128_CBC_SHA;
                    }
                    case 50: {
                        return SSL_DHE_DSS_WITH_AES_128_CBC_SHA;
                    }
                    case 51: {
                        return SSL_DHE_RSA_WITH_AES_128_CBC_SHA;
                    }
                    case 53: {
                        return SSL_RSA_WITH_AES_256_CBC_SHA;
                    }
                    case 54: {
                        return SSL_DH_DSS_WITH_AES_256_CBC_SHA;
                    }
                    case 55: {
                        return SSL_DH_RSA_WITH_AES_256_CBC_SHA;
                    }
                    case 56: {
                        return SSL_DHE_DSS_WITH_AES_256_CBC_SHA;
                    }
                    case 57: {
                        return SSL_DHE_RSA_WITH_AES_256_CBC_SHA;
                    }
                }
            }
        } else if ((protocolVersion == ProtocolVersion.TLS_1 || protocolVersion == ProtocolVersion.TLS_1_1) && this.id[0] == 0) {
            switch (this.id[1]) {
                case 0: {
                    return TLS_NULL_WITH_NULL_NULL;
                }
                case 1: {
                    return TLS_RSA_WITH_NULL_MD5;
                }
                case 2: {
                    return TLS_RSA_WITH_NULL_SHA;
                }
                case 3: {
                    return TLS_RSA_EXPORT_WITH_RC4_40_MD5;
                }
                case 4: {
                    return TLS_RSA_WITH_RC4_128_MD5;
                }
                case 5: {
                    return TLS_RSA_WITH_RC4_128_SHA;
                }
                case 8: {
                    return TLS_RSA_EXPORT_WITH_DES40_CBC_SHA;
                }
                case 9: {
                    return TLS_RSA_WITH_DES_CBC_SHA;
                }
                case 10: {
                    return TLS_RSA_WITH_3DES_EDE_CBC_SHA;
                }
                case 11: {
                    return TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA;
                }
                case 12: {
                    return TLS_DH_DSS_WITH_DES_CBC_SHA;
                }
                case 13: {
                    return TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA;
                }
                case 14: {
                    return TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA;
                }
                case 15: {
                    return TLS_DH_RSA_WITH_DES_CBC_SHA;
                }
                case 16: {
                    return TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA;
                }
                case 17: {
                    return TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA;
                }
                case 18: {
                    return TLS_DHE_DSS_WITH_DES_CBC_SHA;
                }
                case 19: {
                    return TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA;
                }
                case 20: {
                    return TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA;
                }
                case 21: {
                    return TLS_DHE_RSA_WITH_DES_CBC_SHA;
                }
                case 22: {
                    return TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA;
                }
                case 47: {
                    return TLS_RSA_WITH_AES_128_CBC_SHA;
                }
                case 48: {
                    return TLS_DH_DSS_WITH_AES_128_CBC_SHA;
                }
                case 49: {
                    return TLS_DH_RSA_WITH_AES_128_CBC_SHA;
                }
                case 50: {
                    return TLS_DHE_DSS_WITH_AES_128_CBC_SHA;
                }
                case 51: {
                    return TLS_DHE_RSA_WITH_AES_128_CBC_SHA;
                }
                case 53: {
                    return TLS_RSA_WITH_AES_256_CBC_SHA;
                }
                case 54: {
                    return TLS_DH_DSS_WITH_AES_256_CBC_SHA;
                }
                case 55: {
                    return TLS_DH_RSA_WITH_AES_256_CBC_SHA;
                }
                case 56: {
                    return TLS_DHE_DSS_WITH_AES_256_CBC_SHA;
                }
                case 57: {
                    return TLS_DHE_RSA_WITH_AES_256_CBC_SHA;
                }
                case 80: {
                    return TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA;
                }
                case 81: {
                    return TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA;
                }
                case 82: {
                    return TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA;
                }
                case 83: {
                    return TLS_SRP_SHA_WITH_AES_128_CBC_SHA;
                }
                case 84: {
                    return TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA;
                }
                case 85: {
                    return TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA;
                }
                case 86: {
                    return TLS_SRP_SHA_WITH_AES_256_CBC_SHA;
                }
                case 87: {
                    return TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA;
                }
                case 88: {
                    return TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA;
                }
                case 112: {
                    return TLS_DHE_DSS_WITH_CAST_128_CBC_SHA;
                }
                case 113: {
                    return TLS_DHE_DSS_WITH_CAST_128_CBC_RMD;
                }
                case 114: {
                    return TLS_DHE_DSS_WITH_3DES_EDE_CBC_RMD;
                }
                case 115: {
                    return TLS_DHE_DSS_WITH_AES_128_CBC_RMD;
                }
                case 116: {
                    return TLS_DHE_DSS_WITH_AES_256_CBC_RMD;
                }
                case 117: {
                    return TLS_DHE_RSA_WITH_CAST_128_CBC_SHA;
                }
                case 118: {
                    return TLS_DHE_RSA_WITH_CAST_128_CBC_RMD;
                }
                case 119: {
                    return TLS_DHE_RSA_WITH_3DES_EDE_CBC_RMD;
                }
                case 120: {
                    return TLS_DHE_RSA_WITH_AES_128_CBC_RMD;
                }
                case 121: {
                    return TLS_DHE_RSA_WITH_AES_256_CBC_RMD;
                }
                case 122: {
                    return TLS_RSA_WITH_CAST_128_CBC_SHA;
                }
                case 123: {
                    return TLS_RSA_WITH_CAST_128_CBC_RMD;
                }
                case 124: {
                    return TLS_RSA_WITH_3DES_EDE_CBC_RMD;
                }
                case 125: {
                    return TLS_RSA_WITH_AES_128_CBC_RMD;
                }
                case 126: {
                    return TLS_RSA_WITH_AES_256_CBC_RMD;
                }
            }
        }
        return this;
    }

    final String getCipher() {
        return this.cipherName;
    }

    final int getKeyLength() {
        return this.keyLength;
    }

    final String getKeyExchange() {
        return this.kexName;
    }

    final String getSignature() {
        return this.sigName;
    }

    final String getMac() {
        return this.macName;
    }

    final boolean isExportable() {
        return this.exportable;
    }

    final boolean isStreamCipher() {
        return this.isStream;
    }

    final String getAuthType() {
        if (this.kexName.equals("RSA")) {
            if (this.isExportable()) {
                return "RSA_EXPORT";
            }
            return "RSA";
        }
        return this.kexName + '_' + this.sigName;
    }

    final byte[] getId() {
        return this.id;
    }

    final ProtocolVersion getVersion() {
        return this.version;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof CipherSuite)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        byte[] byArray = ((CipherSuite)object).getId();
        boolean bl = false;
        if (byArray[0] == this.id[0] && byArray[1] == this.id[1]) {
            bl = true;
        }
        return bl;
    }

    public final int hashCode() {
        if (this.version == null) {
            return 0xFFFF0000 | (this.id[0] & 0xFF) << 8 | this.id[1] & 0xFF;
        }
        return this.version.getMajor() << 24 | this.version.getMinor() << 16 | (this.id[0] & 0xFF) << 8 | this.id[1] & 0xFF;
    }

    public final String toString() {
        if (this.name == null) {
            return "UNKNOWN { " + (this.id[0] & 0xFF) + ", " + (this.id[1] & 0xFF) + " }";
        }
        return this.name;
    }

    private CipherSuite(String string, String string2, String string3, String string4, int n, int n2, int n3, String string5, ProtocolVersion protocolVersion) {
        this.cipherName = string.intern();
        this.kexName = string2.intern();
        this.sigName = string3.intern();
        this.macName = string4.intern();
        boolean bl = false;
        if (n <= 5) {
            bl = true;
        }
        this.exportable = bl;
        boolean bl2 = false;
        if (string.equals("null") || string.equals("RC4")) {
            bl2 = true;
        }
        this.isStream = bl2;
        this.keyLength = n;
        this.id = new byte[]{(byte)n2, (byte)n3};
        this.name = string5.intern();
        this.version = protocolVersion;
        namesToSuites.put(string5, this);
        if (string5.startsWith("TLS")) {
            tlsSuiteNames.add(string5);
        }
    }

    private CipherSuite(byte[] byArray) {
        this.cipherName = null;
        this.kexName = null;
        this.sigName = null;
        this.macName = null;
        this.exportable = false;
        this.isStream = false;
        this.keyLength = 0;
        this.id = byArray;
        this.name = null;
        this.version = null;
    }
}

