/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.lang.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;

public class TypeSignature {
    public static String getEncodingOfClass(String string, boolean bl) {
        if (!bl || string.charAt(0) == '[') {
            return string.replace('.', '/');
        }
        if (string.equals("boolean")) {
            return "Z";
        }
        if (string.equals("byte")) {
            return "B";
        }
        if (string.equals("short")) {
            return "S";
        }
        if (string.equals("char")) {
            return "C";
        }
        if (string.equals("int")) {
            return "I";
        }
        if (string.equals("long")) {
            return "J";
        }
        if (string.equals("float")) {
            return "F";
        }
        if (string.equals("double")) {
            return "D";
        }
        if (string.equals("void")) {
            return "V";
        }
        return "L" + string.replace('.', '/') + ';';
    }

    public static String getEncodingOfClass(Class clazz, boolean bl) {
        return TypeSignature.getEncodingOfClass(clazz.getName(), bl);
    }

    public static String getEncodingOfClass(Class clazz) {
        return TypeSignature.getEncodingOfClass(clazz.getName(), true);
    }

    public static Class getClassForEncoding(String string, boolean bl) throws ClassNotFoundException {
        return TypeSignature.getClassForEncoding(string, bl, null);
    }

    public static Class getClassForEncoding(String string, boolean bl, ClassLoader classLoader) throws ClassNotFoundException {
        if (bl) {
            switch (string.charAt(0)) {
                case 'B': {
                    return Byte.TYPE;
                }
                case 'C': {
                    return Character.TYPE;
                }
                case 'D': {
                    return Double.TYPE;
                }
                case 'F': {
                    return Float.TYPE;
                }
                case 'I': {
                    return Integer.TYPE;
                }
                case 'J': {
                    return Long.TYPE;
                }
                case 'S': {
                    return Short.TYPE;
                }
                case 'V': {
                    return Void.TYPE;
                }
                case 'Z': {
                    return Boolean.TYPE;
                }
                default: {
                    throw new ClassNotFoundException("Invalid class name: " + string);
                }
                case 'L': {
                    string = string.substring(1, string.length() - 1);
                }
                case '[': 
            }
        }
        return Class.forName(string.replace('/', '.'), true, classLoader);
    }

    public static Class getClassForEncoding(String string) throws ClassNotFoundException {
        return TypeSignature.getClassForEncoding(string, true);
    }

    public static String getEncodingOfMethod(Method method) {
        Class[] classArray = method.getParameterTypes();
        StringBuffer stringBuffer = new StringBuffer().append('(');
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append(TypeSignature.getEncodingOfClass(classArray[n].getName(), true));
            ++n;
        }
        stringBuffer.append(')').append(TypeSignature.getEncodingOfClass(method.getReturnType().getName(), true));
        return stringBuffer.toString();
    }

    public static String getEncodingOfConstructor(Constructor constructor) {
        Class[] classArray = constructor.getParameterTypes();
        StringBuffer stringBuffer = new StringBuffer().append('(');
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append(TypeSignature.getEncodingOfClass(classArray[n].getName(), true));
            ++n;
        }
        stringBuffer.append(")V");
        return stringBuffer.toString();
    }

    public static String getEncodingOfMember(Member member) {
        if (member instanceof Constructor) {
            return TypeSignature.getEncodingOfConstructor((Constructor)member);
        }
        if (member instanceof Method) {
            return TypeSignature.getEncodingOfMethod((Method)member);
        }
        return TypeSignature.getEncodingOfClass(((Field)member).getType().getName(), true);
    }
}

