/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels.spi;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.LinkedList;
import java.util.ListIterator;

public abstract class AbstractSelectableChannel
extends SelectableChannel {
    private boolean blocking;
    private Object LOCK;
    private SelectorProvider provider;
    private LinkedList keys;

    private /* synthetic */ void finit$() {
        this.blocking = true;
        this.LOCK = new Object();
        this.keys = new LinkedList();
    }

    protected AbstractSelectableChannel(SelectorProvider selectorProvider) {
        this.finit$();
        this.provider = selectorProvider;
    }

    public final Object blockingLock() {
        return this.LOCK;
    }

    public final SelectableChannel configureBlocking(boolean bl) throws IOException {
        AbstractSelectableChannel abstractSelectableChannel;
        Object object = this.blockingLock();
        synchronized (object) {
            block3: {
                try {
                    if (this.blocking == bl) break block3;
                    this.implConfigureBlocking(bl);
                    this.blocking = bl;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
            abstractSelectableChannel = null;
        }
        abstractSelectableChannel = this;
        return abstractSelectableChannel;
    }

    protected final void implCloseChannel() throws IOException {
        this.implCloseSelectableChannel();
    }

    protected abstract void implCloseSelectableChannel() throws IOException;

    protected abstract void implConfigureBlocking(boolean var1) throws IOException;

    public final boolean isBlocking() {
        return this.blocking;
    }

    public final boolean isRegistered() {
        return this.keys.isEmpty() ^ true;
    }

    public final SelectionKey keyFor(Selector selector) {
        if (!this.isOpen()) {
            return null;
        }
        try {
            Object object = this.blockingLock();
            synchronized (object) {
                try {
                    SelectionKey selectionKey = this.locate(selector);
                    Object var4_5 = null;
                    return selectionKey;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    throw throwable;
                }
            }
        }
        catch (Exception exception) {
            SelectionKey selectionKey = null;
            return selectionKey;
        }
    }

    public final SelectorProvider provider() {
        return this.provider;
    }

    private SelectionKey locate(Selector selector) {
        ListIterator listIterator = this.keys.listIterator();
        while (listIterator.hasNext()) {
            SelectionKey selectionKey = (SelectionKey)listIterator.next();
            if (selectionKey.selector() != selector) continue;
            return selectionKey;
        }
        return null;
    }

    public final SelectionKey register(Selector selector, int n, Object object) throws ClosedChannelException {
        SelectionKey selectionKey;
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if ((n & ~this.validOps()) != 0) {
            throw new IllegalArgumentException();
        }
        SelectionKey selectionKey2 = null;
        AbstractSelector abstractSelector = (AbstractSelector)selector;
        Object object2 = this.blockingLock();
        synchronized (object2) {
            block8: {
                try {
                    if (this.blocking) {
                        throw new IllegalBlockingModeException();
                    }
                    selectionKey2 = this.locate(abstractSelector);
                    if (selectionKey2 != null && selectionKey2.isValid()) {
                        if (object != null) {
                            selectionKey2.attach(object);
                        }
                        break block8;
                    }
                    selectionKey2 = abstractSelector.register(this, n, object);
                    if (selectionKey2 == null) break block8;
                    this.addSelectionKey(selectionKey2);
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    throw throwable;
                }
            }
            selectionKey = null;
        }
        selectionKey = selectionKey2;
        return selectionKey;
    }

    void addSelectionKey(SelectionKey selectionKey) {
        this.keys.add(selectionKey);
    }

    void removeSelectionKey(SelectionKey selectionKey) {
        this.keys.remove(selectionKey);
    }
}

