/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.dnd;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.event.MouseEvent;

public class GtkMouseDragGestureRecognizer
extends MouseDragGestureRecognizer {
    public GtkMouseDragGestureRecognizer(DragSource dragSource) {
        this(dragSource, null, 0, null);
    }

    public GtkMouseDragGestureRecognizer(DragSource dragSource, Component component) {
        this(dragSource, component, 0, null);
    }

    public GtkMouseDragGestureRecognizer(DragSource dragSource, Component component, int n) {
        this(dragSource, component, n, null);
    }

    public GtkMouseDragGestureRecognizer(DragSource dragSource, Component component, int n, DragGestureListener dragGestureListener) {
        super(dragSource, component, n, dragGestureListener);
    }

    public void registerListeners() {
        super.registerListeners();
    }

    public void unregisterListeners() {
        super.unregisterListeners();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.events.clear();
        if (this.getDropActionFromEvent(mouseEvent) != 0) {
            this.appendEvent(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.events.clear();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.events.clear();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.events.isEmpty() && this.getDropActionFromEvent(mouseEvent) == 0) {
            this.events.clear();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.events.isEmpty()) {
            int n = this.getDropActionFromEvent(mouseEvent);
            if (n == 0) {
                return;
            }
            Point point = ((MouseEvent)this.events.get(0)).getPoint();
            Point point2 = mouseEvent.getPoint();
            int n2 = Math.abs(point.x - point2.x);
            int n3 = Math.abs(point.y - point2.y);
            int n4 = DragSource.getDragThreshold();
            if (n2 > n4 || n3 > n4) {
                this.fireDragGestureRecognized(n, point);
            } else {
                this.appendEvent(mouseEvent);
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private int getDropActionFromEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiersEx();
        int n2 = n & 0x1C00;
        if (n2 != 1024 && n2 != 2048) {
            return 0;
        }
        int n3 = this.getSourceActions();
        int n4 = n & 0xC0;
        switch (n4) {
            case 192: {
                return 0x40000000 & n3;
            }
            case 128: {
                return 1 & n3;
            }
            case 64: {
                return 2 & n3;
            }
        }
        if ((n3 & 2) != 0) {
            return 2 & n3;
        }
        if ((n3 & 1) != 0) {
            return 1 & n3;
        }
        if ((n3 & 0x40000000) != 0) {
            return 0x40000000 & n3;
        }
        return 0 & n3;
    }
}

