/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.id.ReferenceTypeId;
import gnu.classpath.jdwp.processor.CommandSet;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;

public class ArrayTypeCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer byteBuffer, DataOutputStream dataOutputStream, byte by) throws JdwpException {
        try {
            if (by != 1) {
                throw new NotImplementedException("Command " + by + " not found in ArrayType Command Set.");
            }
            this.executeNewInstance(byteBuffer, dataOutputStream);
        }
        catch (IOException iOException) {
            throw new JdwpInternalErrorException(iOException);
        }
        return false;
    }

    public void executeNewInstance(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ReferenceTypeId referenceTypeId = this.idMan.readReferenceTypeId(byteBuffer);
        Class clazz = referenceTypeId.getType();
        Class clazz2 = clazz.getComponentType();
        int n = byteBuffer.getInt();
        Object object = Array.newInstance(clazz2, n);
        ObjectId objectId = this.idMan.getObjectId(object);
        objectId.disableCollection();
        objectId.writeTagged(dataOutputStream);
    }
}

