#ifndef __MSP430_HEADERS_CRC16_H
#define __MSP430_HEADERS_CRC16_H

/* crc16.h
 *
 * mspgcc project: MSP430 device headers
 * hardware CRC module
 *
 * (c) 2009 by J.M.Gross <mspgcc@grossibaer.de>
 * Originally based on MSP430x5xx Family User's Guide (slau208b).
 *
 * $Id: crc16.h,v 1.0 2009/10/08 23:00:38 Exp $
 */

/* Switches:

__MSP430_CRC16_BASE__ - base address of CRC16 module.

*/

#if defined(__MSP430_CRC16_BASE__)
#define CRCDI_                   __MSP430_CRC16_BASE__ + 0x00                   /* CRC Data in (word) */
sfrw(CRCDI, CRCDI_);
sfrb(CRCDI_L, CRCDI_);
sfrb(CRCDI_H, CRCDI_+1);
#define CRCDIRB_                 __MSP430_CRC16_BASE__ + 0x02                   /* CRC Data in reverse bit(word) */
sfrw(CRCDIRB, CRCDIRB_);
sfrb(CRCDIRB_L, CRCDIRB_);
sfrb(CRCDIRB_H, CRCDIRB_+1);
#define CRCINIRES_               __MSP430_CRC16_BASE__ + 0x04                   /* CRC initialisation and result */
sfrw(CRCINIRES, CRCINIRES_);
sfrb(CRCINIRES_L, CRCINIRES_);
sfrb(CRCINIRES_H, CRCINIRES_+1);
#define CRCRESR_                 __MSP430_CRC16_BASE__ + 0x06                   /* CRC result reverse */
sfrw(CRCRESR, CRCRESR_);
sfrb(CRCRESR_L, CRCRESR_);
sfrb(CRCRESR_H, CRCRESR_+1);
#endif

#endif  /* __MSP430_HEADERS_CRC16_H */
