/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.ValveContext;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

public class RequestDumperValve
extends ValveBase {
    private static final String info = "org.apache.catalina.valves.RequestDumperValve/1.0";
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.valves");

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response, ValveContext context) throws IOException, ServletException {
        if (!(request instanceof HttpRequest) || !(response instanceof HttpResponse)) {
            context.invokeNext(request, response);
            return;
        }
        HttpRequest hrequest = (HttpRequest)request;
        HttpResponse hresponse = (HttpResponse)response;
        HttpServletRequest hreq = (HttpServletRequest)hrequest.getRequest();
        this.log("REQUEST URI       =" + hreq.getRequestURI());
        this.log("          authType=" + hreq.getAuthType());
        this.log(" characterEncoding=" + hreq.getCharacterEncoding());
        this.log("     contentLength=" + hreq.getContentLength());
        this.log("       contentType=" + hreq.getContentType());
        this.log("       contextPath=" + hreq.getContextPath());
        Cookie[] cookies = hreq.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                this.log("            cookie=" + cookies[i].getName() + "=" + cookies[i].getValue());
            }
        }
        Enumeration hnames = hreq.getHeaderNames();
        while (hnames.hasMoreElements()) {
            String hname = (String)hnames.nextElement();
            Enumeration hvalues = hreq.getHeaders(hname);
            while (hvalues.hasMoreElements()) {
                String hvalue = (String)hvalues.nextElement();
                this.log("            header=" + hname + "=" + hvalue);
            }
        }
        this.log("            locale=" + hreq.getLocale());
        this.log("            method=" + hreq.getMethod());
        Enumeration pnames = hreq.getParameterNames();
        while (pnames.hasMoreElements()) {
            String pname = (String)pnames.nextElement();
            String[] pvalues = hreq.getParameterValues(pname);
            StringBuffer result = new StringBuffer(pname);
            result.append('=');
            for (int i = 0; i < pvalues.length; ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(pvalues[i]);
            }
            this.log("         parameter=" + result.toString());
        }
        this.log("          pathInfo=" + hreq.getPathInfo());
        this.log("          protocol=" + hreq.getProtocol());
        this.log("       queryString=" + hreq.getQueryString());
        this.log("        remoteAddr=" + hreq.getRemoteAddr());
        this.log("        remoteHost=" + hreq.getRemoteHost());
        this.log("        remoteUser=" + hreq.getRemoteUser());
        this.log("requestedSessionId=" + hreq.getRequestedSessionId());
        this.log("            scheme=" + hreq.getScheme());
        this.log("        serverName=" + hreq.getServerName());
        this.log("        serverPort=" + hreq.getServerPort());
        this.log("       servletPath=" + hreq.getServletPath());
        this.log("          isSecure=" + hreq.isSecure());
        this.log("---------------------------------------------------------------");
        context.invokeNext(request, response);
        this.log("---------------------------------------------------------------");
        this.log("          authType=" + hreq.getAuthType());
        this.log("     contentLength=" + hresponse.getContentLength());
        this.log("       contentType=" + hresponse.getContentType());
        Cookie[] rcookies = hresponse.getCookies();
        for (int i = 0; i < rcookies.length; ++i) {
            this.log("            cookie=" + rcookies[i].getName() + "=" + rcookies[i].getValue() + "; domain=" + rcookies[i].getDomain() + "; path=" + rcookies[i].getPath());
        }
        String[] rhnames = hresponse.getHeaderNames();
        for (int i = 0; i < rhnames.length; ++i) {
            String[] rhvalues = hresponse.getHeaderValues(rhnames[i]);
            for (int j = 0; j < rhvalues.length; ++j) {
                this.log("            header=" + rhnames[i] + "=" + rhvalues[j]);
            }
        }
        this.log("           message=" + hresponse.getMessage());
        this.log("        remoteUser=" + hreq.getRemoteUser());
        this.log("            status=" + hresponse.getStatus());
        this.log("===============================================================");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("RequestDumperValve[");
        if (this.container != null) {
            sb.append(this.container.getName());
        }
        sb.append("]");
        return sb.toString();
    }

    protected void log(String message) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + message);
        } else {
            System.out.println(this.toString() + ": " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + message, throwable);
        } else {
            System.out.println(this.toString() + ": " + message);
            throwable.printStackTrace(System.out);
        }
    }
}

