/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.ui.DeferredDebugElementWorkbenchAdapter;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.IVariableLocator;
import org.python.pydev.debug.model.PyStackFrame;
import org.python.pydev.debug.model.PyVariable;
import org.python.pydev.debug.model.PyVariableCollection;
import org.python.pydev.debug.model.remote.AbstractDebuggerCommand;
import org.python.pydev.debug.model.remote.GetVariableCommand;
import org.python.pydev.debug.model.remote.ICommandResponseListener;

public class DeferredWorkbenchAdapter
extends DeferredDebugElementWorkbenchAdapter
implements IDeferredWorkbenchAdapter,
ICommandResponseListener {
    private PyVariable[] commandVariables;
    private AbstractDebugTarget target;
    private IVariableLocator locator;
    private Object parent;
    private IProgressMonitor monitor;

    public DeferredWorkbenchAdapter(Object parent) {
        this.parent = parent;
    }

    public boolean isContainer() {
        if (this.parent instanceof PyVariableCollection) {
            return true;
        }
        return this.parent instanceof PyStackFrame;
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        this.monitor = monitor;
        if (monitor.isCanceled()) {
            return;
        }
        Object[] children = this.getChildren(object);
        if (monitor.isCanceled()) {
            return;
        }
        if (children != null && children.length > 0) {
            collector.add(children, monitor);
        }
        collector.done();
    }

    public Object[] getChildren(Object o) {
        if (this.parent != o) {
            throw new RuntimeException("This is valid only for a single getChildren!");
        }
        if (o instanceof PyVariableCollection) {
            PyVariableCollection variableCollection = (PyVariableCollection)o;
            this.target = variableCollection.getTarget();
            if (this.target != null) {
                this.locator = variableCollection;
                GetVariableCommand variableCommand = variableCollection.getVariableCommand(this.target);
                variableCommand.setCompletionListener(this);
                this.target.postCommand(variableCommand);
                return this.waitForCommand();
            }
            return new Object[0];
        }
        if (o instanceof PyStackFrame) {
            PyStackFrame f = (PyStackFrame)o;
            this.target = f.getTarget();
            if (this.target != null) {
                this.locator = f;
                GetVariableCommand variableCommand = f.getFrameCommand(this.target);
                variableCommand.setCompletionListener(this);
                this.target.postCommand(variableCommand);
                return this.waitForCommand();
            }
            return new Object[0];
        }
        if (o instanceof PyVariable) {
            return new Object[0];
        }
        throw new RuntimeException("Unexpected class: " + o.getClass());
    }

    private PyVariable[] waitForCommand() {
        try {
            int i = 1000;
            while (--i > 0 && this.commandVariables == null) {
                if (this.monitor != null && this.monitor.isCanceled()) {
                    return new PyVariable[0];
                }
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.commandVariables != null) {
            return this.commandVariables;
        }
        return new PyVariable[0];
    }

    public Object getParent(Object o) {
        return this.parent;
    }

    public void commandComplete(AbstractDebuggerCommand cmd) {
        PyVariable[] temp = PyVariableCollection.getCommandVariables(cmd, this.target, this.locator);
        if (this.parent instanceof PyVariableCollection) {
            this.commandVariables = temp;
        } else if (this.parent instanceof PyStackFrame) {
            PyStackFrame f = (PyStackFrame)this.parent;
            PyVariable[] temp1 = new PyVariable[temp.length + 1];
            System.arraycopy(temp, 0, temp1, 1, temp.length);
            temp1[0] = new PyVariableCollection(this.target, "Globals", "frame.f_global", "Global variables", f.getGlobalLocator());
            this.commandVariables = temp1;
        } else {
            throw new RuntimeException("Unknown parent:" + this.parent.getClass());
        }
    }
}

