/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited;

import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.cache.LRUCache;
import org.python.pydev.editor.codecompletion.revisited.ModulesKeyTreeMap;
import org.python.pydev.editor.codecompletion.revisited.ModulesManager;
import org.python.pydev.editor.codecompletion.revisited.modules.AbstractModule;

final class ModulesManagerCache {
    private static final int MAX_NUMBER_OF_MODULES = 400;
    LRUCache<Tuple<ModulesKey, ModulesManager>, AbstractModule> internalCache = new LRUCache(400);

    ModulesManagerCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractModule getObj(ModulesKey key, ModulesManager modulesManager) {
        ModulesKeyTreeMap<ModulesKey, ModulesKey> modulesKeyTreeMap = modulesManager.modulesKeys;
        synchronized (modulesKeyTreeMap) {
            Tuple keyTuple = new Tuple((Object)key, (Object)modulesManager);
            AbstractModule obj = (AbstractModule)this.internalCache.getObj((Object)keyTuple);
            if (obj == null && modulesManager.modulesKeys.containsKey(key)) {
                key = modulesManager.modulesKeys.get(key);
                obj = AbstractModule.createEmptyModule(key);
                this.internalCache.add((Object)keyTuple, (Object)obj);
            }
            return obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ModulesKey key, ModulesManager modulesManager) {
        ModulesKeyTreeMap<ModulesKey, ModulesKey> modulesKeyTreeMap = modulesManager.modulesKeys;
        synchronized (modulesKeyTreeMap) {
            Tuple keyTuple = new Tuple((Object)key, (Object)modulesManager);
            this.internalCache.remove((Object)keyTuple);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ModulesKey key, AbstractModule n, ModulesManager modulesManager) {
        ModulesKeyTreeMap<ModulesKey, ModulesKey> modulesKeyTreeMap = modulesManager.modulesKeys;
        synchronized (modulesKeyTreeMap) {
            Tuple keyTuple = new Tuple((Object)key, (Object)modulesManager);
            this.internalCache.add((Object)keyTuple, (Object)n);
        }
    }
}

