/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdb.XSQLQueryComposerFactory;
import com.sun.star.sdb.XSingleSelectQueryAnalyzer;
import com.sun.star.sdb.XSingleSelectQueryComposer;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbcx.XColumnsSupplier;
import com.sun.star.ui.dialogs.XExecutableDialog;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.Properties;
import com.sun.star.wizards.db.CommandName;
import com.sun.star.wizards.db.FieldColumn;
import com.sun.star.wizards.db.QueryMetaData;
import java.util.Vector;

public class SQLQueryComposer {
    public XColumnsSupplier xColSuppl;
    QueryMetaData CurDBMetaData;
    public XSingleSelectQueryAnalyzer m_xQueryAnalyzer;
    Vector composedCommandNames = new Vector(1);
    private XSingleSelectQueryComposer m_queryComposer;
    XMultiServiceFactory xMSF;
    boolean bincludeGrouping = true;

    public SQLQueryComposer(QueryMetaData queryMetaData) {
        try {
            this.CurDBMetaData = queryMetaData;
            this.xMSF = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.CurDBMetaData.DBConnection);
            Object object = this.xMSF.createInstance("com.sun.star.sdb.SingleSelectQueryComposer");
            this.m_xQueryAnalyzer = (XSingleSelectQueryAnalyzer)UnoRuntime.queryInterface(XSingleSelectQueryAnalyzer.class, (Object)object);
            this.m_queryComposer = (XSingleSelectQueryComposer)UnoRuntime.queryInterface(XSingleSelectQueryComposer.class, (Object)this.m_xQueryAnalyzer);
            XSQLQueryComposerFactory xSQLQueryComposerFactory = (XSQLQueryComposerFactory)UnoRuntime.queryInterface(XSQLQueryComposerFactory.class, (Object)this.CurDBMetaData.DBConnection);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private boolean addtoSelectClause(String string) throws SQLException {
        return !this.bincludeGrouping || !this.CurDBMetaData.xDBMetaData.supportsGroupByUnrelated() || this.CurDBMetaData.GroupFieldNames == null || JavaTools.FieldInList(this.CurDBMetaData.GroupFieldNames, string) <= -1;
    }

    public String getSelectClause(boolean bl) throws SQLException {
        String string;
        String string2 = string = "SELECT ";
        for (int i = 0; i < this.CurDBMetaData.FieldColumns.length; ++i) {
            if (!this.addtoSelectClause(this.CurDBMetaData.FieldColumns[i].getDisplayFieldName())) continue;
            int n = this.CurDBMetaData.getAggregateIndex(this.CurDBMetaData.FieldColumns[i].getDisplayFieldName());
            if (n > -1) {
                string2 = string2 + this.CurDBMetaData.AggregateFieldNames[n][1] + "(" + this.getComposedAliasFieldName(this.CurDBMetaData.AggregateFieldNames[n][0]) + ")";
                if (bl) {
                    string2 = string2 + this.getAliasFieldNameClause(this.CurDBMetaData.AggregateFieldNames[n][0]);
                }
            } else {
                string2 = string2 + this.getComposedAliasFieldName(this.CurDBMetaData.FieldColumns[i].getDisplayFieldName());
                if (bl) {
                    string2 = string2 + this.getAliasFieldNameClause(this.CurDBMetaData.FieldColumns[i].getDisplayFieldName());
                }
            }
            string2 = string2 + ", ";
        }
        string2 = string2.equals(string) ? string2.substring(0, string2.length() - 1) : string2.substring(0, string2.length() - 2);
        return string2;
    }

    public String getAliasFieldNameClause(String string) {
        String string2 = this.CurDBMetaData.getFieldTitle(string);
        if (!string2.equals(string)) {
            return " AS " + CommandName.quoteName(string2, this.CurDBMetaData.getIdentifierQuote());
        }
        return "";
    }

    public void appendFilterConditions() throws SQLException {
        try {
            for (int i = 0; i < this.CurDBMetaData.getFilterConditions().length; ++i) {
                this.m_queryComposer.setStructuredFilter(this.CurDBMetaData.getFilterConditions());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void prependSortingCriteria() throws SQLException {
        int n;
        XIndexAccess xIndexAccess = this.m_xQueryAnalyzer.getOrderColumns();
        this.m_queryComposer.setOrder("");
        for (n = 0; n < this.CurDBMetaData.getSortFieldNames().length; ++n) {
            this.appendSortingCriterion(n, false);
        }
        for (n = 0; n < xIndexAccess.getCount(); ++n) {
            try {
                XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xIndexAccess.getByIndex(n));
                String string = (String)xPropertySet.getPropertyValue("Name");
                if (JavaTools.FieldInTable(this.CurDBMetaData.getSortFieldNames(), string) != -1) continue;
                boolean bl = AnyConverter.toBoolean((Object)xPropertySet.getPropertyValue("IsAscending"));
                this.m_queryComposer.appendOrderByColumn(xPropertySet, bl);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        }
    }

    private void appendSortingCriterion(int n, boolean bl) throws SQLException {
        String string = this.CurDBMetaData.getSortFieldNames()[n][0];
        XPropertySet xPropertySet = this.CurDBMetaData.getColumnObjectByFieldName(string, bl);
        String string2 = this.CurDBMetaData.getSortFieldNames()[n][1];
        boolean bl2 = string2.equals("ASC");
        this.m_queryComposer.appendOrderByColumn(xPropertySet, bl2);
    }

    public void appendSortingcriteria(boolean bl) throws SQLException {
        int n;
        String string = "";
        this.m_queryComposer.setOrder("");
        for (n = 0; n < this.CurDBMetaData.getSortFieldNames().length; ++n) {
            String string2 = this.CurDBMetaData.getSortFieldNames()[n][0];
            int n2 = this.CurDBMetaData.getAggregateIndex(string2);
            if (n2 > -1) {
                string = this.m_xQueryAnalyzer.getOrder();
                if (string.length() > 0) {
                    string = string + ", ";
                }
                string = string + this.CurDBMetaData.AggregateFieldNames[n2][1] + "(" + this.CurDBMetaData.AggregateFieldNames[n2][0] + ")";
                string = string + " " + this.CurDBMetaData.getSortFieldNames()[n][1];
                this.m_queryComposer.setOrder(string);
            } else {
                this.appendSortingCriterion(n, bl);
            }
            string = this.m_xQueryAnalyzer.getOrder();
        }
        string = this.m_queryComposer.getOrder();
        n = 0;
    }

    public void appendGroupByColumns(boolean bl) throws SQLException {
        for (int i = 0; i < this.CurDBMetaData.GroupFieldNames.length; ++i) {
            XPropertySet xPropertySet = this.CurDBMetaData.getColumnObjectByFieldName(this.CurDBMetaData.GroupFieldNames[i], bl);
            this.m_queryComposer.appendGroupByColumn(xPropertySet);
        }
        String string = this.m_xQueryAnalyzer.getQuery();
    }

    public void setDBMetaData(QueryMetaData queryMetaData) {
        this.CurDBMetaData = queryMetaData;
    }

    private PropertyValue[][] replaceConditionsByAlias(PropertyValue[][] propertyValueArray) {
        for (int i = 0; i < propertyValueArray.length; ++i) {
            for (int j = 0; j < propertyValueArray[i].length; ++j) {
                propertyValueArray[i][j].Name = this.getComposedAliasFieldName(propertyValueArray[i][j].Name);
            }
        }
        return propertyValueArray;
    }

    public String getQuery() {
        return this.m_xQueryAnalyzer.getQuery();
    }

    public String getFromClause() {
        String string = "FROM";
        this.composedCommandNames.clear();
        String[] stringArray = this.CurDBMetaData.getIncludedCommandNames();
        for (int i = 0; i < stringArray.length; ++i) {
            CommandName commandName = new CommandName(this.CurDBMetaData, stringArray[i]);
            commandName.setAliasName(this.getuniqueAliasName(commandName.getTableName()));
            string = string + " " + commandName.getComposedName() + " " + this.quoteName(commandName.getAliasName());
            if (i < stringArray.length - 1) {
                string = string + ", ";
            }
            this.composedCommandNames.add(commandName);
        }
        return string;
    }

    public boolean setQueryCommand(XWindow xWindow, boolean bl, boolean bl2) {
        return this.setQueryCommand(xWindow, bl, bl2, true);
    }

    public boolean setQueryCommand(XWindow xWindow, boolean bl, boolean bl2, boolean bl3) {
        try {
            this.bincludeGrouping = bl;
            if (bl3) {
                String string = this.getFromClause();
                String string2 = this.getSelectClause(bl2);
                String string3 = string2 + " " + string;
                this.m_xQueryAnalyzer.setQuery(string3);
                if (this.CurDBMetaData.getFilterConditions() != null && this.CurDBMetaData.getFilterConditions().length > 0) {
                    this.CurDBMetaData.setFilterConditions(this.replaceConditionsByAlias(this.CurDBMetaData.getFilterConditions()));
                    this.m_queryComposer.setStructuredFilter(this.CurDBMetaData.getFilterConditions());
                }
            }
            String string = this.m_xQueryAnalyzer.getQuery();
            if (bl) {
                this.appendGroupByColumns(bl2);
                if (this.CurDBMetaData.GroupByFilterConditions.length > 0) {
                    this.m_queryComposer.setStructuredHavingClause(this.CurDBMetaData.GroupByFilterConditions);
                }
            }
            this.appendSortingcriteria(bl2);
            string = this.m_xQueryAnalyzer.getQuery();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            this.displaySQLErrorDialog(exception, xWindow);
            return false;
        }
    }

    private String getComposedAliasFieldName(String string) {
        FieldColumn fieldColumn = this.CurDBMetaData.getFieldColumnByDisplayName(string);
        CommandName commandName = this.getComposedCommandByDisplayName(fieldColumn.getCommandName());
        if (commandName == null) {
            return string;
        }
        String string2 = commandName.getAliasName();
        return this.quoteName(string2) + "." + this.quoteName(fieldColumn.getFieldName());
    }

    private CommandName getComposedCommandByAliasName(String string) {
        if (this.composedCommandNames != null) {
            for (int i = 0; i < this.composedCommandNames.size(); ++i) {
                CommandName commandName = (CommandName)this.composedCommandNames.elementAt(i);
                if (!commandName.getAliasName().equals(string)) continue;
                return commandName;
            }
        }
        return null;
    }

    public CommandName getComposedCommandByDisplayName(String string) {
        if (this.composedCommandNames != null) {
            for (int i = 0; i < this.composedCommandNames.size(); ++i) {
                CommandName commandName = (CommandName)this.composedCommandNames.elementAt(i);
                if (!commandName.getDisplayName().equals(string)) continue;
                return commandName;
            }
        }
        return null;
    }

    public String getuniqueAliasName(String string) {
        int n = 0;
        String string2 = "";
        boolean bl = true;
        String string3 = string;
        while (bl) {
            boolean bl2 = bl = this.getComposedCommandByAliasName(string3) != null;
            if (bl) {
                string3 = string + "_" + String.valueOf(++n);
                continue;
            }
            string2 = string3;
        }
        return string2;
    }

    private String quoteName(String string) {
        return CommandName.quoteName(string, this.CurDBMetaData.getIdentifierQuote());
    }

    public void displaySQLErrorDialog(Exception exception, XWindow xWindow) {
        try {
            Object object = this.CurDBMetaData.xMSF.createInstance("com.sun.star.sdb.ErrorMessageDialog");
            XInitialization xInitialization = (XInitialization)UnoRuntime.queryInterface(XInitialization.class, (Object)object);
            XExecutableDialog xExecutableDialog = (XExecutableDialog)UnoRuntime.queryInterface(XExecutableDialog.class, (Object)object);
            Object[] objectArray = new PropertyValue[]{Properties.createProperty("Title", Configuration.getProductName(this.CurDBMetaData.xMSF) + " Base"), Properties.createProperty("ParentWindow", xWindow), Properties.createProperty("SQLException", (Object)exception)};
            xInitialization.initialize(objectArray);
            xExecutableDialog.execute();
        }
        catch (Exception exception2) {
            exception2.printStackTrace(System.out);
        }
    }

    public PropertyValue[][] getNormalizedStructuredFilter() {
        PropertyValue[][] propertyValueArray = this.m_queryComposer.getStructuredFilter();
        for (int i = 0; i < propertyValueArray.length; ++i) {
            for (int j = 0; j < propertyValueArray[i].length; ++j) {
                if (!(propertyValueArray[i][j].Value instanceof String)) continue;
                StringBuffer stringBuffer = new StringBuffer((String)propertyValueArray[i][j].Value);
                switch (propertyValueArray[i][j].Handle) {
                    case 1: {
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 6: {
                        stringBuffer.delete(0, 2);
                        break;
                    }
                    case 3: 
                    case 4: {
                        stringBuffer.delete(0, 1);
                        break;
                    }
                    case 8: {
                        stringBuffer.delete(0, 8);
                        break;
                    }
                    case 7: {
                        stringBuffer.delete(0, 4);
                        break;
                    }
                    case 9: {
                        stringBuffer.delete(0, 7);
                        break;
                    }
                    case 10: {
                        stringBuffer.delete(0, 11);
                    }
                }
                propertyValueArray[i][j].Value = stringBuffer.toString().trim();
            }
        }
        return propertyValueArray;
    }

    public XSingleSelectQueryComposer getQueryComposer() {
        return this.m_queryComposer;
    }
}

