/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.platform.nsicom;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.netbeans.modules.j2me.cdc.platform.CDCDevice;
import org.netbeans.modules.j2me.cdc.platform.CDCPlatform;
import org.netbeans.modules.j2me.cdc.platform.spi.CDCPlatformDetector;
import org.netbeans.modules.j2me.cdc.platform.spi.CDCPlatformUtil;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Utilities;

public class NSIcomPlatformDetector
extends CDCPlatformDetector {
    private static Set propertiesToFix = new HashSet();

    public String getPlatformName() {
        return "NSIcom";
    }

    public String getPlatformType() {
        return "nsicom";
    }

    public boolean accept(FileObject dir) {
        FileObject tool = CDCPlatformUtil.findTool((String)"bin", (String)"pJSCP", Collections.singleton(dir));
        return tool != null;
    }

    public CDCPlatform detectPlatform(FileObject dir) throws IOException {
        assert (dir != null);
        FileObject java = CDCPlatformUtil.findTool((String)"bin", (String)"pJSCP", Collections.singleton(dir));
        if (java == null) {
            throw new IOException("pJSCP.exe can not be found in desired location!");
        }
        File javaFile = FileUtil.toFile((FileObject)java);
        if (javaFile == null) {
            throw new IOException("pJSCP.exe can not be found in desired location!");
        }
        String javapath = javaFile.getAbsolutePath();
        FileObject bin = dir.getFileObject("bin");
        String filePath = File.createTempFile("nb-cdcplatformdetect", "properties").getAbsolutePath();
        this.getSDKProperties(javapath, filePath);
        File f = new File(filePath);
        Properties p = new Properties();
        FileInputStream is = new FileInputStream(f);
        p.load(is);
        HashMap<String, String> m = new HashMap<String, String>(p.size());
        Enumeration<Object> en = p.keys();
        while (en.hasMoreElements()) {
            String k = (String)en.nextElement();
            String v = p.getProperty(k);
            v = this.fixSymLinks(dir, k, v);
            m.put(k, v);
        }
        ((InputStream)is).close();
        f.delete();
        String name = (String)m.get("java.vm.version");
        assert (name != null) : "Platform name is null";
        String bcp = (String)m.get("sun.boot.class.path");
        assert (bcp != null) : "Boot classpath is null";
        HashMap<String, Object> modes = new HashMap<String, Object>();
        modes.put(CDCPlatform.PROP_EXEC_MAIN, null);
        modes.put(CDCPlatform.PROP_EXEC_APPLET, null);
        CDCDevice.CDCProfile profile = new CDCDevice.CDCProfile("PP-1.0", "NSIcom CDC-1.0 PP-1.0", "1.0", modes, bcp, null, true);
        CDCDevice device = new CDCDevice();
        device.setProfiles(new CDCDevice.CDCProfile[]{profile});
        return new CDCPlatform(name, name, this.getPlatformType(), "1.3", Collections.singletonList(dir.getURL()), Collections.EMPTY_LIST, Collections.EMPTY_LIST, new CDCDevice[]{device}, true);
    }

    public int getVersion() {
        return 1;
    }

    private String fixSymLinks(FileObject dir, String key, String value) {
        if (Utilities.isUnix() && propertiesToFix.contains(key)) {
            try {
                String canonicalPath;
                String path;
                String[] pathElements = value.split(File.pathSeparator);
                boolean changed = false;
                File f = FileUtil.toFile((FileObject)dir);
                if (f != null && !(path = f.getAbsolutePath()).equals(canonicalPath = f.getCanonicalPath())) {
                    for (int i = 0; i < pathElements.length; ++i) {
                        if (!pathElements[i].startsWith(canonicalPath)) continue;
                        pathElements[i] = path + pathElements[i].substring(canonicalPath.length());
                        changed = true;
                    }
                }
                if (changed) {
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < pathElements.length; ++i) {
                        if (i > 0) {
                            sb.append(File.pathSeparatorChar);
                        }
                        sb.append(pathElements[i]);
                    }
                    return sb.toString();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return value;
    }

    private void getSDKProperties(String javaPath, String path) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        try {
            String[] command = new String[]{javaPath, "-classpath", InstalledFileLocator.getDefault().locate("modules/ext/org-netbeans-modules-j2me-cdc-platform-nsicom-probe.jar", "org.netbeans.modules.java.j2seplatform", false).getAbsolutePath(), "org.netbeans.modules.j2me.cdc.platform.nsicom.wizard.SDKProbe", path};
            Process process = runtime.exec(command);
            process.waitFor();
            int exitValue = process.exitValue();
            if (exitValue != 0) {
                throw new IOException();
            }
        }
        catch (InterruptedException ex) {
            IOException e = new IOException();
            ErrorManager.getDefault().annotate((Throwable)e, (Throwable)ex);
            throw e;
        }
    }

    static {
        propertiesToFix.add("sun.boot.class.path");
        propertiesToFix.add("sun.boot.library.path");
        propertiesToFix.add("java.library.path");
        propertiesToFix.add("java.ext.dirs");
        propertiesToFix.add("java.home");
    }
}

