/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.log.HgLogMessageChangedPath;

public class RepositoryRevision {
    private HgLogMessage message;
    private File repositoryRoot;
    private final List<Event> events = new ArrayList<Event>(1);

    public RepositoryRevision(HgLogMessage message, File root) {
        this.message = message;
        this.repositoryRoot = root;
        this.initEvents();
    }

    public File getRepositoryRoot() {
        return this.repositoryRoot;
    }

    private void initEvents() {
        HgLogMessageChangedPath[] paths = this.message.getChangedPaths();
        if (paths == null) {
            return;
        }
        for (HgLogMessageChangedPath path : paths) {
            this.events.add(new Event(path));
        }
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public HgLogMessage getLog() {
        return this.message;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append(this.getLog().getRevision());
        text.append("\t");
        text.append(this.getLog().getCSetShortID());
        text.append("\t");
        text.append(this.getLog().getDate());
        text.append("\t");
        text.append(this.getLog().getAuthor());
        text.append("\n");
        text.append(this.getLog().getMessage());
        return text.toString();
    }

    public class Event {
        private File file;
        private HgLogMessageChangedPath changedPath;
        private String name;
        private String path;

        public Event(HgLogMessageChangedPath changedPath) {
            this.changedPath = changedPath;
            this.name = changedPath.getPath().substring(changedPath.getPath().lastIndexOf(47) + 1);
            int indexPath = changedPath.getPath().lastIndexOf(47);
            this.path = indexPath > -1 ? changedPath.getPath().substring(0, indexPath) : "";
        }

        public RepositoryRevision getLogInfoHeader() {
            return RepositoryRevision.this;
        }

        public HgLogMessageChangedPath getChangedPath() {
            return this.changedPath;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public String toString() {
            StringBuffer text = new StringBuffer();
            text.append("\t");
            text.append(this.getPath());
            return text.toString();
        }
    }
}

