/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.security;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.text.DateFormat;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import org.netbeans.modules.mobility.project.security.KeyStoreRepository;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class KeyAliasCellRenderer
extends DefaultListCellRenderer {
    private static final Image key = ImageUtilities.loadImage((String)"org/netbeans/modules/mobility/project/ui/resources/key.gif");
    private static final Icon ICON_OPENED = new ImageIcon(ImageUtilities.mergeImages((Image)key, (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/mobility/project/ui/resources/unlockedBadge.gif"), (int)0, (int)0));
    private static final Icon ICON_CLOSED = new ImageIcon(ImageUtilities.mergeImages((Image)key, (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/mobility/project/ui/resources/lockedBadge.gif"), (int)0, (int)0));
    private static final Icon ICON_INVALID = new ImageIcon(ImageUtilities.mergeImages((Image)key, (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/mobility/project/ui/resources/invalidBadge.gif"), (int)0, (int)0));
    public static final String notAvailableString = NbBundle.getMessage(KeyAliasCellRenderer.class, (String)"LBL_NotAvailable");
    public static final String invalidKeyAliasString = NbBundle.getMessage(KeyAliasCellRenderer.class, (String)"LBL_InvalidKeyAlias");
    public static final String keyAliasNotUnlockString = NbBundle.getMessage(KeyAliasCellRenderer.class, (String)"LBL_KeyAliasNotUnlock");
    public static final String subjectString = NbBundle.getMessage(KeyAliasCellRenderer.class, (String)"LBL_Subject");
    public static final String issuerString = NbBundle.getMessage(KeyAliasCellRenderer.class, (String)"LBL_Issuer");
    public static final String validString = NbBundle.getMessage(KeyAliasCellRenderer.class, (String)"LBL_Valid");
    public static final DateFormat format = DateFormat.getDateInstance(2);
    private boolean showDetails = false;

    public void setShowDetails(boolean showDetails) {
        this.showDetails = showDetails;
        this.firePropertyChange("text", null, null);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof KeyStoreRepository.KeyStoreBean.KeyAliasBean) {
            this.setVerticalAlignment(1);
            KeyStoreRepository.KeyStoreBean.KeyAliasBean alias = (KeyStoreRepository.KeyStoreBean.KeyAliasBean)value;
            super.getListCellRendererComponent((JList<?>)list, this.showDetails ? KeyAliasCellRenderer.getHtmlFormattedText(alias, isSelected ? list.getSelectionForeground() : list.getForeground()) : alias.getAlias(), index, isSelected, cellHasFocus);
            this.setIcon(alias.isValid() ? (alias.isOpened() ? ICON_OPENED : ICON_CLOSED) : ICON_INVALID);
        } else {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setIcon(null);
        }
        return this;
    }

    public static String getHtmlFormattedText(KeyStoreRepository.KeyStoreBean.KeyAliasBean alias) {
        return KeyAliasCellRenderer.getHtmlFormattedText(alias, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHtmlFormattedText(KeyStoreRepository.KeyStoreBean.KeyAliasBean alias, Color color) {
        String head;
        if (alias == null) {
            return notAvailableString;
        }
        String string = head = color == null ? "<html><b>" : "<html><font color=\"#" + Integer.toHexString(color.getRGB() & 0xFFFFFF) + "\"><b>";
        if (!alias.isValid()) {
            return head + alias.getAlias() + "</b><br>" + invalidKeyAliasString;
        }
        if (!alias.isOpened()) {
            return head + alias.getAlias() + "</b><br>" + keyAliasNotUnlockString;
        }
        String form1 = null;
        String form2 = null;
        DateFormat dateFormat = format;
        synchronized (dateFormat) {
            form1 = format.format(alias.getNotBefore());
            form2 = format.format(alias.getNotAfter());
        }
        return head + alias.getAlias() + "</b><br>" + "<i>" + subjectString + ":</i> " + alias.getSubjectName() + "<br>" + "<i>" + issuerString + ":</i> " + alias.getIssuerName() + "<br>" + "<i>" + validString + ":</i> " + form1 + " - " + form2;
    }
}

