/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectOptions;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.ui.MakeArtifactChooser;
import org.netbeans.modules.cnd.makeproject.configurations.ui.TableEditorPanel;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class RequiredProjectsPanel
extends JPanel
implements HelpCtx.Provider,
PropertyChangeListener {
    private Project project;
    private MakeConfiguration conf;
    private MyListEditorPanel myListEditorPanel;
    private String baseDir;
    private PropertyEditorSupport editor;
    private JButton addProjectButton;
    private JButton addStandardLibraryButton;
    private JButton addLibraryButton;
    private JButton addLibraryFileButton;
    private JButton addLibraryOption;
    private JPanel instructionPanel;
    private JTextArea instructionsTextArea;
    private JPanel outerPanel;
    private static ResourceBundle bundle;

    public RequiredProjectsPanel(Project project, MakeConfiguration conf, String baseDir, List<LibraryItem> data, PropertyEditorSupport editor, PropertyEnv env) {
        this.project = project;
        this.conf = conf;
        this.baseDir = baseDir;
        this.editor = editor;
        this.initComponents();
        this.addProjectButton = new JButton(RequiredProjectsPanel.getString("ADD_PROJECTS_BUTTON_TXT"));
        this.addProjectButton.setToolTipText(RequiredProjectsPanel.getString("ADD_PROJECTS_BUTTON_TT"));
        this.addProjectButton.setMnemonic(RequiredProjectsPanel.getString("ADD_PROJECTS_BUTTON_MN").charAt(0));
        JButton[] extraButtons = new JButton[]{this.addProjectButton};
        this.myListEditorPanel = new MyListEditorPanel(data, extraButtons);
        this.addProjectButton.addActionListener(new AddProjectButtonAction());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.outerPanel.add((Component)((Object)this.myListEditorPanel), gridBagConstraints);
        this.instructionsTextArea.setBackground(this.instructionPanel.getBackground());
        this.setPreferredSize(new Dimension(700, 350));
        env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        env.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void setInstructionsText(String txt) {
        this.instructionsTextArea.setText(txt);
    }

    public void setListData(List<LibraryItem> data) {
        this.myListEditorPanel.setListData(data);
    }

    public List<LibraryItem> getListData() {
        return this.myListEditorPanel.getListData();
    }

    private Object getPropertyValue() throws IllegalStateException {
        return new ArrayList<LibraryItem>(this.getListData());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID) {
            this.editor.setValue(this.getPropertyValue());
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("RequiredProjects");
    }

    private void initComponents() {
        this.outerPanel = new JPanel();
        this.instructionPanel = new JPanel();
        this.instructionsTextArea = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(323, 223));
        this.outerPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.outerPanel, gridBagConstraints);
        this.instructionPanel.setLayout(new GridBagLayout());
        this.instructionsTextArea.setEditable(false);
        this.instructionsTextArea.setLineWrap(true);
        this.instructionsTextArea.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.instructionPanel.add((Component)this.instructionsTextArea, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 12, 0, 12);
        this.add((Component)this.instructionPanel, gridBagConstraints);
    }

    private static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(RequiredProjectsPanel.class);
        }
        return bundle.getString(s);
    }

    private class AddProjectButtonAction
    implements ActionListener {
        private AddProjectButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            MakeArtifact[] artifacts = MakeArtifactChooser.showDialog(MakeArtifactChooser.ArtifactType.PROJECT, RequiredProjectsPanel.this.project, (Component)((Object)RequiredProjectsPanel.this.myListEditorPanel));
            if (artifacts != null) {
                for (int i = 0; i < artifacts.length; ++i) {
                    String workingdir;
                    String location;
                    if (MakeProjectOptions.getPathMode() == 0) {
                        location = CndPathUtilitities.toAbsoluteOrRelativePath((String)RequiredProjectsPanel.this.baseDir, (String)artifacts[i].getProjectLocation());
                        workingdir = CndPathUtilitities.toAbsoluteOrRelativePath((String)RequiredProjectsPanel.this.baseDir, (String)artifacts[i].getWorkingDirectory());
                    } else if (MakeProjectOptions.getPathMode() == 1) {
                        location = CndPathUtilitities.toRelativePath((String)RequiredProjectsPanel.this.baseDir, (String)artifacts[i].getProjectLocation());
                        workingdir = CndPathUtilitities.toRelativePath((String)RequiredProjectsPanel.this.baseDir, (String)artifacts[i].getWorkingDirectory());
                    } else {
                        location = artifacts[i].getProjectLocation();
                        workingdir = artifacts[i].getWorkingDirectory();
                    }
                    location = CndPathUtilitities.normalize((String)location);
                    workingdir = CndPathUtilitities.normalize((String)workingdir);
                    artifacts[i].setProjectLocation(location);
                    artifacts[i].setWorkingDirectory(workingdir);
                    artifacts[i].setBuild(false);
                    RequiredProjectsPanel.this.myListEditorPanel.addObjectAction(new LibraryItem.ProjectItem(artifacts[i]));
                }
            }
        }
    }

    private class MyListEditorPanel
    extends TableEditorPanel {
        public MyListEditorPanel(List<LibraryItem> objects, JButton[] extraButtons) {
            super(objects, extraButtons, RequiredProjectsPanel.this.baseDir);
            this.getAddButton().setVisible(false);
            this.getCopyButton().setVisible(false);
            this.getEditButton().setVisible(false);
            this.getDefaultButton().setVisible(false);
        }

        public String getListLabelText() {
            return RequiredProjectsPanel.getString("PROJECTS_TXT");
        }

        public char getListLabelMnemonic() {
            return RequiredProjectsPanel.getString("PROJECTS_MN").charAt(0);
        }
    }
}

