/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.awt.Image;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.core.syntax.spi.JspColoringData;
import org.netbeans.modules.web.core.syntax.spi.JspContextInfo;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.netbeans.spi.jsp.lexer.JspParseData;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class JspUtils {
    public static final String TAG_MIME_TYPE = "text/x-tag";

    public static TokenHierarchy<CharSequence> createJspTokenHierarchy(Snapshot jspSnapshot) {
        InputAttributes inputAttributes = new InputAttributes();
        FileObject fo = jspSnapshot.getSource().getFileObject();
        if (fo != null) {
            JspColoringData data = JspUtils.getJSPColoringData(fo);
            if (data == null) {
                if (fo.isValid()) {
                    Logger.global.info("Cannot obtain JSPColoringData instance for file " + fo.getPath());
                }
            } else {
                JspParseData jspParseData = new JspParseData(data.getPrefixMapper(), data.isELIgnored(), data.isXMLSyntax(), data.isInitialized());
                inputAttributes.setValue(JspTokenId.language(), JspParseData.class, (Object)jspParseData, false);
            }
        }
        TokenHierarchy th = TokenHierarchy.create((CharSequence)jspSnapshot.getText(), (boolean)true, (Language)JspTokenId.language(), (Set)Collections.EMPTY_SET, (InputAttributes)inputAttributes);
        return th;
    }

    public static String getContentLanguage() {
        return "text/html";
    }

    public static String getScriptingLanguage() {
        return "text/x-java";
    }

    public static JspColoringData getJSPColoringData(FileObject fo) {
        JspContextInfo context;
        JspColoringData result = null;
        if (fo != null && fo.isValid() && (context = JspContextInfo.getContextInfo(fo)) != null) {
            result = context.getJSPColoringData(fo);
        }
        return result;
    }

    public static JspParserAPI.ParseResult getCachedParseResult(FileObject fo, boolean successfulOnly, boolean preferCurrent, boolean forceParse) {
        JspContextInfo contextInfo = JspContextInfo.getContextInfo(fo);
        if (contextInfo == null) {
            return null;
        }
        return contextInfo.getCachedParseResult(fo, successfulOnly, preferCurrent, forceParse);
    }

    public static JspParserAPI.ParseResult getCachedParseResult(FileObject fo, boolean successfulOnly, boolean preferCurrent) {
        return JspUtils.getCachedParseResult(fo, successfulOnly, preferCurrent, false);
    }

    public static URLClassLoader getModuleClassLoader(FileObject fo) {
        return JspContextInfo.getContextInfo(fo).getModuleClassLoader(fo);
    }

    public static FileObject guessWebModuleRoot(FileObject fo) {
        return JspContextInfo.getContextInfo(fo).guessWebModuleRoot(fo);
    }

    public static FileObject getFileObject(Document doc, String path) {
        FileObject fobj;
        DataObject dobj = NbEditorUtilities.getDataObject((Document)doc);
        FileObject fileObject = fobj = dobj != null ? NbEditorUtilities.getDataObject((Document)doc).getPrimaryFile() : null;
        if (fobj != null) {
            return JspUtils.getFileObject(fobj, path);
        }
        return null;
    }

    public static FileObject getFileObject(FileObject file, String path) {
        if (path == null) {
            return file;
        }
        path = path.trim();
        FileObject find = file;
        if (!file.isFolder()) {
            find = file.getParent();
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            find = JspUtils.guessWebModuleRoot(file);
            if (find == null) {
                return null;
            }
            path = path.substring(1);
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        while (find != null && st.hasMoreTokens()) {
            String token = st.nextToken();
            if ("..".equals(token)) {
                find = find.getParent();
                continue;
            }
            if (".".equals(token)) continue;
            find = find.getFileObject(token);
        }
        return find;
    }

    public static Map getTaglibMap(FileObject fo) {
        JspContextInfo jspci = JspContextInfo.getContextInfo(fo);
        return jspci == null ? null : jspci.getTaglibMap(fo);
    }

    public static Image getIcon(FileObject fo) {
        try {
            return DataObject.find((FileObject)fo).getNodeDelegate().getIcon(1);
        }
        catch (DataObjectNotFoundException e) {
            Logger.getLogger(JspUtils.class.getName()).log(Level.INFO, "Cannot find icon for " + fo.getNameExt(), e);
            return null;
        }
    }

    public static String resolveRelativeURL(String relativeTo, String url) {
        String result;
        if (url.startsWith("/")) {
            result = "/";
            url = url.substring(1);
        } else {
            if (relativeTo == null || !relativeTo.startsWith("/")) {
                throw new IllegalArgumentException();
            }
            int lastSlash = (relativeTo = JspUtils.resolveRelativeURL(null, relativeTo)).lastIndexOf(47);
            if (lastSlash == -1) {
                throw new IllegalArgumentException();
            }
            result = relativeTo.substring(0, lastSlash + 1);
        }
        StringTokenizer st = new StringTokenizer(url, "/", true);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals("/")) {
                if (result.endsWith("/")) continue;
                result = result + "/";
                continue;
            }
            if (tok.equals("") || tok.equals(".")) continue;
            if (tok.equals("..")) {
                String withoutSlash = result.substring(0, result.length() - 1);
                int ls = withoutSlash.lastIndexOf("/");
                if (ls == -1) continue;
                result = withoutSlash.substring(0, ls + 1);
                continue;
            }
            result = result + tok;
        }
        return result;
    }

    public static String mapToString(Map m, String indent) {
        StringBuffer sb = new StringBuffer();
        for (Object key : m.keySet()) {
            sb.append(indent).append(key).append(" -> ").append(m.get(key)).append("\n");
        }
        return sb.toString();
    }

    public static boolean isInSubTree(FileObject folder, FileObject fo) {
        if (fo == folder) {
            return true;
        }
        return FileUtil.isParentOf((FileObject)folder, (FileObject)fo);
    }

    public static String findRelativePath(FileObject rootFolder, FileObject relativeObject) {
        String rfp = rootFolder.getPath();
        String rop = relativeObject.getPath();
        if (!JspUtils.isInSubTree(rootFolder, relativeObject)) {
            throw new IllegalArgumentException("" + rootFolder + " / " + relativeObject);
        }
        String result = rop.substring(rfp.length());
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }

    public static String findRelativeContextPath(FileObject rootFolder, FileObject relativeObject) {
        String result = "/" + JspUtils.findRelativePath(rootFolder, relativeObject);
        return relativeObject.isFolder() ? result + "/" : result;
    }

    public static FileObject findRelativeFileObject(FileObject rootFolder, String relativePath) {
        FileObject myObj;
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        StringTokenizer st = new StringTokenizer(relativePath, "/");
        for (myObj = rootFolder; myObj != null && st.hasMoreTokens(); myObj = myObj.getFileObject(st.nextToken())) {
        }
        return myObj;
    }

    public static boolean isJspDocument(Document doc) {
        FileObject fo = DataLoadersBridge.getDefault().getFileObject(doc);
        return fo != null && (fo.getMIMEType().equals("text/x-jsp") || fo.getMIMEType().equals(TAG_MIME_TYPE));
    }
}

