/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.loaders;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.netbeans.modules.cnd.loaders.CoreElfObject;
import org.netbeans.modules.cnd.loaders.DllObject;
import org.netbeans.modules.cnd.loaders.ExeElfObject;
import org.netbeans.modules.cnd.loaders.ExeObject;
import org.netbeans.modules.cnd.loaders.OrphanedElfObject;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.UniFileLoader;
import org.openide.util.NbBundle;

public class ExeLoader
extends UniFileLoader {
    static final long serialVersionUID = -602486606840357846L;
    private static String lastMime;
    private static Reference<FileObject> lastFo;
    private static final String KNOWN_EXEFILE_TYPE = "org.netbeans.modules.cnd.ExeLoader.KNOWN_EXEFILE_TYPE";

    public ExeLoader() {
        super("org.netbeans.modules.cnd.loaders.ExeObject");
    }

    public ExeLoader(String representationClassName) {
        super(representationClassName);
    }

    protected String actionsContext() {
        return "Loaders/application/x-executable+elf/Actions/";
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage(ExeLoader.class, (String)"PROP_ExeLoader_Name");
    }

    protected FileObject findPrimaryFile(FileObject fo) {
        if (fo.isFolder()) {
            return null;
        }
        String mime = fo.getMIMEType();
        if ("application/x-elf".equals(mime)) {
            String name = fo.getNameExt();
            mime = name.equals("core") ? "application/x-core+elf" : (name.indexOf(".so.") >= 0 ? "application/x-shobj+elf" : "application/x-executable+elf");
        }
        if ("application/x-exe".equals(mime) || "application/x-exe+dll".equals(mime) || "application/x-executable+elf".equals(mime) || "application/x-core+elf".equals(mime) || "application/x-shobj+elf".equals(mime) || "application/x-object+elf".equals(mime)) {
            lastMime = mime;
            lastFo = new WeakReference<FileObject>(fo);
            return fo;
        }
        return null;
    }

    protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
        FileObject last = lastFo.get();
        String mime = primaryFile.equals(last) ? lastMime : primaryFile.getMIMEType();
        if (mime.equals("application/x-exe")) {
            return new ExeObject(primaryFile, this);
        }
        if (mime.equals("application/x-executable+elf")) {
            return new ExeElfObject(primaryFile, this);
        }
        if (mime.equals("application/x-core+elf")) {
            return new CoreElfObject(primaryFile, this);
        }
        if (mime.equals("application/x-shobj+elf")) {
            return new DllObject(primaryFile, this);
        }
        return new OrphanedElfObject(primaryFile, this);
    }
}

