/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.WeakPropertyChangeSupport;
import org.netbeans.modules.editor.lib2.search.EditorFindSupport;

public class FindSupport {
    public static final String REVERT_MAP = "revert-map";
    public static final String FIND_HISTORY_PROP = "find-history-prop";
    public static final String FIND_HISTORY_CHANGED_PROP = "find-history-changed-prop";
    static FindSupport findSupport;
    WeakPropertyChangeSupport changeSupport = new WeakPropertyChangeSupport();
    SearchPatternWrapper lastSelected;
    List historyList;

    private FindSupport() {
    }

    public static FindSupport getFindSupport() {
        if (findSupport == null) {
            findSupport = new FindSupport();
        }
        return findSupport;
    }

    public Map getDefaultFindProperties() {
        return EditorFindSupport.getInstance().createDefaultFindProperties();
    }

    public Map getFindProperties() {
        return EditorFindSupport.getInstance().getFindProperties();
    }

    public Object getFindProperty(String name) {
        return EditorFindSupport.getInstance().getFindProperty(name);
    }

    int[] getBlocks(int[] blocks, BaseDocument doc, int startPos, int endPos) throws BadLocationException {
        return EditorFindSupport.getInstance().getBlocks(blocks, (Document)doc, startPos, endPos);
    }

    public void putFindProperty(String name, Object newValue) {
        EditorFindSupport.getInstance().putFindProperty(name, newValue);
    }

    public void putFindProperties(Map propsToAdd) {
        EditorFindSupport.getInstance().putFindProperties(propsToAdd);
    }

    public void setBlockSearchHighlight(int startSelection, int endSelection) {
        EditorFindSupport.getInstance().setBlockSearchHighlight(startSelection, endSelection);
    }

    public boolean incSearch(Map props, int caretPos) {
        return EditorFindSupport.getInstance().incSearch(props, caretPos);
    }

    public void incSearchReset() {
        EditorFindSupport.getInstance().incSearchReset();
    }

    public boolean find(Map props, boolean oppositeDir) {
        return EditorFindSupport.getInstance().find(props, oppositeDir);
    }

    public int[] findInBlock(JTextComponent c, int startPos, int blockStartPos, int blockEndPos, Map props, boolean oppositeDir) throws BadLocationException {
        return EditorFindSupport.getInstance().findInBlock(c, startPos, blockStartPos, blockEndPos, props, oppositeDir);
    }

    public boolean replace(Map props, boolean oppositeDir) throws BadLocationException {
        return EditorFindSupport.getInstance().replace(props, oppositeDir);
    }

    public void replaceAll(Map props) {
        EditorFindSupport.getInstance().replaceAll(props);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        EditorFindSupport.getInstance().addPropertyChangeListener((PropertyChangeListener)new WeakPropL(l));
    }

    public synchronized void addPropertyChangeListener(String findPropertyName, PropertyChangeListener l) {
        EditorFindSupport.getInstance().addPropertyChangeListener(findPropertyName, (PropertyChangeListener)new WeakPropL(l));
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }

    void firePropertyChange(String settingName, Object oldValue, Object newValue) {
        EditorFindSupport.getInstance().firePropertyChange(settingName, oldValue, newValue);
    }

    public void setHistory(List spwList) {
        EditorFindSupport.getInstance().setHistory(spwList);
    }

    public List getHistory() {
        return EditorFindSupport.getInstance().getHistory();
    }

    public void setLastSelected(SearchPatternWrapper spw) {
        EditorFindSupport.SPW editorSpw = new EditorFindSupport.SPW(spw.getSearchExpression(), spw.isWholeWords(), spw.isMatchCase(), spw.isRegExp());
        EditorFindSupport.getInstance().setLastSelected(editorSpw);
    }

    public SearchPatternWrapper getLastSelected() {
        EditorFindSupport.SPW spw = EditorFindSupport.getInstance().getLastSelected();
        return new SearchPatternWrapper(spw.getSearchExpression(), spw.isWholeWords(), spw.isMatchCase(), spw.isRegExp());
    }

    public void addToHistory(SearchPatternWrapper spw) {
        EditorFindSupport.SPW editorSpw = new EditorFindSupport.SPW(spw.getSearchExpression(), spw.isWholeWords(), spw.isMatchCase(), spw.isRegExp());
        EditorFindSupport.getInstance().addToHistory(editorSpw);
    }

    private static final class WeakPropL
    extends WeakReference
    implements PropertyChangeListener {
        public WeakPropL(PropertyChangeListener origL) {
            super(origL);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PropertyChangeListener origL = (PropertyChangeListener)this.get();
            if (origL != null) {
                origL.propertyChange(new PropertyChangeEvent(this, evt.getPropertyName(), this.convert(evt.getOldValue()), this.convert(evt.getNewValue())));
            } else {
                EditorFindSupport.getInstance().removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private Object convert(Object o) {
            if (o instanceof EditorFindSupport.SPW) {
                EditorFindSupport.SPW spw = (EditorFindSupport.SPW)o;
                return new SearchPatternWrapper(spw.getSearchExpression(), spw.isWholeWords(), spw.isMatchCase(), spw.isRegExp());
            }
            return o;
        }
    }

    public static class SearchPatternWrapper {
        private String searchExpression;
        private boolean wholeWords;
        private boolean matchCase;
        private boolean regExp;

        public SearchPatternWrapper(String searchExpression, boolean wholeWords, boolean matchCase, boolean regExp) {
            this.searchExpression = searchExpression;
            this.wholeWords = wholeWords;
            this.matchCase = matchCase;
            this.regExp = regExp;
        }

        public String getSearchExpression() {
            return this.searchExpression;
        }

        public boolean isWholeWords() {
            return this.wholeWords;
        }

        public boolean isMatchCase() {
            return this.matchCase;
        }

        public boolean isRegExp() {
            return this.regExp;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SearchPatternWrapper)) {
                return false;
            }
            SearchPatternWrapper sp = (SearchPatternWrapper)obj;
            return this.searchExpression.equals(sp.getSearchExpression()) && this.wholeWords == sp.isWholeWords() && this.matchCase == sp.isMatchCase() && this.regExp == sp.isRegExp();
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + (this.wholeWords ? 1 : 0);
            result = 37 * result + (this.matchCase ? 1 : 0);
            result = 37 * result + (this.regExp ? 1 : 0);
            result = 37 * result + this.searchExpression.hashCode();
            return result;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("[SearchPatternWrapper:]\nsearchExpression:" + this.searchExpression);
            sb.append('\n');
            sb.append("wholeWords:");
            sb.append(this.wholeWords);
            sb.append('\n');
            sb.append("matchCase:");
            sb.append(this.matchCase);
            sb.append('\n');
            sb.append("regExp:");
            sb.append(this.regExp);
            return sb.toString();
        }
    }
}

