/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.vcs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.util.BugtrackingOwnerSupport;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.RepositoryComboSupport;
import org.netbeans.modules.bugtracking.vcs.FormatPanel;
import org.netbeans.modules.bugtracking.vcs.HookPanel;
import org.netbeans.modules.bugtracking.vcs.HookUtils;
import org.netbeans.modules.bugtracking.vcs.VCSHooksConfig;
import org.netbeans.modules.versioning.hooks.HgHook;
import org.netbeans.modules.versioning.hooks.HgHookContext;
import org.openide.util.NbBundle;

public class HgHookImpl
extends HgHook {
    private static final String[] SUPPORTED_ISSUE_INFO_VARIABLES = new String[]{"id", "summary"};
    private static final String[] SUPPORTED_REVISION_VARIABLES = new String[]{"changeset", "author", "date", "message"};
    private HookPanel panel;
    private final String name = NbBundle.getMessage(HgHookImpl.class, (String)"LBL_VCSHook");
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.bugtracking.vcshooks.HgHook");
    private static final SimpleDateFormat CC_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public HgHookContext beforeCommit(HgHookContext context) throws IOException {
        Repository selectedRepository = this.getSelectedRepository();
        if (context.getFiles().length == 0) {
            if (selectedRepository != null) {
                BugtrackingOwnerSupport.getInstance().setLooseAssociation(BugtrackingOwnerSupport.ContextType.MAIN_OR_SINGLE_PROJECT, selectedRepository);
            }
            LOG.warning("calling hg beforeCommit for zero files");
            return null;
        }
        if (selectedRepository != null) {
            BugtrackingOwnerSupport.getInstance().setFirmAssociations(context.getFiles(), selectedRepository);
        }
        File file = context.getFiles()[0];
        LOG.log(Level.FINE, "hg beforeCommit start for {0}", file);
        if (this.isLinkSelected()) {
            String msg = context.getMessage();
            VCSHooksConfig.Format format = VCSHooksConfig.getInstance().getHgIssueInfoTemplate();
            String formatString = format.getFormat();
            formatString = HookUtils.prepareFormatString(formatString, SUPPORTED_ISSUE_INFO_VARIABLES);
            Issue issue = this.getIssue();
            if (issue == null) {
                LOG.log(Level.FINE, " no issue set for {0}", file);
                return null;
            }
            String issueInfo = new MessageFormat(formatString).format(new Object[]{issue.getID(), issue.getSummary()}, new StringBuffer(), (FieldPosition)null).toString();
            LOG.log(Level.FINER, " hg commit hook issue info ''{0}''", issueInfo);
            msg = format.isAbove() ? issueInfo + "\n" + msg : msg + "\n" + issueInfo;
            context = new HgHookContext(context.getFiles(), msg, context.getLogEntries());
            return context;
        }
        return super.beforeCommit(context);
    }

    public void afterCommit(HgHookContext context) {
        if (this.panel == null) {
            LOG.fine("no settings for afterCommit");
            return;
        }
        if (context.getFiles().length == 0) {
            LOG.warning("calling hg afterCommit for zero files");
            return;
        }
        File file = context.getFiles()[0];
        LOG.log(Level.FINE, "hg afterCommit start for {0}", file);
        Issue issue = this.getIssue();
        if (issue == null) {
            LOG.log(Level.FINE, " no issue set for {0}", file);
            return;
        }
        VCSHooksConfig.getInstance().setHgLink(this.isLinkSelected());
        VCSHooksConfig.getInstance().setHgResolve(this.isResolveSelected());
        VCSHooksConfig.getInstance().setHgAfterCommit(this.isCommitSelected());
        if (!this.isLinkSelected() && !this.isResolveSelected()) {
            LOG.log(Level.FINER, " nothing to do in hg afterCommit for {0}", file);
            return;
        }
        String msg = null;
        if (this.isLinkSelected()) {
            String author = context.getLogEntries()[0].getAuthor();
            String changeset = context.getLogEntries()[0].getChangeset();
            Date date = context.getLogEntries()[0].getDate();
            String message = context.getLogEntries()[0].getMessage();
            String formatString = VCSHooksConfig.getInstance().getHgRevisionTemplate().getFormat();
            formatString = HookUtils.prepareFormatString(formatString, SUPPORTED_REVISION_VARIABLES);
            msg = new MessageFormat(formatString).format(new Object[]{changeset, author, date != null ? CC_DATE_FORMAT.format(date) : "", message}, new StringBuffer(), (FieldPosition)null).toString();
            LOG.log(Level.FINER, " hg afterCommit message ''{0}''", msg);
        }
        if (this.isCommitSelected()) {
            issue.addComment(msg, this.isResolveSelected());
            issue.open();
        } else {
            VCSHooksConfig.getInstance().setHgPushAction(context.getLogEntries()[0].getChangeset(), new VCSHooksConfig.PushOperation(issue.getID(), msg, this.isResolveSelected()));
            LOG.log(Level.FINE, "schedulig issue {0} for file {1}", new Object[]{issue.getID(), file});
        }
        LOG.log(Level.FINE, "hg afterCommit end for {0}", file);
        VCSHooksConfig.logHookUsage("HG", this.getSelectedRepository());
    }

    public HgHookContext beforePush(HgHookContext context) throws IOException {
        return super.beforePush(context);
    }

    public void afterPush(HgHookContext context) {
        HgHookContext.LogEntry[] entries;
        if (context.getFiles().length == 0) {
            LOG.warning("calling after push for zero files");
            return;
        }
        File file = context.getFiles()[0];
        LOG.log(Level.FINE, "push hook start for {0}", file);
        Repository repo = null;
        for (HgHookContext.LogEntry logEntry : entries = context.getLogEntries()) {
            VCSHooksConfig.PushOperation operation = VCSHooksConfig.getInstance().popHGPushAction(logEntry.getChangeset());
            if (operation == null) {
                LOG.log(Level.FINE, " no push hook scheduled for {0}", file);
                continue;
            }
            if (repo == null && (repo = BugtrackingOwnerSupport.getInstance().getRepository(file, true)) == null) {
                LOG.log(Level.WARNING, " could not find issue tracker for {0}", file);
                break;
            }
            Issue issue = repo.getIssue(operation.getIssueID());
            if (issue == null) {
                LOG.log(Level.FINE, " no issue found with id {0}", operation.getIssueID());
                continue;
            }
            issue.addComment(operation.getMsg(), operation.isClose());
        }
        LOG.log(Level.FINE, "push hook end for {0}", file);
    }

    public JPanel createComponent(HgHookContext context) {
        File referenceFile;
        LOG.finer("HgHookImpl.createComponent()");
        if (context.getFiles().length == 0) {
            referenceFile = null;
            LOG.warning("creating hg hook component for zero files");
        } else {
            referenceFile = context.getFiles()[0];
        }
        this.panel = new HookPanel(VCSHooksConfig.getInstance().getHgLink(), VCSHooksConfig.getInstance().getHgResolve(), VCSHooksConfig.getInstance().getHgAfterCommit());
        if (referenceFile != null) {
            RepositoryComboSupport.setup((JComponent)((Object)this.panel), (JComboBox)this.panel.repositoryComboBox, (File)referenceFile);
        } else {
            RepositoryComboSupport.setup((JComponent)((Object)this.panel), (JComboBox)this.panel.repositoryComboBox, (boolean)false);
        }
        this.panel.changeFormatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HgHookImpl.this.onShowFormat();
            }
        });
        return this.panel;
    }

    public String getDisplayName() {
        return this.name;
    }

    private void onShowFormat() {
        FormatPanel p = new FormatPanel(VCSHooksConfig.getInstance().getHgRevisionTemplate(), VCSHooksConfig.getDefaultHgRevisionTemplate(), SUPPORTED_REVISION_VARIABLES, VCSHooksConfig.getInstance().getHgIssueInfoTemplate(), VCSHooksConfig.getDefaultIssueInfoTemplate(), SUPPORTED_ISSUE_INFO_VARIABLES);
        if (BugtrackingUtil.show((JPanel)p, (String)NbBundle.getMessage(HookPanel.class, (String)"LBL_FormatTitle"), (String)NbBundle.getMessage(HookPanel.class, (String)"LBL_OK"))) {
            VCSHooksConfig.getInstance().setHgRevisionTemplate(p.getIssueFormat());
            VCSHooksConfig.getInstance().setHgIssueInfoTemplate(p.getCommitFormat());
        }
    }

    private boolean isLinkSelected() {
        return this.panel != null && this.panel.linkCheckBox.isSelected();
    }

    private boolean isResolveSelected() {
        return this.panel != null && this.panel.resolveCheckBox.isSelected();
    }

    private boolean isCommitSelected() {
        return this.panel != null && this.panel.commitRadioButton.isSelected();
    }

    private Repository getSelectedRepository() {
        return this.panel != null ? this.panel.getSelectedRepository() : null;
    }

    private Issue getIssue() {
        return this.panel != null ? this.panel.getIssue() : null;
    }
}

