/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.struts;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.schema2beans.GraphManager;
import org.netbeans.modules.web.struts.SAXParseError;
import org.netbeans.modules.web.struts.StrutsCatalog;
import org.netbeans.modules.web.struts.StrutsConfigEditorSupport;
import org.netbeans.modules.web.struts.StrutsConfigLoader;
import org.netbeans.modules.web.struts.StrutsConfigNode;
import org.netbeans.modules.web.struts.config.model.StrutsConfig;
import org.netbeans.modules.xml.api.XmlFileEncodingQueryImpl;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class StrutsConfigDataObject
extends MultiDataObject
implements CookieSet.Factory {
    private static StrutsCatalog strutsCatalog = new StrutsCatalog();
    private boolean documentDirty = true;
    private boolean documentValid = true;
    protected boolean nodeDirty = false;
    private InputStream inputStream;
    private SAXParseError error;
    private StrutsConfig lastGoodConfig = null;
    private transient StrutsConfigEditorSupport editorSupport;
    public static final String PROP_DOC_VALID = "documentValid";

    public StrutsConfigDataObject(FileObject fileObject, StrutsConfigLoader strutsConfigLoader) throws DataObjectExistsException {
        super(fileObject, (MultiFileLoader)strutsConfigLoader);
        this.init();
    }

    private void init() {
        CookieSet cookieSet = this.getCookieSet();
        this.getCookieSet().add(StrutsConfigEditorSupport.class, (CookieSet.Factory)this);
        this.getCookieSet().assign(FileEncodingQueryImplementation.class, (Object[])new FileEncodingQueryImplementation[]{XmlFileEncodingQueryImpl.singleton()});
        InputSource inputSource = DataObjectAdapters.inputSource((DataObject)this);
        CheckXMLSupport checkXMLSupport = new CheckXMLSupport(inputSource);
        this.getCookieSet().add((Node.Cookie)checkXMLSupport);
        ValidateXMLSupport validateXMLSupport = new ValidateXMLSupport(inputSource);
        this.getCookieSet().add((Node.Cookie)validateXMLSupport);
    }

    protected synchronized Node createNodeDelegate() {
        return new StrutsConfigNode(this);
    }

    public Node.Cookie createCookie(Class clazz) {
        if (clazz.isAssignableFrom(StrutsConfigEditorSupport.class)) {
            return this.getEditorSupport();
        }
        return null;
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StrutsConfigEditorSupport getEditorSupport() {
        if (this.editorSupport == null) {
            StrutsConfigDataObject strutsConfigDataObject = this;
            synchronized (strutsConfigDataObject) {
                if (this.editorSupport == null) {
                    this.editorSupport = new StrutsConfigEditorSupport(this);
                }
            }
        }
        return this.editorSupport;
    }

    public StrutsConfig getStrutsConfig() throws IOException {
        if (this.lastGoodConfig == null) {
            this.parsingDocument();
        }
        return this.lastGoodConfig;
    }

    public StrutsConfig getStrutsConfig(boolean bl) throws IOException {
        if (bl) {
            StrutsConfig strutsConfig = this.lastGoodConfig;
            this.parsingDocument();
            if (this.lastGoodConfig == null) {
                this.lastGoodConfig = strutsConfig;
            }
        }
        return this.getStrutsConfig();
    }

    protected InputStream prepareInputSource() throws IOException {
        if (this.getEditorSupport() != null && this.getEditorSupport().isDocumentLoaded()) {
            return this.getEditorSupport().getInputStream();
        }
        return this.getPrimaryFile().getInputStream();
    }

    protected void closeInputSource() {
        InputStream inputStream = this.inputStream;
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (inputStream == this.inputStream) {
                this.inputStream = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(StrutsConfig strutsConfig) throws IOException {
        File file = FileUtil.toFile((FileObject)this.getPrimaryFile());
        FileObject fileObject = this.getPrimaryFile();
        try {
            FileLock fileLock = fileObject.lock();
            try {
                OutputStream outputStream = fileObject.getOutputStream(fileLock);
                try {
                    strutsConfig.write(outputStream);
                }
                finally {
                    outputStream.close();
                }
            }
            finally {
                fileLock.releaseLock();
            }
        }
        catch (FileAlreadyLockedException fileAlreadyLockedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parsingDocument() {
        this.error = null;
        try {
            this.error = this.updateNode(this.prepareInputSource());
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.INFO, null, exception);
            this.setDocumentValid(false);
            return;
        }
        finally {
            this.closeInputSource();
            this.documentDirty = false;
        }
        if (this.error == null) {
            this.setDocumentValid(true);
        } else {
            this.setDocumentValid(false);
        }
        this.setNodeDirty(false);
    }

    public void setDocumentValid(boolean bl) {
        if (this.documentValid != bl) {
            if (bl) {
                this.repairNode();
            }
            this.documentValid = bl;
            this.firePropertyChange(PROP_DOC_VALID, !this.documentValid ? Boolean.TRUE : Boolean.FALSE, this.documentValid ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    protected void repairNode() {
        StatusDisplayer.getDefault().setStatusText("");
    }

    private Document getDomDocument(InputStream inputStream) throws SAXParseException {
        try {
            Document document = GraphManager.createXmlDocument((InputSource)new InputSource(inputStream), (boolean)false, (EntityResolver)strutsCatalog, (ErrorHandler)new J2eeErrorHandler(this));
            return document;
        }
        catch (Exception exception) {
            throw new SAXParseException(exception.getMessage(), new LocatorImpl());
        }
    }

    protected SAXParseError updateNode(InputStream inputStream) throws IOException {
        try {
            Document document = this.getDomDocument(inputStream);
            this.lastGoodConfig = StrutsConfig.createGraph(document);
        }
        catch (SAXParseException sAXParseException) {
            return new SAXParseError(sAXParseException);
        }
        catch (SAXException sAXException) {
            throw new IOException();
        }
        return null;
    }

    public boolean isDocumentValid() {
        return this.documentValid;
    }

    public void setDocumentDirty(boolean bl) {
        this.documentDirty = bl;
    }

    public boolean isDocumentDirty() {
        return this.documentDirty;
    }

    public boolean isNodeDirty() {
        return this.nodeDirty;
    }

    public void setNodeDirty(boolean bl) {
        this.nodeDirty = bl;
    }

    CookieSet getCookieSet0() {
        return this.getCookieSet();
    }

    private void createSAXParseError(SAXParseException sAXParseException) {
        this.error = new SAXParseError(sAXParseException);
    }

    public static class J2eeErrorHandler
    implements ErrorHandler {
        private StrutsConfigDataObject dataObject;

        public J2eeErrorHandler(StrutsConfigDataObject strutsConfigDataObject) {
            this.dataObject = strutsConfigDataObject;
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            this.dataObject.createSAXParseError(sAXParseException);
            throw sAXParseException;
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.dataObject.createSAXParseError(sAXParseException);
            throw sAXParseException;
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.dataObject.createSAXParseError(sAXParseException);
            throw sAXParseException;
        }
    }
}

