/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.parser.ConflictDescriptionParser;
import org.netbeans.modules.subversion.client.parser.SvnWcUtils;
import org.openide.xml.XMLUtil;
import org.tigris.subversion.svnclientadapter.SVNConflictDescriptor;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class EntriesCache {
    private static final String SVN_THIS_DIR = "svn:this_dir";
    private static final String DELIMITER = "\f";
    static final String ATTR_TREE_CONFLICTS = "tree-conflicts";
    static String[] entryFileAttributes;
    private static final Set<String> BOOLEAN_ATTRIBUTES;
    private static final Set<String> DATE_ATTRIBUTES;
    private static final int MAX_SIZE;
    private AttributePool attributePool = new AttributePool();
    private Entries entries;
    private static EntriesCache instance;
    private WeakHashMap<String, List<ConflictDescriptionParser.ParserConflictDescriptor>> cachedConflicts = new WeakHashMap(5);

    private EntriesCache() {
    }

    static EntriesCache getInstance() {
        if (instance == null) {
            instance = new EntriesCache();
        }
        return instance;
    }

    Map<String, String> getFileAttributes(File file) throws IOException, SAXException {
        return this.getFileAttributes(file, true);
    }

    private Map<String, String> getFileAttributes(File file, boolean mergeWithParent) throws IOException, SAXException {
        File entriesFile = SvnWcUtils.getEntriesFile(file);
        if (entriesFile == null) {
            return null;
        }
        return this.getFileAttributes(entriesFile, file, mergeWithParent);
    }

    private synchronized Map<String, String> getFileAttributes(File entriesFile, File file, boolean mergeWithParent) throws IOException, SAXException {
        EntryAttributes ea = this.getEntryAttributes(entriesFile, file, mergeWithParent);
        return (Map)ea.get(file.isDirectory() ? SVN_THIS_DIR : file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getChildren(File file) throws IOException, SAXException {
        File entriesFile = SvnWcUtils.getSvnFile(file, "entries");
        String[] children = new String[]{};
        if (entriesFile != null) {
            EntriesCache entriesCache = this;
            synchronized (entriesCache) {
                EntryAttributes ea = this.getEntryAttributes(entriesFile, file, false);
                if (ea.size() > 1) {
                    children = new String[ea.size() - 1];
                    int i = 0;
                    for (String child : ea.keySet()) {
                        if (SVN_THIS_DIR.equals(child)) continue;
                        children[i++] = child;
                    }
                }
            }
        }
        return children;
    }

    private EntryAttributes getEntryAttributes(File entriesFile, File file, boolean mergeWithParent) throws IOException, SAXException {
        EntriesFile ef = (EntriesFile)this.getEntries().get(entriesFile.getAbsolutePath());
        long lastModified = entriesFile.lastModified();
        long fileLength = entriesFile.length();
        if (ef == null || ef.ts != lastModified || ef.size != fileLength) {
            EntryAttributes ea = this.getAttributesFromEntriesFile(entriesFile);
            ef = new EntriesFile(this.getMergedAttributes(ea), lastModified, fileLength);
            this.getEntries().put(entriesFile.getAbsolutePath(), ef);
        }
        boolean isDirectory = file.isDirectory();
        if (ef.attributes.get(file.getName()) == null && !isDirectory) {
            Map<String, String> attributes = this.mergeThisDirAttributes(false, file.getName(), ef.attributes);
        }
        if (isDirectory && mergeWithParent) {
            this.mergeDirWithParent((Map)ef.attributes.get(SVN_THIS_DIR), file);
        }
        return ef.attributes;
    }

    private void mergeDirWithParent(Map<String, String> folderAttributes, File folder) throws IOException, SAXException {
        Map<String, String> parentAttributes = this.getFileAttributes(folder.getParentFile(), false);
        if (parentAttributes != null) {
            String treeConflicts = parentAttributes.get(ATTR_TREE_CONFLICTS);
            String fileName = folder.getName();
            SVNConflictDescriptor desc = this.getConflictDescriptor(fileName, treeConflicts);
            if (desc != null) {
                folderAttributes.put("is-in-conflict", treeConflicts);
            } else {
                folderAttributes.remove("is-in-conflict");
            }
        }
    }

    private EntryAttributes getMergedAttributes(EntryAttributes ea) throws SAXException {
        for (String fileName : ea.keySet()) {
            String kind = (String)((Map)ea.get(fileName)).get("kind");
            if (kind == null) {
                Subversion.LOG.log(Level.INFO, "File " + fileName + " is missing - metadata: " + ea.get(fileName));
                Subversion.LOG.log(Level.WARNING, "File " + fileName + " probably does not exist on the hard drive, please check your working copy.");
                kind = "file";
                ((Map)ea.get(fileName)).put("kind", kind);
            }
            boolean isDirectory = kind.equals("dir");
            Map<String, String> attributes = this.mergeThisDirAttributes(isDirectory, fileName, ea);
            if (isDirectory) {
                attributes.put("handled", ((Map)ea.get(SVN_THIS_DIR)).get("deleted") == null ? "true" : "false");
                continue;
            }
            if (ea.get(fileName) != null) {
                for (Map.Entry entry : ((Map)ea.get(fileName)).entrySet()) {
                    attributes.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            attributes.put("handled", ea.containsKey(fileName) && ea.get("deleted") == null ? "true" : "false");
        }
        return ea;
    }

    private Map<String, String> mergeThisDirAttributes(boolean isDirectory, String fileName, EntryAttributes ea) {
        HashMap<String, String> attributes = (HashMap<String, String>)ea.get(fileName);
        if (attributes == null) {
            attributes = new HashMap<String, String>();
            ea.put(fileName, attributes);
        }
        for (Map.Entry entry : ((Map)ea.get(SVN_THIS_DIR)).entrySet()) {
            SVNConflictDescriptor desc;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if ("is-in-conflict".equals(key)) continue;
            if (isDirectory) {
                attributes.put(key, value);
                continue;
            }
            if (key.equals("url")) {
                if (attributes.get(key) != null) continue;
                attributes.put(key, value + "/" + fileName);
                continue;
            }
            if (key.equals("uuid") || key.equals("repos") || key.equals("revision") || key.equals("wc-version")) {
                if (attributes.get(key) != null) continue;
                attributes.put(key, value);
                continue;
            }
            if (!ATTR_TREE_CONFLICTS.equals(key) || (desc = this.getConflictDescriptor(fileName, value)) == null) continue;
            attributes.put("is-in-conflict", value);
            attributes.put("handled", ea.containsKey(fileName) && ea.get("deleted") == null ? "true" : "false");
        }
        return attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntryAttributes getAttributesFromEntriesFile(File entriesFile) throws IOException, SAXException {
        boolean isXml = false;
        BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(entriesFile), "UTF8"));
        try {
            String firstLine = fileReader.readLine();
            try {
                Integer.valueOf(firstLine);
                isXml = false;
            }
            catch (NumberFormatException ex) {
                isXml = true;
            }
            if (isXml) {
                EntryAttributes entryAttributes = this.loadAttributesFromXml(entriesFile);
                return entryAttributes;
            }
            EntryAttributes entryAttributes = this.loadAttributesFromPlainText(fileReader, entriesFile.getAbsolutePath());
            return entryAttributes;
        }
        finally {
            fileReader.close();
        }
    }

    private EntryAttributes loadAttributesFromXml(File entriesFile) throws IOException, SAXException {
        XMLReader saxReader = XMLUtil.createXMLReader();
        XmlEntriesHandler xmlEntriesHandler = new XmlEntriesHandler();
        saxReader.setContentHandler(xmlEntriesHandler);
        saxReader.setErrorHandler(xmlEntriesHandler);
        FileInputStream inputStream = new FileInputStream(entriesFile);
        try {
            saxReader.parse(new InputSource(inputStream));
        }
        catch (SAXException ex) {
            throw ex;
        }
        finally {
            ((InputStream)inputStream).close();
        }
        return xmlEntriesHandler.getEntryAttributes();
    }

    private EntryAttributes loadAttributesFromPlainText(BufferedReader entriesReader, String entryFilePath) throws IOException {
        EntryAttributes returnValue = new EntryAttributes();
        int attrIndex = 0;
        String entryName = null;
        HashMap<String, String> attributes = new HashMap<String, String>();
        String nextLine = this.attributePool.get(entriesReader.readLine());
        while (nextLine != null) {
            if (attrIndex == 0 && (entryName = nextLine).equals("")) {
                entryName = SVN_THIS_DIR;
            }
            if (!"".equals(nextLine)) {
                if (EntriesCache.isBooleanValue(entryFileAttributes[attrIndex])) {
                    nextLine = "true";
                }
                attributes.put(entryFileAttributes[attrIndex], nextLine);
            }
            if ((nextLine = this.attributePool.get(entriesReader.readLine())) != null && ++attrIndex > entryFileAttributes.length - 1) {
                Subversion.LOG.fine("Skipping attribute from position " + attrIndex + " in entry file " + entryFilePath);
                while (nextLine != null && !DELIMITER.equals(nextLine)) {
                    nextLine = this.attributePool.get(entriesReader.readLine());
                }
            }
            if (!DELIMITER.equals(nextLine)) continue;
            attributes.put("wc-version", "1.4");
            returnValue.put(entryName, attributes);
            attributes = new HashMap();
            attrIndex = 0;
            nextLine = this.attributePool.get(entriesReader.readLine());
        }
        return returnValue;
    }

    private static boolean isBooleanValue(String attribute) {
        return BOOLEAN_ATTRIBUTES.contains(attribute);
    }

    SVNConflictDescriptor getConflictDescriptor(String fileName, String conflictsDescription) {
        ConflictDescriptionParser.ParserConflictDescriptor desc = null;
        if (conflictsDescription != null) {
            ConflictDescriptionParser.ParserConflictDescriptor[] conflicts;
            for (ConflictDescriptionParser.ParserConflictDescriptor conflict : conflicts = this.getConflicts(conflictsDescription)) {
                if (!fileName.equals(conflict.getFileName())) continue;
                desc = conflict;
                break;
            }
        }
        return desc;
    }

    private synchronized ConflictDescriptionParser.ParserConflictDescriptor[] getConflicts(String conflictsDescription) {
        List<ConflictDescriptionParser.ParserConflictDescriptor> conflicts = this.cachedConflicts.get(conflictsDescription);
        if (conflicts == null) {
            ConflictDescriptionParser cdp = ConflictDescriptionParser.parseDescription(conflictsDescription);
            conflicts = cdp.getConflicts();
            this.cachedConflicts.put(conflictsDescription, conflicts);
        }
        return conflicts.toArray(new ConflictDescriptionParser.ParserConflictDescriptor[conflicts.size()]);
    }

    private Entries getEntries() {
        if (this.entries == null) {
            this.entries = new Entries();
        }
        return this.entries;
    }

    static {
        int ms;
        entryFileAttributes = new String[]{"name", "kind", "revision", "url", "repos", "schedule", "text-time", "checksum", "committed-date", "committed-rev", "last-author", "has-props", "has-prop-mods", "cachable-props", "present-props", "prop-reject-file", "conflict-old", "conflict-new", "conflict-wrk", "copied", "copyfrom-url", "copyfrom-rev", "deleted", "absent", "incomplete", "uuid", "lock-token", "lock-owner", "lock-comment", "lock-creation-date", "changelist", "keep-local", "working-size", "depth", ATTR_TREE_CONFLICTS};
        BOOLEAN_ATTRIBUTES = new HashSet<String>();
        BOOLEAN_ATTRIBUTES.add("has-props");
        BOOLEAN_ATTRIBUTES.add("has-prop-mods");
        BOOLEAN_ATTRIBUTES.add("copied");
        BOOLEAN_ATTRIBUTES.add("deleted");
        DATE_ATTRIBUTES = new HashSet<String>();
        DATE_ATTRIBUTES.add("committed-date");
        DATE_ATTRIBUTES.add("lock-creation-date");
        DATE_ATTRIBUTES.add("text-time");
        try {
            ms = Integer.parseInt(System.getProperty("org.netbeans.modules.subversion.entriescache.max_size", "200"));
        }
        catch (NumberFormatException e) {
            ms = -1;
        }
        MAX_SIZE = ms > 0 ? ms : -1;
    }

    private class AttributePool {
        private Map<String, String> m = new WeakHashMap<String, String>();

        private AttributePool() {
        }

        public String get(String str) {
            if (str == null) {
                return null;
            }
            if (EntriesCache.DELIMITER.equals(str)) {
                return EntriesCache.DELIMITER;
            }
            String val = this.m.get(str);
            if (val == null) {
                this.m.put(str, str);
                return str;
            }
            return val;
        }
    }

    private class EntryAttributes
    extends HashMap<String, Map<String, String>> {
        public EntryAttributes() {
        }

        public EntryAttributes(int initialCapacity) {
            super(initialCapacity);
        }
    }

    private class Entries
    extends LinkedHashMap<String, EntriesFile> {
        private Entries() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, EntriesFile> eldest) {
            return MAX_SIZE > -1 && this.size() > MAX_SIZE;
        }
    }

    private class EntriesFile {
        long ts;
        long size;
        EntryAttributes attributes;

        EntriesFile(EntryAttributes attributes, long ts, long size) {
            this.ts = ts;
            this.size = size;
            this.attributes = attributes;
        }
    }

    private class XmlEntriesHandler
    extends DefaultHandler {
        private static final String ENTRY_ELEMENT_NAME = "entry";
        private static final String NAME_ATTRIBUTE = "name";
        private EntryAttributes entryAttributes;

        private XmlEntriesHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes elementAttributes) throws SAXException {
            if (ENTRY_ELEMENT_NAME.equals(qName)) {
                HashMap<String, String> attributes = new HashMap<String, String>();
                for (int i = 0; i < elementAttributes.getLength(); ++i) {
                    String name = EntriesCache.this.attributePool.get(elementAttributes.getQName(i));
                    String value = EntriesCache.this.attributePool.get(elementAttributes.getValue(i));
                    attributes.put(name, value);
                }
                String nameValue = (String)attributes.get(NAME_ATTRIBUTE);
                if (nameValue == null || "".equals(nameValue)) {
                    nameValue = EntriesCache.SVN_THIS_DIR;
                }
                if (this.entryAttributes == null) {
                    this.entryAttributes = new EntryAttributes();
                }
                attributes.put("wc-version", "1.3");
                this.entryAttributes.put(nameValue, attributes);
            }
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        public EntryAttributes getEntryAttributes() {
            return this.entryAttributes;
        }
    }
}

