/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.nbtasks;

import com.sun.javacard.nbtasks.JCInstallerTask;
import java.io.File;
import org.apache.tools.ant.BuildException;

public class LoadTask
extends JCInstallerTask {
    private String bundleName;
    private File bundleFile;
    private File signatureFile;

    public void execute() throws BuildException {
        this.validateBundleName();
        this.validateBundleFile();
        this.createArg().setValue("load");
        this.createArg().setValue("--type");
        this.createArg().setValue(this.getType());
        this.createArg().setValue("--name");
        this.createArg().setValue(this.bundleName);
        boolean signBundle = this.getBool("sign.bundle");
        if (!signBundle) {
            throw new BuildException("Loading of unsigned modules is unsupported");
        }
        this.validateSignatureFile();
        this.createArg().setValue("--signature");
        this.createArg().setFile(this.signatureFile.getAbsoluteFile());
        this.createArg().setFile(this.bundleFile.getAbsoluteFile());
        super.execute();
    }

    private void validateBundleName() throws BuildException {
        if (this.bundleName == null) {
            this.bundleName = this.getProject().getProperty("display.name");
        }
        if (this.bundleName == null) {
            throw new BuildException("Bundle Name not specified");
        }
        this.bundleName = this.bundleName.trim();
        if (this.bundleName.length() <= 0) {
            throw new BuildException("Empty value for BundleName");
        }
    }

    private void validateBundleFile() throws BuildException {
        if (this.bundleFile == null) {
            this.bundleFile = this.getFileProp("dist.bundle");
        }
        if (this.bundleFile == null) {
            throw new BuildException("Bundle File not specified");
        }
        if (!this.bundleFile.exists()) {
            throw new BuildException("BundleFile '" + this.bundleFile + "' does not exist");
        }
        if (!this.bundleFile.isFile()) {
            throw new BuildException("BundleFile '" + this.bundleFile + "' is not a file");
        }
    }

    private void validateSignatureFile() throws BuildException {
        if (this.signatureFile == null) {
            this.signatureFile = this.getFileProp("dist.bundle.sig");
        }
        if (!this.signatureFile.exists()) {
            throw new BuildException("SignatureFile '" + this.signatureFile + "' does not exist");
        }
        if (!this.signatureFile.isFile()) {
            throw new BuildException("SignatureFile '" + this.signatureFile + "' is not a file");
        }
    }

    public File getBundleFile() {
        return this.bundleFile;
    }

    public void setBundleFile(File bundleFile) {
        this.bundleFile = bundleFile;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public File getSignatureFile() {
        return this.signatureFile;
    }

    public void setSignatureFile(File signatureFile) {
        this.signatureFile = signatureFile;
    }
}

