/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.wizard.components;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.UiUtils;
import org.netbeans.installer.utils.helper.NbiProperties;
import org.netbeans.installer.utils.helper.swing.NbiButton;
import org.netbeans.installer.wizard.Wizard;
import org.netbeans.installer.wizard.containers.SwingContainer;
import org.netbeans.installer.wizard.ui.SwingUi;
import org.netbeans.installer.wizard.ui.WizardUi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WizardComponent {
    private Wizard wizard;
    private List<WizardComponent> children = new ArrayList<WizardComponent>();
    private NbiProperties properties = new NbiProperties();
    public static final String TITLE_PROPERTY = "title";
    public static final String DESCRIPTION_PROPERTY = "description";
    public static final String HELP_BUTTON_TEXT_PROPERTY = "help.button.text";
    public static final String BACK_BUTTON_TEXT_PROPERTY = "back.button.text";
    public static final String NEXT_BUTTON_TEXT_PROPERTY = "next.button.text";
    public static final String CANCEL_BUTTON_TEXT_PROPERTY = "cancel.button.text";
    public static final String FINISH_BUTTON_TEXT_PROPERTY = "finish.button.text";
    private static final String DEFAULT_TITLE = ResourceUtils.getString(WizardComponent.class, "WC.title");
    private static final String DEFAULT_DESCRIPTION = ResourceUtils.getString(WizardComponent.class, "WC.description");
    private static final String DEFAULT_HELP_BUTTON_TEXT = ResourceUtils.getString(WizardComponent.class, "WC.help.button.text");
    private static final String DEFAULT_BACK_BUTTON_TEXT = ResourceUtils.getString(WizardComponent.class, "WC.back.button.text");
    private static final String DEFAULT_NEXT_BUTTON_TEXT = ResourceUtils.getString(WizardComponent.class, "WC.next.button.text");
    private static final String DEFAULT_CANCEL_BUTTON_TEXT = ResourceUtils.getString(WizardComponent.class, "WC.cancel.button.text");
    private static final String DEFAULT_FINISH_BUTTON_TEXT = ResourceUtils.getString(WizardComponent.class, "WC.finish.button.text");
    public static final String RESOURCE_CANCEL_DIALOG_TITLE = "WC.cancel.dialog.title";
    public static final String RESOURCE_CANCEL_DIALOG_TEXT = "WC.cancel.dialog.text";

    protected WizardComponent() {
        this.setProperty(TITLE_PROPERTY, DEFAULT_TITLE);
        this.setProperty(DESCRIPTION_PROPERTY, DEFAULT_DESCRIPTION);
        this.setProperty(HELP_BUTTON_TEXT_PROPERTY, DEFAULT_HELP_BUTTON_TEXT);
        this.setProperty(BACK_BUTTON_TEXT_PROPERTY, DEFAULT_BACK_BUTTON_TEXT);
        this.setProperty(NEXT_BUTTON_TEXT_PROPERTY, DEFAULT_NEXT_BUTTON_TEXT);
        this.setProperty(CANCEL_BUTTON_TEXT_PROPERTY, DEFAULT_CANCEL_BUTTON_TEXT);
        this.setProperty(FINISH_BUTTON_TEXT_PROPERTY, DEFAULT_FINISH_BUTTON_TEXT);
    }

    public abstract void executeForward();

    public abstract void executeBackward();

    public abstract void initialize();

    public boolean canExecuteForward() {
        return true;
    }

    public boolean canExecuteBackward() {
        return true;
    }

    public boolean isPointOfNoReturn() {
        return false;
    }

    public abstract WizardUi getWizardUi();

    public final Wizard getWizard() {
        return this.wizard;
    }

    public final void setWizard(Wizard wizard) {
        this.wizard = wizard;
    }

    public final void addChild(WizardComponent component) {
        this.children.add(component);
    }

    public final void removeChild(WizardComponent component) {
        this.children.remove(component);
    }

    public final void addChildren(List<WizardComponent> components) {
        this.children.addAll(components);
    }

    public final List<WizardComponent> getChildren() {
        return this.children;
    }

    public final String getProperty(String name) {
        return this.getProperty(name, true);
    }

    public final String getProperty(String name, boolean resolve) {
        String value = this.properties.getProperty(name);
        if (resolve) {
            return value != null ? this.resolveString(value) : null;
        }
        return value;
    }

    public final void setProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    public final NbiProperties getProperties() {
        return this.properties;
    }

    protected final String resolveString(String string) {
        return SystemUtils.resolveString(string, this.wizard.getClassLoader());
    }

    protected final File resolvePath(String path) {
        return SystemUtils.resolvePath(path, this.wizard.getClassLoader());
    }

    protected final String getString(String baseName, String key) {
        return ResourceUtils.getString(baseName, key, this.wizard.getClassLoader());
    }

    protected final String getString(String baseName, String key, Object ... arguments) {
        return ResourceUtils.getString(baseName, key, this.wizard.getClassLoader(), arguments);
    }

    protected final InputStream getResource(String path) {
        return ResourceUtils.getResource(path, this.wizard.getClassLoader());
    }

    public static class WizardComponentSwingUi
    extends SwingUi {
        protected WizardComponent component;
        protected SwingContainer container;

        protected WizardComponentSwingUi(WizardComponent component, SwingContainer container) {
            this.component = component;
            this.container = container;
        }

        public String getTitle() {
            return this.component.getProperty(WizardComponent.TITLE_PROPERTY);
        }

        public String getDescription() {
            return this.component.getProperty(WizardComponent.DESCRIPTION_PROPERTY);
        }

        public void evaluateHelpButtonClick() {
        }

        public void evaluateBackButtonClick() {
            this.component.getWizard().previous();
        }

        public void evaluateNextButtonClick() {
            this.component.getWizard().next();
        }

        public void evaluateCancelButtonClick() {
            String canceldialogText;
            String cancelDialogTitle = ResourceUtils.getString(WizardComponent.class, WizardComponent.RESOURCE_CANCEL_DIALOG_TITLE);
            if (UiUtils.showYesNoDialog(cancelDialogTitle, canceldialogText = ResourceUtils.getString(WizardComponent.class, WizardComponent.RESOURCE_CANCEL_DIALOG_TEXT))) {
                this.component.getWizard().getFinishHandler().cancel();
            }
        }

        public NbiButton getDefaultEnterButton() {
            return this.container.getNextButton();
        }

        public NbiButton getDefaultEscapeButton() {
            return this.container.getCancelButton();
        }

        public JComponent getDefaultFocusOwner() {
            if (this.getDefaultEnterButton() != null) {
                return this.getDefaultEnterButton();
            }
            return null;
        }

        protected void initializeContainer() {
            this.container.getHelpButton().setVisible(false);
            this.container.getHelpButton().setEnabled(false);
            this.container.getHelpButton().setText(this.component.getProperty(WizardComponent.HELP_BUTTON_TEXT_PROPERTY));
            this.container.getBackButton().setVisible(true);
            if (this.component.getWizard().hasPrevious()) {
                this.container.getBackButton().setEnabled(true);
            } else {
                this.container.getBackButton().setEnabled(false);
            }
            this.container.getBackButton().setText(this.component.getProperty(WizardComponent.BACK_BUTTON_TEXT_PROPERTY));
            this.container.getNextButton().setVisible(true);
            this.container.getNextButton().setEnabled(true);
            if (this.component.getWizard().hasNext()) {
                this.container.getNextButton().setText(this.component.getProperty(WizardComponent.NEXT_BUTTON_TEXT_PROPERTY));
            } else {
                this.container.getNextButton().setText(this.component.getProperty(WizardComponent.FINISH_BUTTON_TEXT_PROPERTY));
            }
            this.container.getCancelButton().setVisible(true);
            this.container.getCancelButton().setEnabled(true);
            this.container.getCancelButton().setText(this.component.getProperty(WizardComponent.CANCEL_BUTTON_TEXT_PROPERTY));
        }

        protected void initialize() {
        }
    }

    public static class WizardComponentUi
    implements WizardUi {
        protected WizardComponent component;
        protected WizardComponentSwingUi swingUi;

        protected WizardComponentUi(WizardComponent component) {
            this.component = component;
        }

        public SwingUi getSwingUi(SwingContainer container) {
            if (this.swingUi == null) {
                this.swingUi = new WizardComponentSwingUi(this.component, container);
            }
            this.swingUi.initializeContainer();
            this.swingUi.initialize();
            return this.swingUi;
        }
    }
}

