/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import org.netbeans.modules.hibernate.mapping.model.Array;
import org.netbeans.modules.hibernate.mapping.model.Bag;
import org.netbeans.modules.hibernate.mapping.model.Component;
import org.netbeans.modules.hibernate.mapping.model.CompositeElement;
import org.netbeans.modules.hibernate.mapping.model.DynamicComponent;
import org.netbeans.modules.hibernate.mapping.model.HibernateMapping;
import org.netbeans.modules.hibernate.mapping.model.Idbag;
import org.netbeans.modules.hibernate.mapping.model.Join;
import org.netbeans.modules.hibernate.mapping.model.JoinedSubclass;
import org.netbeans.modules.hibernate.mapping.model.KeyManyToOne;
import org.netbeans.modules.hibernate.mapping.model.List;
import org.netbeans.modules.hibernate.mapping.model.ManyToOne;
import org.netbeans.modules.hibernate.mapping.model.Map;
import org.netbeans.modules.hibernate.mapping.model.MyClass;
import org.netbeans.modules.hibernate.mapping.model.NaturalId;
import org.netbeans.modules.hibernate.mapping.model.NestedCompositeElement;
import org.netbeans.modules.hibernate.mapping.model.OneToOne;
import org.netbeans.modules.hibernate.mapping.model.Properties;
import org.netbeans.modules.hibernate.mapping.model.Set;
import org.netbeans.modules.hibernate.mapping.model.Subclass;
import org.netbeans.modules.hibernate.mapping.model.UnionSubclass;
import org.netbeans.modules.hibernate.refactoring.HibernateRefactoringUtil;

public class JavaRenameChanger {
    private final String nameAttrib = "Name";
    private final String classAttrib = "Class";
    private boolean packageOnly;
    private String origName;
    private String newName;

    public JavaRenameChanger(boolean bl, String string, String string2) {
        this.packageOnly = bl;
        this.origName = string;
        this.newName = string2;
    }

    private boolean foundPackageName(String string) {
        String string2 = HibernateRefactoringUtil.getPackageName(string);
        return string2 != null && string2.equals(this.origName);
    }

    public void refactoringImports(HibernateMapping hibernateMapping) {
        for (int i = 0; i < hibernateMapping.sizeImport(); ++i) {
            String string = hibernateMapping.getAttributeValue("Import", i, "Class");
            if (string == null) continue;
            if (this.packageOnly && this.foundPackageName(string)) {
                String string2 = string.replaceFirst(this.origName, this.newName);
                hibernateMapping.setAttributeValue("Import", i, "Class", string2);
                continue;
            }
            if (!string.equals(this.origName)) continue;
            hibernateMapping.setAttributeValue("Import", i, "Class", this.newName);
        }
    }

    public void refactoringMyClasses(MyClass[] myClassArray) {
        for (int i = 0; i < myClassArray.length; ++i) {
            String string;
            MyClass myClass = myClassArray[i];
            this.refactoringSubclasses(myClass.getSubclass());
            this.refactoringJoinedSubclasses(myClass.getJoinedSubclass());
            this.refactoringUnionSubclasses(myClass.getUnionSubclass());
            String string2 = myClass.getAttributeValue("Name");
            if (string2 != null) {
                if (this.packageOnly && this.foundPackageName(string2)) {
                    string = string2.replaceFirst(this.origName, this.newName);
                    myClassArray[i].setAttributeValue("Name", string);
                } else if (string2.equals(this.origName)) {
                    myClassArray[i].setAttributeValue("Name", this.newName);
                }
            }
            if (myClass.getCompositeId() != null && (string = myClass.getCompositeId().getAttributeValue("Class")) != null) {
                if (this.packageOnly && this.foundPackageName(string)) {
                    String string3 = string.replaceFirst(this.origName, this.newName);
                    myClass.getCompositeId().setAttributeValue("Class", string3);
                } else if (string.equals(this.origName)) {
                    myClass.getCompositeId().setAttributeValue("Class", this.newName);
                }
            }
            this.refactoringOneToOnes(myClass.getOneToOne());
            this.refactoringManyToOnes(myClass.getManyToOne());
            this.refactoringJoins(myClass.getJoin());
            this.refactoringNaturalId(myClass.getNaturalId());
            this.refactoringPropertiez(myClass.getProperties());
            this.refactoringIdBags(myClass.getIdbag());
            this.refactoringMaps(myClass.getMap());
            this.refactoringSets(myClass.getSet());
            this.refactoringLists(myClass.getList());
            this.refactoringBags(myClass.getBag());
            this.refactoringArrays(myClass.getArray());
            this.refactoringComponents(myClass.getComponent());
            this.refactoringDynamicComponents(myClass.getDynamicComponent());
        }
    }

    public void refactoringSubclasses(Subclass[] subclassArray) {
        for (int i = 0; i < subclassArray.length; ++i) {
            String string;
            Subclass subclass = subclassArray[i];
            this.refactoringSubclasses(subclass.getSubclass());
            String string2 = subclass.getAttributeValue("Name");
            if (string2 != null) {
                if (this.packageOnly && this.foundPackageName(string2)) {
                    string = string2.replaceFirst(this.origName, this.newName);
                    subclass.setAttributeValue("Name", string);
                } else if (string2.equals(this.origName)) {
                    subclass.setAttributeValue("Name", this.newName);
                }
            }
            if ((string = subclass.getAttributeValue("Extends")) != null) {
                if (this.packageOnly && this.foundPackageName(string)) {
                    String string3 = string.replaceFirst(this.origName, this.newName);
                    subclass.setAttributeValue("Extends", string3);
                } else if (string.equals(this.origName)) {
                    subclass.setAttributeValue("Extends", this.newName);
                }
            }
            this.refactoringOneToOnes(subclass.getOneToOne());
            this.refactoringJoins(subclass.getJoin());
            this.refactoringManyToOnes(subclass.getManyToOne());
            this.refactoringIdBags(subclass.getIdbag());
            this.refactoringMaps(subclass.getMap());
            this.refactoringSets(subclass.getSet());
            this.refactoringLists(subclass.getList());
            this.refactoringBags(subclass.getBag());
            this.refactoringArrays(subclass.getArray());
            this.refactoringComponents(subclass.getComponent());
            this.refactoringDynamicComponents(subclass.getDynamicComponent());
        }
    }

    public void refactoringJoinedSubclasses(JoinedSubclass[] joinedSubclassArray) {
        for (int i = 0; i < joinedSubclassArray.length; ++i) {
            String string;
            String string2;
            JoinedSubclass joinedSubclass = joinedSubclassArray[i];
            this.refactoringJoinedSubclasses(joinedSubclass.getJoinedSubclass());
            String string3 = joinedSubclass.getAttributeValue("Name");
            if (string3 != null) {
                if (this.packageOnly && this.foundPackageName(string3)) {
                    string2 = string3.replaceFirst(this.origName, this.newName);
                    joinedSubclassArray[i].setAttributeValue("Name", string2);
                } else if (string3.equals(this.origName)) {
                    joinedSubclassArray[i].setAttributeValue("Name", this.newName);
                }
            }
            this.refactoringOneToOnes(joinedSubclass.getOneToOne());
            string2 = joinedSubclass.getAttributeValue("Extends");
            if (string2 != null) {
                if (this.packageOnly && this.foundPackageName(string2)) {
                    string = string2.replaceFirst(this.origName, this.newName);
                    joinedSubclass.setAttributeValue("Extends", string);
                } else if (string2.equals(this.origName)) {
                    joinedSubclass.setAttributeValue("Extends", this.newName);
                }
            }
            if ((string = joinedSubclass.getAttributeValue("Persister")) != null) {
                if (this.packageOnly && this.foundPackageName(string)) {
                    String string4 = string.replaceFirst(this.origName, this.newName);
                    joinedSubclass.setAttributeValue("Persister", string4);
                } else if (string.equals(this.origName)) {
                    joinedSubclass.setAttributeValue("Persister", this.newName);
                }
            }
            this.refactoringManyToOnes(joinedSubclass.getManyToOne());
            this.refactoringPropertiez(joinedSubclass.getProperties());
            this.refactoringIdBags(joinedSubclass.getIdbag());
            this.refactoringMaps(joinedSubclass.getMap());
            this.refactoringSets(joinedSubclass.getSet());
            this.refactoringLists(joinedSubclass.getList());
            this.refactoringBags(joinedSubclass.getBag());
            this.refactoringArrays(joinedSubclass.getArray());
            this.refactoringComponents(joinedSubclass.getComponent());
            this.refactoringDynamicComponents(joinedSubclass.getDynamicComponent());
        }
    }

    public void refactoringUnionSubclasses(UnionSubclass[] unionSubclassArray) {
        for (int i = 0; i < unionSubclassArray.length; ++i) {
            String string;
            String string2;
            UnionSubclass unionSubclass = unionSubclassArray[i];
            this.refactoringUnionSubclasses(unionSubclass.getUnionSubclass());
            String string3 = unionSubclass.getAttributeValue("Name");
            if (string3 != null) {
                if (this.packageOnly && this.foundPackageName(string3)) {
                    string2 = string3.replaceFirst(this.origName, this.newName);
                    unionSubclassArray[i].setAttributeValue("Name", string2);
                } else if (string3.equals(this.origName)) {
                    unionSubclassArray[i].setAttributeValue("Name", this.newName);
                }
            }
            if (string3.equals(this.origName)) {
                unionSubclassArray[i].setAttributeValue("Name", this.newName);
            }
            if ((string2 = unionSubclass.getAttributeValue("Extends")) != null) {
                if (this.packageOnly && this.foundPackageName(string2)) {
                    string = string2.replaceFirst(this.origName, this.newName);
                    unionSubclass.setAttributeValue("Extends", string);
                } else if (string2.equals(this.origName)) {
                    unionSubclass.setAttributeValue("Extends", this.newName);
                }
            }
            this.refactoringOneToOnes(unionSubclass.getOneToOne());
            string = unionSubclass.getAttributeValue("Persister");
            if (string != null) {
                if (this.packageOnly && this.foundPackageName(string)) {
                    String string4 = string.replaceFirst(this.origName, this.newName);
                    unionSubclass.setAttributeValue("Persister", string4);
                } else if (string.equals(this.origName)) {
                    unionSubclass.setAttributeValue("Persister", this.newName);
                }
            }
            this.refactoringManyToOnes(unionSubclass.getManyToOne());
            this.refactoringPropertiez(unionSubclass.getProperties());
            this.refactoringIdBags(unionSubclass.getIdbag());
            this.refactoringMaps(unionSubclass.getMap());
            this.refactoringSets(unionSubclass.getSet());
            this.refactoringLists(unionSubclass.getList());
            this.refactoringBags(unionSubclass.getBag());
            this.refactoringArrays(unionSubclass.getArray());
            this.refactoringComponents(unionSubclass.getComponent());
            this.refactoringDynamicComponents(unionSubclass.getDynamicComponent());
        }
    }

    private void refactoringOneToOnes(OneToOne[] oneToOneArray) {
        for (int i = 0; i < oneToOneArray.length; ++i) {
            String string = oneToOneArray[i].getAttributeValue("Class");
            if (string == null) continue;
            if (this.packageOnly && this.foundPackageName(string)) {
                String string2 = string.replaceFirst(this.origName, this.newName);
                oneToOneArray[i].setAttributeValue("Class", string2);
                continue;
            }
            if (!string.equals(this.origName)) continue;
            oneToOneArray[i].setAttributeValue("Class", this.newName);
        }
    }

    private void refactoringNaturalId(NaturalId naturalId) {
        if (naturalId == null) {
            return;
        }
        this.refactoringManyToOnes(naturalId.getManyToOne());
        this.refactoringComponents(naturalId.getComponent());
    }

    private void refactoringPropertiez(Properties[] propertiesArray) {
        for (int i = 0; i < propertiesArray.length; ++i) {
            this.refactoringManyToOnes(propertiesArray[i].getManyToOne());
            this.refactoringComponents(propertiesArray[i].getComponent());
        }
    }

    private void refactoringJoins(Join[] joinArray) {
        for (int i = 0; i < joinArray.length; ++i) {
            Join join = joinArray[i];
            this.refactoringManyToOnes(join.getManyToOne());
            this.refactoringComponents(join.getComponent());
        }
    }

    private void refactoringComponents(Component[] componentArray) {
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            String string = component.getAttributeValue("Class");
            if (string != null) {
                if (this.packageOnly && this.foundPackageName(string)) {
                    String string2 = string.replaceFirst(this.origName, this.newName);
                    component.setAttributeValue("Class", string2);
                } else if (string.equals(this.origName)) {
                    component.setAttributeValue("Class", this.newName);
                }
            }
            this.refactoringManyToOnes(component.getManyToOne());
            this.refactoringMaps(component.getMap());
            this.refactoringSets(component.getSet());
            this.refactoringLists(component.getList());
            this.refactoringBags(component.getBag());
            this.refactoringArrays(component.getArray());
            this.refactoringOneToOnes(component.getOneToOne());
        }
    }

    private void refactoringDynamicComponents(DynamicComponent[] dynamicComponentArray) {
        for (int i = 0; i < dynamicComponentArray.length; ++i) {
            DynamicComponent dynamicComponent = dynamicComponentArray[i];
            this.refactoringManyToOnes(dynamicComponent.getManyToOne());
            this.refactoringMaps(dynamicComponent.getMap());
            this.refactoringSets(dynamicComponent.getSet());
            this.refactoringLists(dynamicComponent.getList());
            this.refactoringBags(dynamicComponent.getBag());
            this.refactoringArrays(dynamicComponent.getArray());
            this.refactoringOneToOnes(dynamicComponent.getOneToOne());
        }
    }

    private void refactoringManyToOnes(ManyToOne[] manyToOneArray) {
        for (int i = 0; i < manyToOneArray.length; ++i) {
            String string = manyToOneArray[i].getAttributeValue("Class");
            if (string == null) continue;
            if (this.packageOnly && this.foundPackageName(string)) {
                String string2 = string.replaceFirst(this.origName, this.newName);
                manyToOneArray[i].setAttributeValue("Class", string2);
                continue;
            }
            if (!string.equals(this.origName)) continue;
            manyToOneArray[i].setAttributeValue("Class", this.newName);
        }
    }

    private void refactoringMaps(Map[] mapArray) {
        for (int i = 0; i < mapArray.length; ++i) {
            String string;
            Map map = mapArray[i];
            if (map.getCompositeMapKey() != null) {
                this.refactoringKeyManyToOnes(map.getCompositeMapKey().getKeyManyToOne());
            }
            if (map.getCompositeIndex() != null) {
                this.refactoringKeyManyToOnes(map.getCompositeIndex().getKeyManyToOne());
            }
            this.refactoringCompositeElement(map.getCompositeElement());
            String string2 = map.getAttributeValue("OneToMany", "Class");
            if (string2 != null) {
                if (this.packageOnly && this.foundPackageName(string2)) {
                    string = string2.replaceFirst(this.origName, this.newName);
                    map.setAttributeValue("OneToMany", "Class", string);
                } else if (string2.equals(this.origName)) {
                    map.setAttributeValue("OneToMany", "Class", this.newName);
                }
            }
            if ((string = map.getAttributeValue("ManyToMany", "Class")) == null) continue;
            if (this.packageOnly && this.foundPackageName(string)) {
                String string3 = string.replaceFirst(this.origName, this.newName);
                map.setAttributeValue("ManyToMany", "Class", string3);
                continue;
            }
            if (!string.equals(this.origName)) continue;
            map.setAttributeValue("ManyToMany", "Class", this.newName);
        }
    }

    private void refactoringCompositeElement(CompositeElement compositeElement) {
        if (compositeElement == null) {
            return;
        }
        String string = compositeElement.getAttributeValue("Class");
        if (string != null) {
            if (this.packageOnly && this.foundPackageName(string)) {
                String string2 = string.replaceFirst(this.origName, this.newName);
                compositeElement.setAttributeValue("Class", string2);
            } else if (string.equals(this.origName)) {
                compositeElement.setAttributeValue("Class", this.newName);
            }
        }
        this.refactoringNestedCompositeElements(compositeElement.getNestedCompositeElement());
    }

    private void refactoringNestedCompositeElements(NestedCompositeElement[] nestedCompositeElementArray) {
        for (int i = 0; i < nestedCompositeElementArray.length; ++i) {
            this.refactoringManyToOnes(nestedCompositeElementArray[i].getManyToOne());
        }
    }

    private void refactoringKeyManyToOnes(KeyManyToOne[] keyManyToOneArray) {
        for (int i = 0; i < keyManyToOneArray.length; ++i) {
            KeyManyToOne keyManyToOne = keyManyToOneArray[i];
            String string = keyManyToOne.getAttributeValue("Class");
            if (string == null) continue;
            if (this.packageOnly && this.foundPackageName(string)) {
                String string2 = string.replaceFirst(this.origName, this.newName);
                keyManyToOne.setAttributeValue("Class", string2);
                continue;
            }
            if (!string.equals(this.origName)) continue;
            keyManyToOne.setAttributeValue("Class", this.newName);
        }
    }

    private void refactoringSets(Set[] setArray) {
        for (int i = 0; i < setArray.length; ++i) {
            String string;
            String string2 = setArray[i].getAttributeValue("OneToMany", "Class");
            if (string2 != null) {
                if (this.packageOnly && this.foundPackageName(string2)) {
                    string = string2.replaceFirst(this.origName, this.newName);
                    setArray[i].setAttributeValue("OneToMany", "Class", string);
                } else if (string2.equals(this.origName)) {
                    setArray[i].setAttributeValue("OneToMany", "Class", this.newName);
                }
            }
            if ((string = setArray[i].getAttributeValue("ManyToMany", "Class")) != null) {
                if (this.packageOnly && this.foundPackageName(string)) {
                    String string3 = string.replaceFirst(this.origName, this.newName);
                    setArray[i].setAttributeValue("ManyToMany", "Class", string3);
                } else if (string.equals(this.origName)) {
                    setArray[i].setAttributeValue("ManyToMany", "Class", this.newName);
                }
            }
            this.refactoringCompositeElement(setArray[i].getCompositeElement());
        }
    }

    private void refactoringLists(List[] listArray) {
        for (int i = 0; i < listArray.length; ++i) {
            String string;
            String string2 = listArray[i].getAttributeValue("OneToMany", "Class");
            if (string2 != null) {
                if (this.packageOnly && this.foundPackageName(string2)) {
                    string = string2.replaceFirst(this.origName, this.newName);
                    listArray[i].setAttributeValue("OneToMany", "Class", string);
                } else if (string2.equals(this.origName)) {
                    listArray[i].setAttributeValue("OneToMany", "Class", this.newName);
                }
            }
            if ((string = listArray[i].getAttributeValue("ManyToMany", "Class")) != null) {
                if (this.packageOnly && this.foundPackageName(string)) {
                    String string3 = string.replaceFirst(this.origName, this.newName);
                    listArray[i].setAttributeValue("ManyToMany", "Class", string3);
                } else if (string.equals(this.origName)) {
                    listArray[i].setAttributeValue("ManyToMany", "Class", this.newName);
                }
            }
            this.refactoringCompositeElement(listArray[i].getCompositeElement());
        }
    }

    private void refactoringBags(Bag[] bagArray) {
        for (int i = 0; i < bagArray.length; ++i) {
            String string;
            String string2 = bagArray[i].getAttributeValue("OneToMany", "Class");
            if (string2 != null) {
                if (this.packageOnly && this.foundPackageName(string2)) {
                    string = string2.replaceFirst(this.origName, this.newName);
                    bagArray[i].setAttributeValue("OneToMany", "Class", string);
                } else if (string2.equals(this.origName)) {
                    bagArray[i].setAttributeValue("OneToMany", "Class", this.newName);
                }
            }
            if ((string = bagArray[i].getAttributeValue("ManyToMany", "Class")) != null) {
                if (this.packageOnly && this.foundPackageName(string)) {
                    String string3 = string.replaceFirst(this.origName, this.newName);
                    bagArray[i].setAttributeValue("ManyToMany", "Class", string3);
                } else if (string.equals(this.origName)) {
                    bagArray[i].setAttributeValue("ManyToMany", "Class", this.newName);
                }
            }
            this.refactoringCompositeElement(bagArray[i].getCompositeElement());
        }
    }

    private void refactoringIdBags(Idbag[] idbagArray) {
        for (int i = 0; i < idbagArray.length; ++i) {
            this.refactoringCompositeElement(idbagArray[i].getCompositeElement());
            String string = idbagArray[i].getAttributeValue("ManyToMany", "Class");
            if (string == null) continue;
            if (this.packageOnly && this.foundPackageName(string)) {
                String string2 = string.replaceFirst(this.origName, this.newName);
                idbagArray[i].setAttributeValue("ManyToMany", "Class", string2);
                continue;
            }
            if (!string.equals(this.origName)) continue;
            idbagArray[i].setAttributeValue("ManyToMany", "Class", this.newName);
        }
    }

    private void refactoringArrays(Array[] arrayArray) {
        for (int i = 0; i < arrayArray.length; ++i) {
            String string;
            String string2 = arrayArray[i].getAttributeValue("OneToMany", "Class");
            if (string2 != null) {
                if (this.packageOnly && this.foundPackageName(string2)) {
                    string = string2.replaceFirst(this.origName, this.newName);
                    arrayArray[i].setAttributeValue("OneToMany", "Class", string);
                } else if (string2.equals(this.origName)) {
                    arrayArray[i].setAttributeValue("OneToMany", "Class", this.newName);
                }
            }
            if ((string = arrayArray[i].getAttributeValue("ManyToMany", "Class")) != null) {
                if (this.packageOnly && this.foundPackageName(string)) {
                    String string3 = string.replaceFirst(this.origName, this.newName);
                    arrayArray[i].setAttributeValue("ManyToMany", "Class", string3);
                } else if (string.equals(this.origName)) {
                    arrayArray[i].setAttributeValue("ManyToMany", "Class", this.newName);
                }
            }
            this.refactoringCompositeElement(arrayArray[i].getCompositeElement());
        }
    }
}

