/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.validator;

import com.sun.javacard.validator.ErrorKey;
import com.sun.javacard.validator.PackageItem;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ValidValues {
    private static final int FIXED_RID_LENGTH = 10;
    private static final int MAX_PIX_LENGTH = 22;
    private static Vector<String> APPLICATION_TYPES = new Vector<String>(){
        {
            this.addElement("web");
            this.addElement("extended-applet");
            this.addElement("classic-applet");
            this.addElement("extension-lib");
            this.addElement("classic-lib");
        }
    };
    private static Vector<String> LIBRARY_TYPES = new Vector<String>(){
        {
            this.addElement("extension-lib");
            this.addElement("classic-lib");
        }
    };
    private static Vector<String> CREDENTIAL_AUTH_DURATIONS = new Vector<String>(){
        {
            this.addElement("access");
            this.addElement("card-session");
            this.addElement("client-lifetime");
        }
    };
    private static Vector<String> CREDENTIAL_AUTH_TYPES = new Vector<String>(){
        {
            this.addElement("client-only");
        }
    };
    private static Vector<String> BOOLEAN_VALUES = new Vector<String>(){
        {
            this.addElement("true");
            this.addElement("false");
        }
    };
    private static Vector<String> AUTH_METHODS = new Vector<String>(){
        {
            this.addElement("FORM");
            this.addElement("DIGEST");
            this.addElement("BASIC");
        }
    };

    public static boolean isValidAppType(String string) {
        if (string == null) {
            return false;
        }
        return APPLICATION_TYPES.contains(string);
    }

    public static boolean isValidLibType(String string) {
        if (string == null) {
            return false;
        }
        return LIBRARY_TYPES.contains(string);
    }

    public static boolean isValidCredentialAuthDuration(String string) {
        return CREDENTIAL_AUTH_DURATIONS.contains(string);
    }

    public static boolean isValidCredentialAuthType(String string) {
        return CREDENTIAL_AUTH_TYPES.contains(string);
    }

    public static boolean isValidBoolean(String string) {
        return BOOLEAN_VALUES.contains(string);
    }

    public static boolean isValidNNMToken(String string) {
        Pattern pattern = Pattern.compile("[A-Za-z0-9:._\\Q-\\E]*");
        Matcher matcher = pattern.matcher(string);
        matcher = matcher.reset();
        return matcher.matches();
    }

    public static boolean isValidAuthMethod(String string) {
        if (AUTH_METHODS.contains(string)) {
            return true;
        }
        return string.startsWith("JC-");
    }

    public static boolean isValidAID(String string, String string2, PackageItem packageItem) {
        String string3 = "//aid/";
        if (!string.startsWith(string3)) {
            packageItem.addError(ErrorKey.InvalidAID, string);
            return false;
        }
        String string4 = string.substring(string3.length());
        int n = string4.lastIndexOf("/");
        if (n == -1) {
            packageItem.addError(ErrorKey.MissingPIX, string);
            return false;
        }
        if (n != string4.indexOf("/")) {
            packageItem.addError(ErrorKey.InvalidAID, string);
            return false;
        }
        String string5 = string4.substring(0, n);
        String string6 = string4.substring(n + 1);
        if (string5.length() != 10) {
            packageItem.addError(ErrorKey.InvalidRID, string5, string);
            return false;
        }
        if (string5.startsWith("-")) {
            packageItem.addError(ErrorKey.RIDStartsWithDash, string);
            return false;
        }
        if (!ValidValues.isValidHexadecimalNumber(string5)) {
            packageItem.addError(ErrorKey.RIDIsNotHexNumber, string);
            return false;
        }
        if (string6.equals("-")) {
            return true;
        }
        if (string6.length() == 0) {
            packageItem.addError(ErrorKey.EmptyPIX, string);
            return false;
        }
        if (string6.startsWith("-")) {
            packageItem.addError(ErrorKey.PIXStartsWithDash, string);
            return false;
        }
        if (string6.length() % 2 != 0 || string6.length() > 22) {
            packageItem.addError(ErrorKey.InvalidPIXLength, string);
            return false;
        }
        if (!ValidValues.isValidHexadecimalNumber(string6)) {
            packageItem.addError(ErrorKey.PIXIsNotHexNumber, string);
            return false;
        }
        return true;
    }

    public static boolean isValidHexadecimalNumber(String string) {
        for (int i = 0; i < string.length(); i += 2) {
            String string2 = string.substring(i, i + 2);
            try {
                Integer.parseInt(string2, 16);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println(numberFormatException.toString());
                return false;
            }
        }
        return true;
    }
}

