/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.exportfile;

import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.exportfile.EfConstant;
import com.sun.javacard.exportfile.EfConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class EfConstantUtf8
extends EfConstant {
    private String utf8String;
    private byte[] utf8Bytes;
    private EfConstantPool constant_pool;

    public EfConstantUtf8(EfConstantPool efConstantPool) {
        this.constant_pool = efConstantPool;
    }

    public EfConstantUtf8(EfConstantPool efConstantPool, String string) {
        this.constant_pool = efConstantPool;
        this.utf8String = string;
        try {
            this.utf8Bytes = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ConverterInternalError(unsupportedEncodingException.getMessage());
        }
    }

    @Override
    public void parse(DataInputStream dataInputStream) throws IOException {
        this.utf8Bytes = new byte[dataInputStream.readUnsignedShort()];
        dataInputStream.readFully(this.utf8Bytes);
        this.utf8String = new String(this.utf8Bytes, "UTF8");
    }

    public String getUtf8String() {
        return this.utf8String;
    }

    public byte[] getUtf8Bytes() {
        return this.utf8Bytes;
    }

    @Override
    public void toText(PrintWriter printWriter, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\t");
        }
        String string = stringBuffer.toString();
        printWriter.println(string + "Constant_Utf8_info {");
        printWriter.println(string + "\ttag\t" + 1);
        printWriter.println(string + "\tlength\t" + this.utf8Bytes.length);
        printWriter.println(string + "\tbytes\t" + this.utf8String);
        printWriter.println(string + "}");
    }

    @Override
    public void toBinary(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(1);
        dataOutputStream.writeShort(this.utf8Bytes.length);
        dataOutputStream.write(this.utf8Bytes, 0, this.utf8Bytes.length);
    }
}

