/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ui.LibrariesNode;
import org.netbeans.modules.apisupport.project.ui.UnitTestLibrariesNode;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;

public class LibrariesNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project p) {
        NbModuleProject proj = (NbModuleProject)p.getLookup().lookup(NbModuleProject.class);
        assert (proj != null);
        return new LibraryNL(proj);
    }

    private static class LibraryNL
    implements NodeList<String> {
        private NbModuleProject project;

        LibraryNL(NbModuleProject prj) {
            this.project = prj;
        }

        public List<String> keys() {
            ArrayList<String> toRet = new ArrayList<String>();
            toRet.add("libraries");
            for (String testType : this.project.supportedTestTypes()) {
                toRet.add(testType);
            }
            return toRet;
        }

        private FileObject resolveFileObjectFromProperty(String property) {
            String filename = this.project.evaluator().getProperty(property);
            if (filename == null) {
                return null;
            }
            return this.project.getHelper().resolveFileObject(filename);
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }

        public Node node(String key) {
            if (key == "libraries") {
                return new LibrariesNode(this.project);
            }
            return new UnitTestLibrariesNode(key, this.project);
        }

        public void addNotify() {
        }

        public void removeNotify() {
        }
    }
}

